# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['RouteServerPropagationArgs', 'RouteServerPropagation']

@pulumi.input_type
class RouteServerPropagationArgs:
    def __init__(__self__, *,
                 route_server_id: pulumi.Input[builtins.str],
                 route_table_id: pulumi.Input[builtins.str]):
        """
        The set of arguments for constructing a RouteServerPropagation resource.
        :param pulumi.Input[builtins.str] route_server_id: Route Server ID
        :param pulumi.Input[builtins.str] route_table_id: Route Table ID
        """
        pulumi.set(__self__, "route_server_id", route_server_id)
        pulumi.set(__self__, "route_table_id", route_table_id)

    @property
    @pulumi.getter(name="routeServerId")
    def route_server_id(self) -> pulumi.Input[builtins.str]:
        """
        Route Server ID
        """
        return pulumi.get(self, "route_server_id")

    @route_server_id.setter
    def route_server_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "route_server_id", value)

    @property
    @pulumi.getter(name="routeTableId")
    def route_table_id(self) -> pulumi.Input[builtins.str]:
        """
        Route Table ID
        """
        return pulumi.get(self, "route_table_id")

    @route_table_id.setter
    def route_table_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "route_table_id", value)


@pulumi.type_token("aws-native:ec2:RouteServerPropagation")
class RouteServerPropagation(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 route_server_id: Optional[pulumi.Input[builtins.str]] = None,
                 route_table_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        VPC Route Server Propagation

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] route_server_id: Route Server ID
        :param pulumi.Input[builtins.str] route_table_id: Route Table ID
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RouteServerPropagationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        VPC Route Server Propagation

        :param str resource_name: The name of the resource.
        :param RouteServerPropagationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RouteServerPropagationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 route_server_id: Optional[pulumi.Input[builtins.str]] = None,
                 route_table_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RouteServerPropagationArgs.__new__(RouteServerPropagationArgs)

            if route_server_id is None and not opts.urn:
                raise TypeError("Missing required property 'route_server_id'")
            __props__.__dict__["route_server_id"] = route_server_id
            if route_table_id is None and not opts.urn:
                raise TypeError("Missing required property 'route_table_id'")
            __props__.__dict__["route_table_id"] = route_table_id
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["routeServerId", "routeTableId"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(RouteServerPropagation, __self__).__init__(
            'aws-native:ec2:RouteServerPropagation',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'RouteServerPropagation':
        """
        Get an existing RouteServerPropagation resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = RouteServerPropagationArgs.__new__(RouteServerPropagationArgs)

        __props__.__dict__["route_server_id"] = None
        __props__.__dict__["route_table_id"] = None
        return RouteServerPropagation(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="routeServerId")
    def route_server_id(self) -> pulumi.Output[builtins.str]:
        """
        Route Server ID
        """
        return pulumi.get(self, "route_server_id")

    @property
    @pulumi.getter(name="routeTableId")
    def route_table_id(self) -> pulumi.Output[builtins.str]:
        """
        Route Table ID
        """
        return pulumi.get(self, "route_table_id")

