# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._enums import *
from ._inputs import *

__all__ = ['RouteServerPeerArgs', 'RouteServerPeer']

@pulumi.input_type
class RouteServerPeerArgs:
    def __init__(__self__, *,
                 bgp_options: pulumi.Input['RouteServerPeerBgpOptionsArgs'],
                 peer_address: pulumi.Input[builtins.str],
                 route_server_endpoint_id: pulumi.Input[builtins.str],
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None):
        """
        The set of arguments for constructing a RouteServerPeer resource.
        :param pulumi.Input['RouteServerPeerBgpOptionsArgs'] bgp_options: The BGP configuration options for this peer, including ASN (Autonomous System Number) and BFD (Bidrectional Forwarding Detection) settings.
        :param pulumi.Input[builtins.str] peer_address: IP address of the Route Server Peer
        :param pulumi.Input[builtins.str] route_server_endpoint_id: Route Server Endpoint ID
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: An array of key-value pairs to apply to this resource.
        """
        pulumi.set(__self__, "bgp_options", bgp_options)
        pulumi.set(__self__, "peer_address", peer_address)
        pulumi.set(__self__, "route_server_endpoint_id", route_server_endpoint_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="bgpOptions")
    def bgp_options(self) -> pulumi.Input['RouteServerPeerBgpOptionsArgs']:
        """
        The BGP configuration options for this peer, including ASN (Autonomous System Number) and BFD (Bidrectional Forwarding Detection) settings.
        """
        return pulumi.get(self, "bgp_options")

    @bgp_options.setter
    def bgp_options(self, value: pulumi.Input['RouteServerPeerBgpOptionsArgs']):
        pulumi.set(self, "bgp_options", value)

    @property
    @pulumi.getter(name="peerAddress")
    def peer_address(self) -> pulumi.Input[builtins.str]:
        """
        IP address of the Route Server Peer
        """
        return pulumi.get(self, "peer_address")

    @peer_address.setter
    def peer_address(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "peer_address", value)

    @property
    @pulumi.getter(name="routeServerEndpointId")
    def route_server_endpoint_id(self) -> pulumi.Input[builtins.str]:
        """
        Route Server Endpoint ID
        """
        return pulumi.get(self, "route_server_endpoint_id")

    @route_server_endpoint_id.setter
    def route_server_endpoint_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "route_server_endpoint_id", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("aws-native:ec2:RouteServerPeer")
class RouteServerPeer(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bgp_options: Optional[pulumi.Input[Union['RouteServerPeerBgpOptionsArgs', 'RouteServerPeerBgpOptionsArgsDict']]] = None,
                 peer_address: Optional[pulumi.Input[builtins.str]] = None,
                 route_server_endpoint_id: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        """
        VPC Route Server Peer

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['RouteServerPeerBgpOptionsArgs', 'RouteServerPeerBgpOptionsArgsDict']] bgp_options: The BGP configuration options for this peer, including ASN (Autonomous System Number) and BFD (Bidrectional Forwarding Detection) settings.
        :param pulumi.Input[builtins.str] peer_address: IP address of the Route Server Peer
        :param pulumi.Input[builtins.str] route_server_endpoint_id: Route Server Endpoint ID
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: An array of key-value pairs to apply to this resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RouteServerPeerArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        VPC Route Server Peer

        :param str resource_name: The name of the resource.
        :param RouteServerPeerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RouteServerPeerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bgp_options: Optional[pulumi.Input[Union['RouteServerPeerBgpOptionsArgs', 'RouteServerPeerBgpOptionsArgsDict']]] = None,
                 peer_address: Optional[pulumi.Input[builtins.str]] = None,
                 route_server_endpoint_id: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RouteServerPeerArgs.__new__(RouteServerPeerArgs)

            if bgp_options is None and not opts.urn:
                raise TypeError("Missing required property 'bgp_options'")
            __props__.__dict__["bgp_options"] = bgp_options
            if peer_address is None and not opts.urn:
                raise TypeError("Missing required property 'peer_address'")
            __props__.__dict__["peer_address"] = peer_address
            if route_server_endpoint_id is None and not opts.urn:
                raise TypeError("Missing required property 'route_server_endpoint_id'")
            __props__.__dict__["route_server_endpoint_id"] = route_server_endpoint_id
            __props__.__dict__["tags"] = tags
            __props__.__dict__["arn"] = None
            __props__.__dict__["aws_id"] = None
            __props__.__dict__["endpoint_eni_address"] = None
            __props__.__dict__["endpoint_eni_id"] = None
            __props__.__dict__["route_server_id"] = None
            __props__.__dict__["subnet_id"] = None
            __props__.__dict__["vpc_id"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["bgpOptions", "peerAddress", "routeServerEndpointId"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(RouteServerPeer, __self__).__init__(
            'aws-native:ec2:RouteServerPeer',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'RouteServerPeer':
        """
        Get an existing RouteServerPeer resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = RouteServerPeerArgs.__new__(RouteServerPeerArgs)

        __props__.__dict__["arn"] = None
        __props__.__dict__["aws_id"] = None
        __props__.__dict__["bgp_options"] = None
        __props__.__dict__["endpoint_eni_address"] = None
        __props__.__dict__["endpoint_eni_id"] = None
        __props__.__dict__["peer_address"] = None
        __props__.__dict__["route_server_endpoint_id"] = None
        __props__.__dict__["route_server_id"] = None
        __props__.__dict__["subnet_id"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["vpc_id"] = None
        return RouteServerPeer(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the Route Server Peer.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="awsId")
    def aws_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the Route Server Peer.
        """
        return pulumi.get(self, "aws_id")

    @property
    @pulumi.getter(name="bgpOptions")
    def bgp_options(self) -> pulumi.Output['outputs.RouteServerPeerBgpOptions']:
        """
        The BGP configuration options for this peer, including ASN (Autonomous System Number) and BFD (Bidrectional Forwarding Detection) settings.
        """
        return pulumi.get(self, "bgp_options")

    @property
    @pulumi.getter(name="endpointEniAddress")
    def endpoint_eni_address(self) -> pulumi.Output[builtins.str]:
        """
        Elastic Network Interface IP address owned by the Route Server Endpoint
        """
        return pulumi.get(self, "endpoint_eni_address")

    @property
    @pulumi.getter(name="endpointEniId")
    def endpoint_eni_id(self) -> pulumi.Output[builtins.str]:
        """
        Elastic Network Interface ID owned by the Route Server Endpoint
        """
        return pulumi.get(self, "endpoint_eni_id")

    @property
    @pulumi.getter(name="peerAddress")
    def peer_address(self) -> pulumi.Output[builtins.str]:
        """
        IP address of the Route Server Peer
        """
        return pulumi.get(self, "peer_address")

    @property
    @pulumi.getter(name="routeServerEndpointId")
    def route_server_endpoint_id(self) -> pulumi.Output[builtins.str]:
        """
        Route Server Endpoint ID
        """
        return pulumi.get(self, "route_server_endpoint_id")

    @property
    @pulumi.getter(name="routeServerId")
    def route_server_id(self) -> pulumi.Output[builtins.str]:
        """
        Route Server ID
        """
        return pulumi.get(self, "route_server_id")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Output[builtins.str]:
        """
        Subnet ID
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[builtins.str]:
        """
        VPC ID
        """
        return pulumi.get(self, "vpc_id")

