# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._enums import *

__all__ = ['RouteServerArgs', 'RouteServer']

@pulumi.input_type
class RouteServerArgs:
    def __init__(__self__, *,
                 amazon_side_asn: pulumi.Input[builtins.int],
                 persist_routes: Optional[pulumi.Input['RouteServerPersistRoutes']] = None,
                 persist_routes_duration: Optional[pulumi.Input[builtins.int]] = None,
                 sns_notifications_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None):
        """
        The set of arguments for constructing a RouteServer resource.
        :param pulumi.Input[builtins.int] amazon_side_asn: The Amazon-side ASN of the Route Server.
        :param pulumi.Input['RouteServerPersistRoutes'] persist_routes: Whether to enable persistent routes
        :param pulumi.Input[builtins.int] persist_routes_duration: The duration of persistent routes in minutes
        :param pulumi.Input[builtins.bool] sns_notifications_enabled: Whether to enable SNS notifications
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: An array of key-value pairs to apply to this resource.
        """
        pulumi.set(__self__, "amazon_side_asn", amazon_side_asn)
        if persist_routes is not None:
            pulumi.set(__self__, "persist_routes", persist_routes)
        if persist_routes_duration is not None:
            pulumi.set(__self__, "persist_routes_duration", persist_routes_duration)
        if sns_notifications_enabled is not None:
            pulumi.set(__self__, "sns_notifications_enabled", sns_notifications_enabled)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="amazonSideAsn")
    def amazon_side_asn(self) -> pulumi.Input[builtins.int]:
        """
        The Amazon-side ASN of the Route Server.
        """
        return pulumi.get(self, "amazon_side_asn")

    @amazon_side_asn.setter
    def amazon_side_asn(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "amazon_side_asn", value)

    @property
    @pulumi.getter(name="persistRoutes")
    def persist_routes(self) -> Optional[pulumi.Input['RouteServerPersistRoutes']]:
        """
        Whether to enable persistent routes
        """
        return pulumi.get(self, "persist_routes")

    @persist_routes.setter
    def persist_routes(self, value: Optional[pulumi.Input['RouteServerPersistRoutes']]):
        pulumi.set(self, "persist_routes", value)

    @property
    @pulumi.getter(name="persistRoutesDuration")
    def persist_routes_duration(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The duration of persistent routes in minutes
        """
        return pulumi.get(self, "persist_routes_duration")

    @persist_routes_duration.setter
    def persist_routes_duration(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "persist_routes_duration", value)

    @property
    @pulumi.getter(name="snsNotificationsEnabled")
    def sns_notifications_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to enable SNS notifications
        """
        return pulumi.get(self, "sns_notifications_enabled")

    @sns_notifications_enabled.setter
    def sns_notifications_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "sns_notifications_enabled", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("aws-native:ec2:RouteServer")
class RouteServer(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 amazon_side_asn: Optional[pulumi.Input[builtins.int]] = None,
                 persist_routes: Optional[pulumi.Input['RouteServerPersistRoutes']] = None,
                 persist_routes_duration: Optional[pulumi.Input[builtins.int]] = None,
                 sns_notifications_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        """
        VPC Route Server

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.int] amazon_side_asn: The Amazon-side ASN of the Route Server.
        :param pulumi.Input['RouteServerPersistRoutes'] persist_routes: Whether to enable persistent routes
        :param pulumi.Input[builtins.int] persist_routes_duration: The duration of persistent routes in minutes
        :param pulumi.Input[builtins.bool] sns_notifications_enabled: Whether to enable SNS notifications
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: An array of key-value pairs to apply to this resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RouteServerArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        VPC Route Server

        :param str resource_name: The name of the resource.
        :param RouteServerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RouteServerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 amazon_side_asn: Optional[pulumi.Input[builtins.int]] = None,
                 persist_routes: Optional[pulumi.Input['RouteServerPersistRoutes']] = None,
                 persist_routes_duration: Optional[pulumi.Input[builtins.int]] = None,
                 sns_notifications_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RouteServerArgs.__new__(RouteServerArgs)

            if amazon_side_asn is None and not opts.urn:
                raise TypeError("Missing required property 'amazon_side_asn'")
            __props__.__dict__["amazon_side_asn"] = amazon_side_asn
            __props__.__dict__["persist_routes"] = persist_routes
            __props__.__dict__["persist_routes_duration"] = persist_routes_duration
            __props__.__dict__["sns_notifications_enabled"] = sns_notifications_enabled
            __props__.__dict__["tags"] = tags
            __props__.__dict__["arn"] = None
            __props__.__dict__["aws_id"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["amazonSideAsn"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(RouteServer, __self__).__init__(
            'aws-native:ec2:RouteServer',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'RouteServer':
        """
        Get an existing RouteServer resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = RouteServerArgs.__new__(RouteServerArgs)

        __props__.__dict__["amazon_side_asn"] = None
        __props__.__dict__["arn"] = None
        __props__.__dict__["aws_id"] = None
        __props__.__dict__["persist_routes"] = None
        __props__.__dict__["persist_routes_duration"] = None
        __props__.__dict__["sns_notifications_enabled"] = None
        __props__.__dict__["tags"] = None
        return RouteServer(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="amazonSideAsn")
    def amazon_side_asn(self) -> pulumi.Output[builtins.int]:
        """
        The Amazon-side ASN of the Route Server.
        """
        return pulumi.get(self, "amazon_side_asn")

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the Route Server.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="awsId")
    def aws_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the Route Server.
        """
        return pulumi.get(self, "aws_id")

    @property
    @pulumi.getter(name="persistRoutes")
    def persist_routes(self) -> pulumi.Output[Optional['RouteServerPersistRoutes']]:
        """
        Whether to enable persistent routes
        """
        return pulumi.get(self, "persist_routes")

    @property
    @pulumi.getter(name="persistRoutesDuration")
    def persist_routes_duration(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The duration of persistent routes in minutes
        """
        return pulumi.get(self, "persist_routes_duration")

    @property
    @pulumi.getter(name="snsNotificationsEnabled")
    def sns_notifications_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Whether to enable SNS notifications
        """
        return pulumi.get(self, "sns_notifications_enabled")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")

