# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._inputs import *

__all__ = ['NetworkInterfaceArgs', 'NetworkInterface']

@pulumi.input_type
class NetworkInterfaceArgs:
    def __init__(__self__, *,
                 subnet_id: pulumi.Input[builtins.str],
                 connection_tracking_specification: Optional[pulumi.Input['NetworkInterfaceConnectionTrackingSpecificationArgs']] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 enable_primary_ipv6: Optional[pulumi.Input[builtins.bool]] = None,
                 group_set: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 interface_type: Optional[pulumi.Input[builtins.str]] = None,
                 ipv4_prefix_count: Optional[pulumi.Input[builtins.int]] = None,
                 ipv4_prefixes: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkInterfaceIpv4PrefixSpecificationArgs']]]] = None,
                 ipv6_address_count: Optional[pulumi.Input[builtins.int]] = None,
                 ipv6_addresses: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkInterfaceInstanceIpv6AddressArgs']]]] = None,
                 ipv6_prefix_count: Optional[pulumi.Input[builtins.int]] = None,
                 ipv6_prefixes: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkInterfaceIpv6PrefixSpecificationArgs']]]] = None,
                 private_ip_address: Optional[pulumi.Input[builtins.str]] = None,
                 private_ip_addresses: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkInterfacePrivateIpAddressSpecificationArgs']]]] = None,
                 secondary_private_ip_address_count: Optional[pulumi.Input[builtins.int]] = None,
                 source_dest_check: Optional[pulumi.Input[builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None):
        """
        The set of arguments for constructing a NetworkInterface resource.
        :param pulumi.Input[builtins.str] subnet_id: The ID of the subnet to associate with the network interface.
        :param pulumi.Input['NetworkInterfaceConnectionTrackingSpecificationArgs'] connection_tracking_specification: A connection tracking specification for the network interface.
        :param pulumi.Input[builtins.str] description: A description for the network interface.
        :param pulumi.Input[builtins.bool] enable_primary_ipv6: If you have instances or ENIs that rely on the IPv6 address not changing, to avoid disrupting traffic to instances or ENIs, you can enable a primary IPv6 address. Enable this option to automatically assign an IPv6 associated with the ENI attached to your instance to be the primary IPv6 address. When you enable an IPv6 address to be a primary IPv6, you cannot disable it. Traffic will be routed to the primary IPv6 address until the instance is terminated or the ENI is detached. If you have multiple IPv6 addresses associated with an ENI and you enable a primary IPv6 address, the first IPv6 address associated with the ENI becomes the primary IPv6 address.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] group_set: A list of security group IDs associated with this network interface.
        :param pulumi.Input[builtins.str] interface_type: Indicates the type of network interface.
        :param pulumi.Input[builtins.int] ipv4_prefix_count: The number of IPv4 prefixes to assign to a network interface. When you specify a number of IPv4 prefixes, Amazon EC2 selects these prefixes from your existing subnet CIDR reservations, if available, or from free spaces in the subnet. By default, these will be /28 prefixes. You can't specify a count of IPv4 prefixes if you've specified one of the following: specific IPv4 prefixes, specific private IPv4 addresses, or a count of private IPv4 addresses.
        :param pulumi.Input[Sequence[pulumi.Input['NetworkInterfaceIpv4PrefixSpecificationArgs']]] ipv4_prefixes: Assigns a list of IPv4 prefixes to the network interface. If you want EC2 to automatically assign IPv4 prefixes, use the Ipv4PrefixCount property and do not specify this property. Presently, only /28 prefixes are supported. You can't specify IPv4 prefixes if you've specified one of the following: a count of IPv4 prefixes, specific private IPv4 addresses, or a count of private IPv4 addresses.
        :param pulumi.Input[builtins.int] ipv6_address_count: The number of IPv6 addresses to assign to a network interface. Amazon EC2 automatically selects the IPv6 addresses from the subnet range. To specify specific IPv6 addresses, use the Ipv6Addresses property and don't specify this property.
        :param pulumi.Input[Sequence[pulumi.Input['NetworkInterfaceInstanceIpv6AddressArgs']]] ipv6_addresses: One or more specific IPv6 addresses from the IPv6 CIDR block range of your subnet to associate with the network interface. If you're specifying a number of IPv6 addresses, use the Ipv6AddressCount property and don't specify this property.
        :param pulumi.Input[builtins.int] ipv6_prefix_count: The number of IPv6 prefixes to assign to a network interface. When you specify a number of IPv6 prefixes, Amazon EC2 selects these prefixes from your existing subnet CIDR reservations, if available, or from free spaces in the subnet. By default, these will be /80 prefixes. You can't specify a count of IPv6 prefixes if you've specified one of the following: specific IPv6 prefixes, specific IPv6 addresses, or a count of IPv6 addresses.
        :param pulumi.Input[Sequence[pulumi.Input['NetworkInterfaceIpv6PrefixSpecificationArgs']]] ipv6_prefixes: Assigns a list of IPv6 prefixes to the network interface. If you want EC2 to automatically assign IPv6 prefixes, use the Ipv6PrefixCount property and do not specify this property. Presently, only /80 prefixes are supported. You can't specify IPv6 prefixes if you've specified one of the following: a count of IPv6 prefixes, specific IPv6 addresses, or a count of IPv6 addresses.
        :param pulumi.Input[builtins.str] private_ip_address: Assigns a single private IP address to the network interface, which is used as the primary private IP address. If you want to specify multiple private IP address, use the PrivateIpAddresses property. 
        :param pulumi.Input[Sequence[pulumi.Input['NetworkInterfacePrivateIpAddressSpecificationArgs']]] private_ip_addresses: Assigns a list of private IP addresses to the network interface. You can specify a primary private IP address by setting the value of the Primary property to true in the PrivateIpAddressSpecification property. If you want EC2 to automatically assign private IP addresses, use the SecondaryPrivateIpAddressCount property and do not specify this property.
        :param pulumi.Input[builtins.int] secondary_private_ip_address_count: The number of secondary private IPv4 addresses to assign to a network interface. When you specify a number of secondary IPv4 addresses, Amazon EC2 selects these IP addresses within the subnet's IPv4 CIDR range. You can't specify this option and specify more than one private IP address using privateIpAddresses
        :param pulumi.Input[builtins.bool] source_dest_check: Indicates whether traffic to or from the instance is validated.
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: An arbitrary set of tags (key-value pairs) for this network interface.
        """
        pulumi.set(__self__, "subnet_id", subnet_id)
        if connection_tracking_specification is not None:
            pulumi.set(__self__, "connection_tracking_specification", connection_tracking_specification)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enable_primary_ipv6 is not None:
            pulumi.set(__self__, "enable_primary_ipv6", enable_primary_ipv6)
        if group_set is not None:
            pulumi.set(__self__, "group_set", group_set)
        if interface_type is not None:
            pulumi.set(__self__, "interface_type", interface_type)
        if ipv4_prefix_count is not None:
            pulumi.set(__self__, "ipv4_prefix_count", ipv4_prefix_count)
        if ipv4_prefixes is not None:
            pulumi.set(__self__, "ipv4_prefixes", ipv4_prefixes)
        if ipv6_address_count is not None:
            pulumi.set(__self__, "ipv6_address_count", ipv6_address_count)
        if ipv6_addresses is not None:
            pulumi.set(__self__, "ipv6_addresses", ipv6_addresses)
        if ipv6_prefix_count is not None:
            pulumi.set(__self__, "ipv6_prefix_count", ipv6_prefix_count)
        if ipv6_prefixes is not None:
            pulumi.set(__self__, "ipv6_prefixes", ipv6_prefixes)
        if private_ip_address is not None:
            pulumi.set(__self__, "private_ip_address", private_ip_address)
        if private_ip_addresses is not None:
            pulumi.set(__self__, "private_ip_addresses", private_ip_addresses)
        if secondary_private_ip_address_count is not None:
            pulumi.set(__self__, "secondary_private_ip_address_count", secondary_private_ip_address_count)
        if source_dest_check is not None:
            pulumi.set(__self__, "source_dest_check", source_dest_check)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the subnet to associate with the network interface.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter(name="connectionTrackingSpecification")
    def connection_tracking_specification(self) -> Optional[pulumi.Input['NetworkInterfaceConnectionTrackingSpecificationArgs']]:
        """
        A connection tracking specification for the network interface.
        """
        return pulumi.get(self, "connection_tracking_specification")

    @connection_tracking_specification.setter
    def connection_tracking_specification(self, value: Optional[pulumi.Input['NetworkInterfaceConnectionTrackingSpecificationArgs']]):
        pulumi.set(self, "connection_tracking_specification", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A description for the network interface.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="enablePrimaryIpv6")
    def enable_primary_ipv6(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If you have instances or ENIs that rely on the IPv6 address not changing, to avoid disrupting traffic to instances or ENIs, you can enable a primary IPv6 address. Enable this option to automatically assign an IPv6 associated with the ENI attached to your instance to be the primary IPv6 address. When you enable an IPv6 address to be a primary IPv6, you cannot disable it. Traffic will be routed to the primary IPv6 address until the instance is terminated or the ENI is detached. If you have multiple IPv6 addresses associated with an ENI and you enable a primary IPv6 address, the first IPv6 address associated with the ENI becomes the primary IPv6 address.
        """
        return pulumi.get(self, "enable_primary_ipv6")

    @enable_primary_ipv6.setter
    def enable_primary_ipv6(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enable_primary_ipv6", value)

    @property
    @pulumi.getter(name="groupSet")
    def group_set(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of security group IDs associated with this network interface.
        """
        return pulumi.get(self, "group_set")

    @group_set.setter
    def group_set(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "group_set", value)

    @property
    @pulumi.getter(name="interfaceType")
    def interface_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Indicates the type of network interface.
        """
        return pulumi.get(self, "interface_type")

    @interface_type.setter
    def interface_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "interface_type", value)

    @property
    @pulumi.getter(name="ipv4PrefixCount")
    def ipv4_prefix_count(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of IPv4 prefixes to assign to a network interface. When you specify a number of IPv4 prefixes, Amazon EC2 selects these prefixes from your existing subnet CIDR reservations, if available, or from free spaces in the subnet. By default, these will be /28 prefixes. You can't specify a count of IPv4 prefixes if you've specified one of the following: specific IPv4 prefixes, specific private IPv4 addresses, or a count of private IPv4 addresses.
        """
        return pulumi.get(self, "ipv4_prefix_count")

    @ipv4_prefix_count.setter
    def ipv4_prefix_count(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "ipv4_prefix_count", value)

    @property
    @pulumi.getter(name="ipv4Prefixes")
    def ipv4_prefixes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NetworkInterfaceIpv4PrefixSpecificationArgs']]]]:
        """
        Assigns a list of IPv4 prefixes to the network interface. If you want EC2 to automatically assign IPv4 prefixes, use the Ipv4PrefixCount property and do not specify this property. Presently, only /28 prefixes are supported. You can't specify IPv4 prefixes if you've specified one of the following: a count of IPv4 prefixes, specific private IPv4 addresses, or a count of private IPv4 addresses.
        """
        return pulumi.get(self, "ipv4_prefixes")

    @ipv4_prefixes.setter
    def ipv4_prefixes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkInterfaceIpv4PrefixSpecificationArgs']]]]):
        pulumi.set(self, "ipv4_prefixes", value)

    @property
    @pulumi.getter(name="ipv6AddressCount")
    def ipv6_address_count(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of IPv6 addresses to assign to a network interface. Amazon EC2 automatically selects the IPv6 addresses from the subnet range. To specify specific IPv6 addresses, use the Ipv6Addresses property and don't specify this property.
        """
        return pulumi.get(self, "ipv6_address_count")

    @ipv6_address_count.setter
    def ipv6_address_count(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "ipv6_address_count", value)

    @property
    @pulumi.getter(name="ipv6Addresses")
    def ipv6_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NetworkInterfaceInstanceIpv6AddressArgs']]]]:
        """
        One or more specific IPv6 addresses from the IPv6 CIDR block range of your subnet to associate with the network interface. If you're specifying a number of IPv6 addresses, use the Ipv6AddressCount property and don't specify this property.
        """
        return pulumi.get(self, "ipv6_addresses")

    @ipv6_addresses.setter
    def ipv6_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkInterfaceInstanceIpv6AddressArgs']]]]):
        pulumi.set(self, "ipv6_addresses", value)

    @property
    @pulumi.getter(name="ipv6PrefixCount")
    def ipv6_prefix_count(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of IPv6 prefixes to assign to a network interface. When you specify a number of IPv6 prefixes, Amazon EC2 selects these prefixes from your existing subnet CIDR reservations, if available, or from free spaces in the subnet. By default, these will be /80 prefixes. You can't specify a count of IPv6 prefixes if you've specified one of the following: specific IPv6 prefixes, specific IPv6 addresses, or a count of IPv6 addresses.
        """
        return pulumi.get(self, "ipv6_prefix_count")

    @ipv6_prefix_count.setter
    def ipv6_prefix_count(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "ipv6_prefix_count", value)

    @property
    @pulumi.getter(name="ipv6Prefixes")
    def ipv6_prefixes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NetworkInterfaceIpv6PrefixSpecificationArgs']]]]:
        """
        Assigns a list of IPv6 prefixes to the network interface. If you want EC2 to automatically assign IPv6 prefixes, use the Ipv6PrefixCount property and do not specify this property. Presently, only /80 prefixes are supported. You can't specify IPv6 prefixes if you've specified one of the following: a count of IPv6 prefixes, specific IPv6 addresses, or a count of IPv6 addresses.
        """
        return pulumi.get(self, "ipv6_prefixes")

    @ipv6_prefixes.setter
    def ipv6_prefixes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkInterfaceIpv6PrefixSpecificationArgs']]]]):
        pulumi.set(self, "ipv6_prefixes", value)

    @property
    @pulumi.getter(name="privateIpAddress")
    def private_ip_address(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Assigns a single private IP address to the network interface, which is used as the primary private IP address. If you want to specify multiple private IP address, use the PrivateIpAddresses property. 
        """
        return pulumi.get(self, "private_ip_address")

    @private_ip_address.setter
    def private_ip_address(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "private_ip_address", value)

    @property
    @pulumi.getter(name="privateIpAddresses")
    def private_ip_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NetworkInterfacePrivateIpAddressSpecificationArgs']]]]:
        """
        Assigns a list of private IP addresses to the network interface. You can specify a primary private IP address by setting the value of the Primary property to true in the PrivateIpAddressSpecification property. If you want EC2 to automatically assign private IP addresses, use the SecondaryPrivateIpAddressCount property and do not specify this property.
        """
        return pulumi.get(self, "private_ip_addresses")

    @private_ip_addresses.setter
    def private_ip_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkInterfacePrivateIpAddressSpecificationArgs']]]]):
        pulumi.set(self, "private_ip_addresses", value)

    @property
    @pulumi.getter(name="secondaryPrivateIpAddressCount")
    def secondary_private_ip_address_count(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of secondary private IPv4 addresses to assign to a network interface. When you specify a number of secondary IPv4 addresses, Amazon EC2 selects these IP addresses within the subnet's IPv4 CIDR range. You can't specify this option and specify more than one private IP address using privateIpAddresses
        """
        return pulumi.get(self, "secondary_private_ip_address_count")

    @secondary_private_ip_address_count.setter
    def secondary_private_ip_address_count(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "secondary_private_ip_address_count", value)

    @property
    @pulumi.getter(name="sourceDestCheck")
    def source_dest_check(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Indicates whether traffic to or from the instance is validated.
        """
        return pulumi.get(self, "source_dest_check")

    @source_dest_check.setter
    def source_dest_check(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "source_dest_check", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        An arbitrary set of tags (key-value pairs) for this network interface.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("aws-native:ec2:NetworkInterface")
class NetworkInterface(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 connection_tracking_specification: Optional[pulumi.Input[Union['NetworkInterfaceConnectionTrackingSpecificationArgs', 'NetworkInterfaceConnectionTrackingSpecificationArgsDict']]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 enable_primary_ipv6: Optional[pulumi.Input[builtins.bool]] = None,
                 group_set: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 interface_type: Optional[pulumi.Input[builtins.str]] = None,
                 ipv4_prefix_count: Optional[pulumi.Input[builtins.int]] = None,
                 ipv4_prefixes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NetworkInterfaceIpv4PrefixSpecificationArgs', 'NetworkInterfaceIpv4PrefixSpecificationArgsDict']]]]] = None,
                 ipv6_address_count: Optional[pulumi.Input[builtins.int]] = None,
                 ipv6_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NetworkInterfaceInstanceIpv6AddressArgs', 'NetworkInterfaceInstanceIpv6AddressArgsDict']]]]] = None,
                 ipv6_prefix_count: Optional[pulumi.Input[builtins.int]] = None,
                 ipv6_prefixes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NetworkInterfaceIpv6PrefixSpecificationArgs', 'NetworkInterfaceIpv6PrefixSpecificationArgsDict']]]]] = None,
                 private_ip_address: Optional[pulumi.Input[builtins.str]] = None,
                 private_ip_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NetworkInterfacePrivateIpAddressSpecificationArgs', 'NetworkInterfacePrivateIpAddressSpecificationArgsDict']]]]] = None,
                 secondary_private_ip_address_count: Optional[pulumi.Input[builtins.int]] = None,
                 source_dest_check: Optional[pulumi.Input[builtins.bool]] = None,
                 subnet_id: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        """
        The AWS::EC2::NetworkInterface resource creates network interface

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['NetworkInterfaceConnectionTrackingSpecificationArgs', 'NetworkInterfaceConnectionTrackingSpecificationArgsDict']] connection_tracking_specification: A connection tracking specification for the network interface.
        :param pulumi.Input[builtins.str] description: A description for the network interface.
        :param pulumi.Input[builtins.bool] enable_primary_ipv6: If you have instances or ENIs that rely on the IPv6 address not changing, to avoid disrupting traffic to instances or ENIs, you can enable a primary IPv6 address. Enable this option to automatically assign an IPv6 associated with the ENI attached to your instance to be the primary IPv6 address. When you enable an IPv6 address to be a primary IPv6, you cannot disable it. Traffic will be routed to the primary IPv6 address until the instance is terminated or the ENI is detached. If you have multiple IPv6 addresses associated with an ENI and you enable a primary IPv6 address, the first IPv6 address associated with the ENI becomes the primary IPv6 address.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] group_set: A list of security group IDs associated with this network interface.
        :param pulumi.Input[builtins.str] interface_type: Indicates the type of network interface.
        :param pulumi.Input[builtins.int] ipv4_prefix_count: The number of IPv4 prefixes to assign to a network interface. When you specify a number of IPv4 prefixes, Amazon EC2 selects these prefixes from your existing subnet CIDR reservations, if available, or from free spaces in the subnet. By default, these will be /28 prefixes. You can't specify a count of IPv4 prefixes if you've specified one of the following: specific IPv4 prefixes, specific private IPv4 addresses, or a count of private IPv4 addresses.
        :param pulumi.Input[Sequence[pulumi.Input[Union['NetworkInterfaceIpv4PrefixSpecificationArgs', 'NetworkInterfaceIpv4PrefixSpecificationArgsDict']]]] ipv4_prefixes: Assigns a list of IPv4 prefixes to the network interface. If you want EC2 to automatically assign IPv4 prefixes, use the Ipv4PrefixCount property and do not specify this property. Presently, only /28 prefixes are supported. You can't specify IPv4 prefixes if you've specified one of the following: a count of IPv4 prefixes, specific private IPv4 addresses, or a count of private IPv4 addresses.
        :param pulumi.Input[builtins.int] ipv6_address_count: The number of IPv6 addresses to assign to a network interface. Amazon EC2 automatically selects the IPv6 addresses from the subnet range. To specify specific IPv6 addresses, use the Ipv6Addresses property and don't specify this property.
        :param pulumi.Input[Sequence[pulumi.Input[Union['NetworkInterfaceInstanceIpv6AddressArgs', 'NetworkInterfaceInstanceIpv6AddressArgsDict']]]] ipv6_addresses: One or more specific IPv6 addresses from the IPv6 CIDR block range of your subnet to associate with the network interface. If you're specifying a number of IPv6 addresses, use the Ipv6AddressCount property and don't specify this property.
        :param pulumi.Input[builtins.int] ipv6_prefix_count: The number of IPv6 prefixes to assign to a network interface. When you specify a number of IPv6 prefixes, Amazon EC2 selects these prefixes from your existing subnet CIDR reservations, if available, or from free spaces in the subnet. By default, these will be /80 prefixes. You can't specify a count of IPv6 prefixes if you've specified one of the following: specific IPv6 prefixes, specific IPv6 addresses, or a count of IPv6 addresses.
        :param pulumi.Input[Sequence[pulumi.Input[Union['NetworkInterfaceIpv6PrefixSpecificationArgs', 'NetworkInterfaceIpv6PrefixSpecificationArgsDict']]]] ipv6_prefixes: Assigns a list of IPv6 prefixes to the network interface. If you want EC2 to automatically assign IPv6 prefixes, use the Ipv6PrefixCount property and do not specify this property. Presently, only /80 prefixes are supported. You can't specify IPv6 prefixes if you've specified one of the following: a count of IPv6 prefixes, specific IPv6 addresses, or a count of IPv6 addresses.
        :param pulumi.Input[builtins.str] private_ip_address: Assigns a single private IP address to the network interface, which is used as the primary private IP address. If you want to specify multiple private IP address, use the PrivateIpAddresses property. 
        :param pulumi.Input[Sequence[pulumi.Input[Union['NetworkInterfacePrivateIpAddressSpecificationArgs', 'NetworkInterfacePrivateIpAddressSpecificationArgsDict']]]] private_ip_addresses: Assigns a list of private IP addresses to the network interface. You can specify a primary private IP address by setting the value of the Primary property to true in the PrivateIpAddressSpecification property. If you want EC2 to automatically assign private IP addresses, use the SecondaryPrivateIpAddressCount property and do not specify this property.
        :param pulumi.Input[builtins.int] secondary_private_ip_address_count: The number of secondary private IPv4 addresses to assign to a network interface. When you specify a number of secondary IPv4 addresses, Amazon EC2 selects these IP addresses within the subnet's IPv4 CIDR range. You can't specify this option and specify more than one private IP address using privateIpAddresses
        :param pulumi.Input[builtins.bool] source_dest_check: Indicates whether traffic to or from the instance is validated.
        :param pulumi.Input[builtins.str] subnet_id: The ID of the subnet to associate with the network interface.
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: An arbitrary set of tags (key-value pairs) for this network interface.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NetworkInterfaceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The AWS::EC2::NetworkInterface resource creates network interface

        :param str resource_name: The name of the resource.
        :param NetworkInterfaceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NetworkInterfaceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 connection_tracking_specification: Optional[pulumi.Input[Union['NetworkInterfaceConnectionTrackingSpecificationArgs', 'NetworkInterfaceConnectionTrackingSpecificationArgsDict']]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 enable_primary_ipv6: Optional[pulumi.Input[builtins.bool]] = None,
                 group_set: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 interface_type: Optional[pulumi.Input[builtins.str]] = None,
                 ipv4_prefix_count: Optional[pulumi.Input[builtins.int]] = None,
                 ipv4_prefixes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NetworkInterfaceIpv4PrefixSpecificationArgs', 'NetworkInterfaceIpv4PrefixSpecificationArgsDict']]]]] = None,
                 ipv6_address_count: Optional[pulumi.Input[builtins.int]] = None,
                 ipv6_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NetworkInterfaceInstanceIpv6AddressArgs', 'NetworkInterfaceInstanceIpv6AddressArgsDict']]]]] = None,
                 ipv6_prefix_count: Optional[pulumi.Input[builtins.int]] = None,
                 ipv6_prefixes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NetworkInterfaceIpv6PrefixSpecificationArgs', 'NetworkInterfaceIpv6PrefixSpecificationArgsDict']]]]] = None,
                 private_ip_address: Optional[pulumi.Input[builtins.str]] = None,
                 private_ip_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NetworkInterfacePrivateIpAddressSpecificationArgs', 'NetworkInterfacePrivateIpAddressSpecificationArgsDict']]]]] = None,
                 secondary_private_ip_address_count: Optional[pulumi.Input[builtins.int]] = None,
                 source_dest_check: Optional[pulumi.Input[builtins.bool]] = None,
                 subnet_id: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NetworkInterfaceArgs.__new__(NetworkInterfaceArgs)

            __props__.__dict__["connection_tracking_specification"] = connection_tracking_specification
            __props__.__dict__["description"] = description
            __props__.__dict__["enable_primary_ipv6"] = enable_primary_ipv6
            __props__.__dict__["group_set"] = group_set
            __props__.__dict__["interface_type"] = interface_type
            __props__.__dict__["ipv4_prefix_count"] = ipv4_prefix_count
            __props__.__dict__["ipv4_prefixes"] = ipv4_prefixes
            __props__.__dict__["ipv6_address_count"] = ipv6_address_count
            __props__.__dict__["ipv6_addresses"] = ipv6_addresses
            __props__.__dict__["ipv6_prefix_count"] = ipv6_prefix_count
            __props__.__dict__["ipv6_prefixes"] = ipv6_prefixes
            __props__.__dict__["private_ip_address"] = private_ip_address
            __props__.__dict__["private_ip_addresses"] = private_ip_addresses
            __props__.__dict__["secondary_private_ip_address_count"] = secondary_private_ip_address_count
            __props__.__dict__["source_dest_check"] = source_dest_check
            if subnet_id is None and not opts.urn:
                raise TypeError("Missing required property 'subnet_id'")
            __props__.__dict__["subnet_id"] = subnet_id
            __props__.__dict__["tags"] = tags
            __props__.__dict__["aws_id"] = None
            __props__.__dict__["primary_ipv6_address"] = None
            __props__.__dict__["primary_private_ip_address"] = None
            __props__.__dict__["secondary_private_ip_addresses"] = None
            __props__.__dict__["vpc_id"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["interfaceType", "privateIpAddress", "subnetId"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(NetworkInterface, __self__).__init__(
            'aws-native:ec2:NetworkInterface',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'NetworkInterface':
        """
        Get an existing NetworkInterface resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = NetworkInterfaceArgs.__new__(NetworkInterfaceArgs)

        __props__.__dict__["aws_id"] = None
        __props__.__dict__["connection_tracking_specification"] = None
        __props__.__dict__["description"] = None
        __props__.__dict__["enable_primary_ipv6"] = None
        __props__.__dict__["group_set"] = None
        __props__.__dict__["interface_type"] = None
        __props__.__dict__["ipv4_prefix_count"] = None
        __props__.__dict__["ipv4_prefixes"] = None
        __props__.__dict__["ipv6_address_count"] = None
        __props__.__dict__["ipv6_addresses"] = None
        __props__.__dict__["ipv6_prefix_count"] = None
        __props__.__dict__["ipv6_prefixes"] = None
        __props__.__dict__["primary_ipv6_address"] = None
        __props__.__dict__["primary_private_ip_address"] = None
        __props__.__dict__["private_ip_address"] = None
        __props__.__dict__["private_ip_addresses"] = None
        __props__.__dict__["secondary_private_ip_address_count"] = None
        __props__.__dict__["secondary_private_ip_addresses"] = None
        __props__.__dict__["source_dest_check"] = None
        __props__.__dict__["subnet_id"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["vpc_id"] = None
        return NetworkInterface(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="awsId")
    def aws_id(self) -> pulumi.Output[builtins.str]:
        """
        Network interface id.
        """
        return pulumi.get(self, "aws_id")

    @property
    @pulumi.getter(name="connectionTrackingSpecification")
    def connection_tracking_specification(self) -> pulumi.Output[Optional['outputs.NetworkInterfaceConnectionTrackingSpecification']]:
        """
        A connection tracking specification for the network interface.
        """
        return pulumi.get(self, "connection_tracking_specification")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        A description for the network interface.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="enablePrimaryIpv6")
    def enable_primary_ipv6(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        If you have instances or ENIs that rely on the IPv6 address not changing, to avoid disrupting traffic to instances or ENIs, you can enable a primary IPv6 address. Enable this option to automatically assign an IPv6 associated with the ENI attached to your instance to be the primary IPv6 address. When you enable an IPv6 address to be a primary IPv6, you cannot disable it. Traffic will be routed to the primary IPv6 address until the instance is terminated or the ENI is detached. If you have multiple IPv6 addresses associated with an ENI and you enable a primary IPv6 address, the first IPv6 address associated with the ENI becomes the primary IPv6 address.
        """
        return pulumi.get(self, "enable_primary_ipv6")

    @property
    @pulumi.getter(name="groupSet")
    def group_set(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        A list of security group IDs associated with this network interface.
        """
        return pulumi.get(self, "group_set")

    @property
    @pulumi.getter(name="interfaceType")
    def interface_type(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Indicates the type of network interface.
        """
        return pulumi.get(self, "interface_type")

    @property
    @pulumi.getter(name="ipv4PrefixCount")
    def ipv4_prefix_count(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The number of IPv4 prefixes to assign to a network interface. When you specify a number of IPv4 prefixes, Amazon EC2 selects these prefixes from your existing subnet CIDR reservations, if available, or from free spaces in the subnet. By default, these will be /28 prefixes. You can't specify a count of IPv4 prefixes if you've specified one of the following: specific IPv4 prefixes, specific private IPv4 addresses, or a count of private IPv4 addresses.
        """
        return pulumi.get(self, "ipv4_prefix_count")

    @property
    @pulumi.getter(name="ipv4Prefixes")
    def ipv4_prefixes(self) -> pulumi.Output[Optional[Sequence['outputs.NetworkInterfaceIpv4PrefixSpecification']]]:
        """
        Assigns a list of IPv4 prefixes to the network interface. If you want EC2 to automatically assign IPv4 prefixes, use the Ipv4PrefixCount property and do not specify this property. Presently, only /28 prefixes are supported. You can't specify IPv4 prefixes if you've specified one of the following: a count of IPv4 prefixes, specific private IPv4 addresses, or a count of private IPv4 addresses.
        """
        return pulumi.get(self, "ipv4_prefixes")

    @property
    @pulumi.getter(name="ipv6AddressCount")
    def ipv6_address_count(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The number of IPv6 addresses to assign to a network interface. Amazon EC2 automatically selects the IPv6 addresses from the subnet range. To specify specific IPv6 addresses, use the Ipv6Addresses property and don't specify this property.
        """
        return pulumi.get(self, "ipv6_address_count")

    @property
    @pulumi.getter(name="ipv6Addresses")
    def ipv6_addresses(self) -> pulumi.Output[Optional[Sequence['outputs.NetworkInterfaceInstanceIpv6Address']]]:
        """
        One or more specific IPv6 addresses from the IPv6 CIDR block range of your subnet to associate with the network interface. If you're specifying a number of IPv6 addresses, use the Ipv6AddressCount property and don't specify this property.
        """
        return pulumi.get(self, "ipv6_addresses")

    @property
    @pulumi.getter(name="ipv6PrefixCount")
    def ipv6_prefix_count(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The number of IPv6 prefixes to assign to a network interface. When you specify a number of IPv6 prefixes, Amazon EC2 selects these prefixes from your existing subnet CIDR reservations, if available, or from free spaces in the subnet. By default, these will be /80 prefixes. You can't specify a count of IPv6 prefixes if you've specified one of the following: specific IPv6 prefixes, specific IPv6 addresses, or a count of IPv6 addresses.
        """
        return pulumi.get(self, "ipv6_prefix_count")

    @property
    @pulumi.getter(name="ipv6Prefixes")
    def ipv6_prefixes(self) -> pulumi.Output[Optional[Sequence['outputs.NetworkInterfaceIpv6PrefixSpecification']]]:
        """
        Assigns a list of IPv6 prefixes to the network interface. If you want EC2 to automatically assign IPv6 prefixes, use the Ipv6PrefixCount property and do not specify this property. Presently, only /80 prefixes are supported. You can't specify IPv6 prefixes if you've specified one of the following: a count of IPv6 prefixes, specific IPv6 addresses, or a count of IPv6 addresses.
        """
        return pulumi.get(self, "ipv6_prefixes")

    @property
    @pulumi.getter(name="primaryIpv6Address")
    def primary_ipv6_address(self) -> pulumi.Output[builtins.str]:
        """
        The primary IPv6 address
        """
        return pulumi.get(self, "primary_ipv6_address")

    @property
    @pulumi.getter(name="primaryPrivateIpAddress")
    def primary_private_ip_address(self) -> pulumi.Output[builtins.str]:
        """
        Returns the primary private IP address of the network interface.
        """
        return pulumi.get(self, "primary_private_ip_address")

    @property
    @pulumi.getter(name="privateIpAddress")
    def private_ip_address(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Assigns a single private IP address to the network interface, which is used as the primary private IP address. If you want to specify multiple private IP address, use the PrivateIpAddresses property. 
        """
        return pulumi.get(self, "private_ip_address")

    @property
    @pulumi.getter(name="privateIpAddresses")
    def private_ip_addresses(self) -> pulumi.Output[Optional[Sequence['outputs.NetworkInterfacePrivateIpAddressSpecification']]]:
        """
        Assigns a list of private IP addresses to the network interface. You can specify a primary private IP address by setting the value of the Primary property to true in the PrivateIpAddressSpecification property. If you want EC2 to automatically assign private IP addresses, use the SecondaryPrivateIpAddressCount property and do not specify this property.
        """
        return pulumi.get(self, "private_ip_addresses")

    @property
    @pulumi.getter(name="secondaryPrivateIpAddressCount")
    def secondary_private_ip_address_count(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The number of secondary private IPv4 addresses to assign to a network interface. When you specify a number of secondary IPv4 addresses, Amazon EC2 selects these IP addresses within the subnet's IPv4 CIDR range. You can't specify this option and specify more than one private IP address using privateIpAddresses
        """
        return pulumi.get(self, "secondary_private_ip_address_count")

    @property
    @pulumi.getter(name="secondaryPrivateIpAddresses")
    def secondary_private_ip_addresses(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        Returns the secondary private IP addresses of the network interface.
        """
        return pulumi.get(self, "secondary_private_ip_addresses")

    @property
    @pulumi.getter(name="sourceDestCheck")
    def source_dest_check(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Indicates whether traffic to or from the instance is validated.
        """
        return pulumi.get(self, "source_dest_check")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the subnet to associate with the network interface.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        An arbitrary set of tags (key-value pairs) for this network interface.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the VPC
        """
        return pulumi.get(self, "vpc_id")

