# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._enums import *
from ._inputs import *

__all__ = ['IpamArgs', 'Ipam']

@pulumi.input_type
class IpamArgs:
    def __init__(__self__, *,
                 default_resource_discovery_organizational_unit_exclusions: Optional[pulumi.Input[Sequence[pulumi.Input['IpamOrganizationalUnitExclusionArgs']]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 enable_private_gua: Optional[pulumi.Input[builtins.bool]] = None,
                 metered_account: Optional[pulumi.Input['IpamMeteredAccount']] = None,
                 operating_regions: Optional[pulumi.Input[Sequence[pulumi.Input['IpamOperatingRegionArgs']]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None,
                 tier: Optional[pulumi.Input['IpamTier']] = None):
        """
        The set of arguments for constructing a Ipam resource.
        :param pulumi.Input[Sequence[pulumi.Input['IpamOrganizationalUnitExclusionArgs']]] default_resource_discovery_organizational_unit_exclusions: A set of organizational unit (OU) exclusions for the default resource discovery, created with this IPAM.
        :param pulumi.Input[builtins.str] description: The description for the IPAM.
        :param pulumi.Input[builtins.bool] enable_private_gua: Enable provisioning of GUA space in private pools.
        :param pulumi.Input['IpamMeteredAccount'] metered_account: A metered account is an account that is charged for active IP addresses managed in IPAM
        :param pulumi.Input[Sequence[pulumi.Input['IpamOperatingRegionArgs']]] operating_regions: The regions IPAM is enabled for. Allows pools to be created in these regions, as well as enabling monitoring
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: An array of key-value pairs to apply to this resource.
        :param pulumi.Input['IpamTier'] tier: The tier of the IPAM.
        """
        if default_resource_discovery_organizational_unit_exclusions is not None:
            pulumi.set(__self__, "default_resource_discovery_organizational_unit_exclusions", default_resource_discovery_organizational_unit_exclusions)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enable_private_gua is not None:
            pulumi.set(__self__, "enable_private_gua", enable_private_gua)
        if metered_account is not None:
            pulumi.set(__self__, "metered_account", metered_account)
        if operating_regions is not None:
            pulumi.set(__self__, "operating_regions", operating_regions)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tier is not None:
            pulumi.set(__self__, "tier", tier)

    @property
    @pulumi.getter(name="defaultResourceDiscoveryOrganizationalUnitExclusions")
    def default_resource_discovery_organizational_unit_exclusions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IpamOrganizationalUnitExclusionArgs']]]]:
        """
        A set of organizational unit (OU) exclusions for the default resource discovery, created with this IPAM.
        """
        return pulumi.get(self, "default_resource_discovery_organizational_unit_exclusions")

    @default_resource_discovery_organizational_unit_exclusions.setter
    def default_resource_discovery_organizational_unit_exclusions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IpamOrganizationalUnitExclusionArgs']]]]):
        pulumi.set(self, "default_resource_discovery_organizational_unit_exclusions", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description for the IPAM.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="enablePrivateGua")
    def enable_private_gua(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable provisioning of GUA space in private pools.
        """
        return pulumi.get(self, "enable_private_gua")

    @enable_private_gua.setter
    def enable_private_gua(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enable_private_gua", value)

    @property
    @pulumi.getter(name="meteredAccount")
    def metered_account(self) -> Optional[pulumi.Input['IpamMeteredAccount']]:
        """
        A metered account is an account that is charged for active IP addresses managed in IPAM
        """
        return pulumi.get(self, "metered_account")

    @metered_account.setter
    def metered_account(self, value: Optional[pulumi.Input['IpamMeteredAccount']]):
        pulumi.set(self, "metered_account", value)

    @property
    @pulumi.getter(name="operatingRegions")
    def operating_regions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IpamOperatingRegionArgs']]]]:
        """
        The regions IPAM is enabled for. Allows pools to be created in these regions, as well as enabling monitoring
        """
        return pulumi.get(self, "operating_regions")

    @operating_regions.setter
    def operating_regions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IpamOperatingRegionArgs']]]]):
        pulumi.set(self, "operating_regions", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def tier(self) -> Optional[pulumi.Input['IpamTier']]:
        """
        The tier of the IPAM.
        """
        return pulumi.get(self, "tier")

    @tier.setter
    def tier(self, value: Optional[pulumi.Input['IpamTier']]):
        pulumi.set(self, "tier", value)


@pulumi.type_token("aws-native:ec2:Ipam")
class Ipam(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 default_resource_discovery_organizational_unit_exclusions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['IpamOrganizationalUnitExclusionArgs', 'IpamOrganizationalUnitExclusionArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 enable_private_gua: Optional[pulumi.Input[builtins.bool]] = None,
                 metered_account: Optional[pulumi.Input['IpamMeteredAccount']] = None,
                 operating_regions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['IpamOperatingRegionArgs', 'IpamOperatingRegionArgsDict']]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 tier: Optional[pulumi.Input['IpamTier']] = None,
                 __props__=None):
        """
        Resource Schema of AWS::EC2::IPAM Type

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['IpamOrganizationalUnitExclusionArgs', 'IpamOrganizationalUnitExclusionArgsDict']]]] default_resource_discovery_organizational_unit_exclusions: A set of organizational unit (OU) exclusions for the default resource discovery, created with this IPAM.
        :param pulumi.Input[builtins.str] description: The description for the IPAM.
        :param pulumi.Input[builtins.bool] enable_private_gua: Enable provisioning of GUA space in private pools.
        :param pulumi.Input['IpamMeteredAccount'] metered_account: A metered account is an account that is charged for active IP addresses managed in IPAM
        :param pulumi.Input[Sequence[pulumi.Input[Union['IpamOperatingRegionArgs', 'IpamOperatingRegionArgsDict']]]] operating_regions: The regions IPAM is enabled for. Allows pools to be created in these regions, as well as enabling monitoring
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: An array of key-value pairs to apply to this resource.
        :param pulumi.Input['IpamTier'] tier: The tier of the IPAM.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[IpamArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource Schema of AWS::EC2::IPAM Type

        :param str resource_name: The name of the resource.
        :param IpamArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(IpamArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 default_resource_discovery_organizational_unit_exclusions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['IpamOrganizationalUnitExclusionArgs', 'IpamOrganizationalUnitExclusionArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 enable_private_gua: Optional[pulumi.Input[builtins.bool]] = None,
                 metered_account: Optional[pulumi.Input['IpamMeteredAccount']] = None,
                 operating_regions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['IpamOperatingRegionArgs', 'IpamOperatingRegionArgsDict']]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 tier: Optional[pulumi.Input['IpamTier']] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = IpamArgs.__new__(IpamArgs)

            __props__.__dict__["default_resource_discovery_organizational_unit_exclusions"] = default_resource_discovery_organizational_unit_exclusions
            __props__.__dict__["description"] = description
            __props__.__dict__["enable_private_gua"] = enable_private_gua
            __props__.__dict__["metered_account"] = metered_account
            __props__.__dict__["operating_regions"] = operating_regions
            __props__.__dict__["tags"] = tags
            __props__.__dict__["tier"] = tier
            __props__.__dict__["arn"] = None
            __props__.__dict__["default_resource_discovery_association_id"] = None
            __props__.__dict__["default_resource_discovery_id"] = None
            __props__.__dict__["ipam_id"] = None
            __props__.__dict__["private_default_scope_id"] = None
            __props__.__dict__["public_default_scope_id"] = None
            __props__.__dict__["resource_discovery_association_count"] = None
            __props__.__dict__["scope_count"] = None
        super(Ipam, __self__).__init__(
            'aws-native:ec2:Ipam',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Ipam':
        """
        Get an existing Ipam resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = IpamArgs.__new__(IpamArgs)

        __props__.__dict__["arn"] = None
        __props__.__dict__["default_resource_discovery_association_id"] = None
        __props__.__dict__["default_resource_discovery_id"] = None
        __props__.__dict__["default_resource_discovery_organizational_unit_exclusions"] = None
        __props__.__dict__["description"] = None
        __props__.__dict__["enable_private_gua"] = None
        __props__.__dict__["ipam_id"] = None
        __props__.__dict__["metered_account"] = None
        __props__.__dict__["operating_regions"] = None
        __props__.__dict__["private_default_scope_id"] = None
        __props__.__dict__["public_default_scope_id"] = None
        __props__.__dict__["resource_discovery_association_count"] = None
        __props__.__dict__["scope_count"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["tier"] = None
        return Ipam(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the IPAM.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="defaultResourceDiscoveryAssociationId")
    def default_resource_discovery_association_id(self) -> pulumi.Output[builtins.str]:
        """
        The Id of the default association to the default resource discovery, created with this IPAM.
        """
        return pulumi.get(self, "default_resource_discovery_association_id")

    @property
    @pulumi.getter(name="defaultResourceDiscoveryId")
    def default_resource_discovery_id(self) -> pulumi.Output[builtins.str]:
        """
        The Id of the default resource discovery, created with this IPAM.
        """
        return pulumi.get(self, "default_resource_discovery_id")

    @property
    @pulumi.getter(name="defaultResourceDiscoveryOrganizationalUnitExclusions")
    def default_resource_discovery_organizational_unit_exclusions(self) -> pulumi.Output[Optional[Sequence['outputs.IpamOrganizationalUnitExclusion']]]:
        """
        A set of organizational unit (OU) exclusions for the default resource discovery, created with this IPAM.
        """
        return pulumi.get(self, "default_resource_discovery_organizational_unit_exclusions")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The description for the IPAM.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="enablePrivateGua")
    def enable_private_gua(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Enable provisioning of GUA space in private pools.
        """
        return pulumi.get(self, "enable_private_gua")

    @property
    @pulumi.getter(name="ipamId")
    def ipam_id(self) -> pulumi.Output[builtins.str]:
        """
        Id of the IPAM.
        """
        return pulumi.get(self, "ipam_id")

    @property
    @pulumi.getter(name="meteredAccount")
    def metered_account(self) -> pulumi.Output[Optional['IpamMeteredAccount']]:
        """
        A metered account is an account that is charged for active IP addresses managed in IPAM
        """
        return pulumi.get(self, "metered_account")

    @property
    @pulumi.getter(name="operatingRegions")
    def operating_regions(self) -> pulumi.Output[Optional[Sequence['outputs.IpamOperatingRegion']]]:
        """
        The regions IPAM is enabled for. Allows pools to be created in these regions, as well as enabling monitoring
        """
        return pulumi.get(self, "operating_regions")

    @property
    @pulumi.getter(name="privateDefaultScopeId")
    def private_default_scope_id(self) -> pulumi.Output[builtins.str]:
        """
        The Id of the default scope for publicly routable IP space, created with this IPAM.
        """
        return pulumi.get(self, "private_default_scope_id")

    @property
    @pulumi.getter(name="publicDefaultScopeId")
    def public_default_scope_id(self) -> pulumi.Output[builtins.str]:
        """
        The Id of the default scope for publicly routable IP space, created with this IPAM.
        """
        return pulumi.get(self, "public_default_scope_id")

    @property
    @pulumi.getter(name="resourceDiscoveryAssociationCount")
    def resource_discovery_association_count(self) -> pulumi.Output[builtins.int]:
        """
        The count of resource discoveries associated with this IPAM.
        """
        return pulumi.get(self, "resource_discovery_association_count")

    @property
    @pulumi.getter(name="scopeCount")
    def scope_count(self) -> pulumi.Output[builtins.int]:
        """
        The number of scopes that currently exist in this IPAM.
        """
        return pulumi.get(self, "scope_count")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def tier(self) -> pulumi.Output[Optional['IpamTier']]:
        """
        The tier of the IPAM.
        """
        return pulumi.get(self, "tier")

