# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetVpcGatewayAttachmentResult',
    'AwaitableGetVpcGatewayAttachmentResult',
    'get_vpc_gateway_attachment',
    'get_vpc_gateway_attachment_output',
]

@pulumi.output_type
class GetVpcGatewayAttachmentResult:
    def __init__(__self__, attachment_type=None, internet_gateway_id=None, vpn_gateway_id=None):
        if attachment_type and not isinstance(attachment_type, str):
            raise TypeError("Expected argument 'attachment_type' to be a str")
        pulumi.set(__self__, "attachment_type", attachment_type)
        if internet_gateway_id and not isinstance(internet_gateway_id, str):
            raise TypeError("Expected argument 'internet_gateway_id' to be a str")
        pulumi.set(__self__, "internet_gateway_id", internet_gateway_id)
        if vpn_gateway_id and not isinstance(vpn_gateway_id, str):
            raise TypeError("Expected argument 'vpn_gateway_id' to be a str")
        pulumi.set(__self__, "vpn_gateway_id", vpn_gateway_id)

    @property
    @pulumi.getter(name="attachmentType")
    def attachment_type(self) -> Optional[builtins.str]:
        """
        Used to identify if this resource is an Internet Gateway or Vpn Gateway Attachment 
        """
        return pulumi.get(self, "attachment_type")

    @property
    @pulumi.getter(name="internetGatewayId")
    def internet_gateway_id(self) -> Optional[builtins.str]:
        """
        The ID of the internet gateway. You must specify either InternetGatewayId or VpnGatewayId, but not both.
        """
        return pulumi.get(self, "internet_gateway_id")

    @property
    @pulumi.getter(name="vpnGatewayId")
    def vpn_gateway_id(self) -> Optional[builtins.str]:
        """
        The ID of the virtual private gateway. You must specify either InternetGatewayId or VpnGatewayId, but not both.
        """
        return pulumi.get(self, "vpn_gateway_id")


class AwaitableGetVpcGatewayAttachmentResult(GetVpcGatewayAttachmentResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetVpcGatewayAttachmentResult(
            attachment_type=self.attachment_type,
            internet_gateway_id=self.internet_gateway_id,
            vpn_gateway_id=self.vpn_gateway_id)


def get_vpc_gateway_attachment(attachment_type: Optional[builtins.str] = None,
                               vpc_id: Optional[builtins.str] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetVpcGatewayAttachmentResult:
    """
    Resource Type definition for AWS::EC2::VPCGatewayAttachment


    :param builtins.str attachment_type: Used to identify if this resource is an Internet Gateway or Vpn Gateway Attachment 
    :param builtins.str vpc_id: The ID of the VPC.
    """
    __args__ = dict()
    __args__['attachmentType'] = attachment_type
    __args__['vpcId'] = vpc_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:ec2:getVpcGatewayAttachment', __args__, opts=opts, typ=GetVpcGatewayAttachmentResult).value

    return AwaitableGetVpcGatewayAttachmentResult(
        attachment_type=pulumi.get(__ret__, 'attachment_type'),
        internet_gateway_id=pulumi.get(__ret__, 'internet_gateway_id'),
        vpn_gateway_id=pulumi.get(__ret__, 'vpn_gateway_id'))
def get_vpc_gateway_attachment_output(attachment_type: Optional[pulumi.Input[builtins.str]] = None,
                                      vpc_id: Optional[pulumi.Input[builtins.str]] = None,
                                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetVpcGatewayAttachmentResult]:
    """
    Resource Type definition for AWS::EC2::VPCGatewayAttachment


    :param builtins.str attachment_type: Used to identify if this resource is an Internet Gateway or Vpn Gateway Attachment 
    :param builtins.str vpc_id: The ID of the VPC.
    """
    __args__ = dict()
    __args__['attachmentType'] = attachment_type
    __args__['vpcId'] = vpc_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:ec2:getVpcGatewayAttachment', __args__, opts=opts, typ=GetVpcGatewayAttachmentResult)
    return __ret__.apply(lambda __response__: GetVpcGatewayAttachmentResult(
        attachment_type=pulumi.get(__response__, 'attachment_type'),
        internet_gateway_id=pulumi.get(__response__, 'internet_gateway_id'),
        vpn_gateway_id=pulumi.get(__response__, 'vpn_gateway_id')))
