# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetVpcEndpointServicePermissionsResult',
    'AwaitableGetVpcEndpointServicePermissionsResult',
    'get_vpc_endpoint_service_permissions',
    'get_vpc_endpoint_service_permissions_output',
]

@pulumi.output_type
class GetVpcEndpointServicePermissionsResult:
    def __init__(__self__, allowed_principals=None):
        if allowed_principals and not isinstance(allowed_principals, list):
            raise TypeError("Expected argument 'allowed_principals' to be a list")
        pulumi.set(__self__, "allowed_principals", allowed_principals)

    @property
    @pulumi.getter(name="allowedPrincipals")
    def allowed_principals(self) -> Optional[Sequence[builtins.str]]:
        """
        The Amazon Resource Names (ARN) of one or more principals (for example, users, IAM roles, and AWS accounts ). Permissions are granted to the principals in this list. To grant permissions to all principals, specify an asterisk (*). Permissions are revoked for principals not in this list. If the list is empty, then all permissions are revoked.
        """
        return pulumi.get(self, "allowed_principals")


class AwaitableGetVpcEndpointServicePermissionsResult(GetVpcEndpointServicePermissionsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetVpcEndpointServicePermissionsResult(
            allowed_principals=self.allowed_principals)


def get_vpc_endpoint_service_permissions(service_id: Optional[builtins.str] = None,
                                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetVpcEndpointServicePermissionsResult:
    """
    Resource Type definition for AWS::EC2::VPCEndpointServicePermissions


    :param builtins.str service_id: The ID of the service.
    """
    __args__ = dict()
    __args__['serviceId'] = service_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:ec2:getVpcEndpointServicePermissions', __args__, opts=opts, typ=GetVpcEndpointServicePermissionsResult).value

    return AwaitableGetVpcEndpointServicePermissionsResult(
        allowed_principals=pulumi.get(__ret__, 'allowed_principals'))
def get_vpc_endpoint_service_permissions_output(service_id: Optional[pulumi.Input[builtins.str]] = None,
                                                opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetVpcEndpointServicePermissionsResult]:
    """
    Resource Type definition for AWS::EC2::VPCEndpointServicePermissions


    :param builtins.str service_id: The ID of the service.
    """
    __args__ = dict()
    __args__['serviceId'] = service_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:ec2:getVpcEndpointServicePermissions', __args__, opts=opts, typ=GetVpcEndpointServicePermissionsResult)
    return __ret__.apply(lambda __response__: GetVpcEndpointServicePermissionsResult(
        allowed_principals=pulumi.get(__response__, 'allowed_principals')))
