# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from .. import outputs as _root_outputs
from ._enums import *

__all__ = [
    'GetVpcBlockPublicAccessExclusionResult',
    'AwaitableGetVpcBlockPublicAccessExclusionResult',
    'get_vpc_block_public_access_exclusion',
    'get_vpc_block_public_access_exclusion_output',
]

@pulumi.output_type
class GetVpcBlockPublicAccessExclusionResult:
    def __init__(__self__, exclusion_id=None, internet_gateway_exclusion_mode=None, tags=None):
        if exclusion_id and not isinstance(exclusion_id, str):
            raise TypeError("Expected argument 'exclusion_id' to be a str")
        pulumi.set(__self__, "exclusion_id", exclusion_id)
        if internet_gateway_exclusion_mode and not isinstance(internet_gateway_exclusion_mode, str):
            raise TypeError("Expected argument 'internet_gateway_exclusion_mode' to be a str")
        pulumi.set(__self__, "internet_gateway_exclusion_mode", internet_gateway_exclusion_mode)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="exclusionId")
    def exclusion_id(self) -> Optional[builtins.str]:
        """
        The ID of the exclusion
        """
        return pulumi.get(self, "exclusion_id")

    @property
    @pulumi.getter(name="internetGatewayExclusionMode")
    def internet_gateway_exclusion_mode(self) -> Optional['VpcBlockPublicAccessExclusionInternetGatewayExclusionMode']:
        """
        The desired Block Public Access Exclusion Mode for a specific VPC/Subnet.
        """
        return pulumi.get(self, "internet_gateway_exclusion_mode")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")


class AwaitableGetVpcBlockPublicAccessExclusionResult(GetVpcBlockPublicAccessExclusionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetVpcBlockPublicAccessExclusionResult(
            exclusion_id=self.exclusion_id,
            internet_gateway_exclusion_mode=self.internet_gateway_exclusion_mode,
            tags=self.tags)


def get_vpc_block_public_access_exclusion(exclusion_id: Optional[builtins.str] = None,
                                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetVpcBlockPublicAccessExclusionResult:
    """
    Resource Type definition for AWS::EC2::VPCBlockPublicAccessExclusion.


    :param builtins.str exclusion_id: The ID of the exclusion
    """
    __args__ = dict()
    __args__['exclusionId'] = exclusion_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:ec2:getVpcBlockPublicAccessExclusion', __args__, opts=opts, typ=GetVpcBlockPublicAccessExclusionResult).value

    return AwaitableGetVpcBlockPublicAccessExclusionResult(
        exclusion_id=pulumi.get(__ret__, 'exclusion_id'),
        internet_gateway_exclusion_mode=pulumi.get(__ret__, 'internet_gateway_exclusion_mode'),
        tags=pulumi.get(__ret__, 'tags'))
def get_vpc_block_public_access_exclusion_output(exclusion_id: Optional[pulumi.Input[builtins.str]] = None,
                                                 opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetVpcBlockPublicAccessExclusionResult]:
    """
    Resource Type definition for AWS::EC2::VPCBlockPublicAccessExclusion.


    :param builtins.str exclusion_id: The ID of the exclusion
    """
    __args__ = dict()
    __args__['exclusionId'] = exclusion_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:ec2:getVpcBlockPublicAccessExclusion', __args__, opts=opts, typ=GetVpcBlockPublicAccessExclusionResult)
    return __ret__.apply(lambda __response__: GetVpcBlockPublicAccessExclusionResult(
        exclusion_id=pulumi.get(__response__, 'exclusion_id'),
        internet_gateway_exclusion_mode=pulumi.get(__response__, 'internet_gateway_exclusion_mode'),
        tags=pulumi.get(__response__, 'tags')))
