# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetSubnetCidrBlockResult',
    'AwaitableGetSubnetCidrBlockResult',
    'get_subnet_cidr_block',
    'get_subnet_cidr_block_output',
]

@pulumi.output_type
class GetSubnetCidrBlockResult:
    def __init__(__self__, id=None, ip_source=None, ipv6_address_attribute=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ip_source and not isinstance(ip_source, str):
            raise TypeError("Expected argument 'ip_source' to be a str")
        pulumi.set(__self__, "ip_source", ip_source)
        if ipv6_address_attribute and not isinstance(ipv6_address_attribute, str):
            raise TypeError("Expected argument 'ipv6_address_attribute' to be a str")
        pulumi.set(__self__, "ipv6_address_attribute", ipv6_address_attribute)

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        Information about the IPv6 association.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="ipSource")
    def ip_source(self) -> Optional[builtins.str]:
        """
        The IP Source of an IPv6 Subnet CIDR Block.
        """
        return pulumi.get(self, "ip_source")

    @property
    @pulumi.getter(name="ipv6AddressAttribute")
    def ipv6_address_attribute(self) -> Optional[builtins.str]:
        """
        The value denoting whether an IPv6 Subnet CIDR Block is public or private.
        """
        return pulumi.get(self, "ipv6_address_attribute")


class AwaitableGetSubnetCidrBlockResult(GetSubnetCidrBlockResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSubnetCidrBlockResult(
            id=self.id,
            ip_source=self.ip_source,
            ipv6_address_attribute=self.ipv6_address_attribute)


def get_subnet_cidr_block(id: Optional[builtins.str] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSubnetCidrBlockResult:
    """
    The AWS::EC2::SubnetCidrBlock resource creates association between subnet and IPv6 CIDR


    :param builtins.str id: Information about the IPv6 association.
    """
    __args__ = dict()
    __args__['id'] = id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:ec2:getSubnetCidrBlock', __args__, opts=opts, typ=GetSubnetCidrBlockResult).value

    return AwaitableGetSubnetCidrBlockResult(
        id=pulumi.get(__ret__, 'id'),
        ip_source=pulumi.get(__ret__, 'ip_source'),
        ipv6_address_attribute=pulumi.get(__ret__, 'ipv6_address_attribute'))
def get_subnet_cidr_block_output(id: Optional[pulumi.Input[builtins.str]] = None,
                                 opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSubnetCidrBlockResult]:
    """
    The AWS::EC2::SubnetCidrBlock resource creates association between subnet and IPv6 CIDR


    :param builtins.str id: Information about the IPv6 association.
    """
    __args__ = dict()
    __args__['id'] = id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:ec2:getSubnetCidrBlock', __args__, opts=opts, typ=GetSubnetCidrBlockResult)
    return __ret__.apply(lambda __response__: GetSubnetCidrBlockResult(
        id=pulumi.get(__response__, 'id'),
        ip_source=pulumi.get(__response__, 'ip_source'),
        ipv6_address_attribute=pulumi.get(__response__, 'ipv6_address_attribute')))
