# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from ._enums import *

__all__ = [
    'GetSecurityGroupVpcAssociationResult',
    'AwaitableGetSecurityGroupVpcAssociationResult',
    'get_security_group_vpc_association',
    'get_security_group_vpc_association_output',
]

@pulumi.output_type
class GetSecurityGroupVpcAssociationResult:
    def __init__(__self__, state=None, state_reason=None, vpc_owner_id=None):
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if state_reason and not isinstance(state_reason, str):
            raise TypeError("Expected argument 'state_reason' to be a str")
        pulumi.set(__self__, "state_reason", state_reason)
        if vpc_owner_id and not isinstance(vpc_owner_id, str):
            raise TypeError("Expected argument 'vpc_owner_id' to be a str")
        pulumi.set(__self__, "vpc_owner_id", vpc_owner_id)

    @property
    @pulumi.getter
    def state(self) -> Optional['SecurityGroupVpcAssociationState']:
        """
        The state of the security group vpc association.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="stateReason")
    def state_reason(self) -> Optional[builtins.str]:
        """
        The reason for the state of the security group vpc association.
        """
        return pulumi.get(self, "state_reason")

    @property
    @pulumi.getter(name="vpcOwnerId")
    def vpc_owner_id(self) -> Optional[builtins.str]:
        """
        The owner of the VPC in the security group vpc association.
        """
        return pulumi.get(self, "vpc_owner_id")


class AwaitableGetSecurityGroupVpcAssociationResult(GetSecurityGroupVpcAssociationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSecurityGroupVpcAssociationResult(
            state=self.state,
            state_reason=self.state_reason,
            vpc_owner_id=self.vpc_owner_id)


def get_security_group_vpc_association(group_id: Optional[builtins.str] = None,
                                       vpc_id: Optional[builtins.str] = None,
                                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSecurityGroupVpcAssociationResult:
    """
    Resource type definition for the AWS::EC2::SecurityGroupVpcAssociation resource


    :param builtins.str group_id: The group ID of the specified security group.
    :param builtins.str vpc_id: The ID of the VPC in the security group vpc association.
    """
    __args__ = dict()
    __args__['groupId'] = group_id
    __args__['vpcId'] = vpc_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:ec2:getSecurityGroupVpcAssociation', __args__, opts=opts, typ=GetSecurityGroupVpcAssociationResult).value

    return AwaitableGetSecurityGroupVpcAssociationResult(
        state=pulumi.get(__ret__, 'state'),
        state_reason=pulumi.get(__ret__, 'state_reason'),
        vpc_owner_id=pulumi.get(__ret__, 'vpc_owner_id'))
def get_security_group_vpc_association_output(group_id: Optional[pulumi.Input[builtins.str]] = None,
                                              vpc_id: Optional[pulumi.Input[builtins.str]] = None,
                                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSecurityGroupVpcAssociationResult]:
    """
    Resource type definition for the AWS::EC2::SecurityGroupVpcAssociation resource


    :param builtins.str group_id: The group ID of the specified security group.
    :param builtins.str vpc_id: The ID of the VPC in the security group vpc association.
    """
    __args__ = dict()
    __args__['groupId'] = group_id
    __args__['vpcId'] = vpc_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:ec2:getSecurityGroupVpcAssociation', __args__, opts=opts, typ=GetSecurityGroupVpcAssociationResult)
    return __ret__.apply(lambda __response__: GetSecurityGroupVpcAssociationResult(
        state=pulumi.get(__response__, 'state'),
        state_reason=pulumi.get(__response__, 'state_reason'),
        vpc_owner_id=pulumi.get(__response__, 'vpc_owner_id')))
