# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetSecurityGroupIngressResult',
    'AwaitableGetSecurityGroupIngressResult',
    'get_security_group_ingress',
    'get_security_group_ingress_output',
]

@pulumi.output_type
class GetSecurityGroupIngressResult:
    def __init__(__self__, description=None, id=None):
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        Updates the description of an ingress (inbound) security group rule. You can replace an existing description, or add a description to a rule that did not have one previously
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        The Security Group Rule Id
        """
        return pulumi.get(self, "id")


class AwaitableGetSecurityGroupIngressResult(GetSecurityGroupIngressResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSecurityGroupIngressResult(
            description=self.description,
            id=self.id)


def get_security_group_ingress(id: Optional[builtins.str] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSecurityGroupIngressResult:
    """
    Resource Type definition for AWS::EC2::SecurityGroupIngress


    :param builtins.str id: The Security Group Rule Id
    """
    __args__ = dict()
    __args__['id'] = id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:ec2:getSecurityGroupIngress', __args__, opts=opts, typ=GetSecurityGroupIngressResult).value

    return AwaitableGetSecurityGroupIngressResult(
        description=pulumi.get(__ret__, 'description'),
        id=pulumi.get(__ret__, 'id'))
def get_security_group_ingress_output(id: Optional[pulumi.Input[builtins.str]] = None,
                                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSecurityGroupIngressResult]:
    """
    Resource Type definition for AWS::EC2::SecurityGroupIngress


    :param builtins.str id: The Security Group Rule Id
    """
    __args__ = dict()
    __args__['id'] = id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:ec2:getSecurityGroupIngress', __args__, opts=opts, typ=GetSecurityGroupIngressResult)
    return __ret__.apply(lambda __response__: GetSecurityGroupIngressResult(
        description=pulumi.get(__response__, 'description'),
        id=pulumi.get(__response__, 'id')))
