# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from .. import outputs as _root_outputs

__all__ = [
    'GetRouteServerPeerResult',
    'AwaitableGetRouteServerPeerResult',
    'get_route_server_peer',
    'get_route_server_peer_output',
]

@pulumi.output_type
class GetRouteServerPeerResult:
    def __init__(__self__, arn=None, endpoint_eni_address=None, endpoint_eni_id=None, id=None, route_server_id=None, subnet_id=None, tags=None, vpc_id=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if endpoint_eni_address and not isinstance(endpoint_eni_address, str):
            raise TypeError("Expected argument 'endpoint_eni_address' to be a str")
        pulumi.set(__self__, "endpoint_eni_address", endpoint_eni_address)
        if endpoint_eni_id and not isinstance(endpoint_eni_id, str):
            raise TypeError("Expected argument 'endpoint_eni_id' to be a str")
        pulumi.set(__self__, "endpoint_eni_id", endpoint_eni_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if route_server_id and not isinstance(route_server_id, str):
            raise TypeError("Expected argument 'route_server_id' to be a str")
        pulumi.set(__self__, "route_server_id", route_server_id)
        if subnet_id and not isinstance(subnet_id, str):
            raise TypeError("Expected argument 'subnet_id' to be a str")
        pulumi.set(__self__, "subnet_id", subnet_id)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if vpc_id and not isinstance(vpc_id, str):
            raise TypeError("Expected argument 'vpc_id' to be a str")
        pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter
    def arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the Route Server Peer.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="endpointEniAddress")
    def endpoint_eni_address(self) -> Optional[builtins.str]:
        """
        Elastic Network Interface IP address owned by the Route Server Endpoint
        """
        return pulumi.get(self, "endpoint_eni_address")

    @property
    @pulumi.getter(name="endpointEniId")
    def endpoint_eni_id(self) -> Optional[builtins.str]:
        """
        Elastic Network Interface ID owned by the Route Server Endpoint
        """
        return pulumi.get(self, "endpoint_eni_id")

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        The ID of the Route Server Peer.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="routeServerId")
    def route_server_id(self) -> Optional[builtins.str]:
        """
        Route Server ID
        """
        return pulumi.get(self, "route_server_id")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[builtins.str]:
        """
        Subnet ID
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[builtins.str]:
        """
        VPC ID
        """
        return pulumi.get(self, "vpc_id")


class AwaitableGetRouteServerPeerResult(GetRouteServerPeerResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRouteServerPeerResult(
            arn=self.arn,
            endpoint_eni_address=self.endpoint_eni_address,
            endpoint_eni_id=self.endpoint_eni_id,
            id=self.id,
            route_server_id=self.route_server_id,
            subnet_id=self.subnet_id,
            tags=self.tags,
            vpc_id=self.vpc_id)


def get_route_server_peer(id: Optional[builtins.str] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRouteServerPeerResult:
    """
    VPC Route Server Peer


    :param builtins.str id: The ID of the Route Server Peer.
    """
    __args__ = dict()
    __args__['id'] = id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:ec2:getRouteServerPeer', __args__, opts=opts, typ=GetRouteServerPeerResult).value

    return AwaitableGetRouteServerPeerResult(
        arn=pulumi.get(__ret__, 'arn'),
        endpoint_eni_address=pulumi.get(__ret__, 'endpoint_eni_address'),
        endpoint_eni_id=pulumi.get(__ret__, 'endpoint_eni_id'),
        id=pulumi.get(__ret__, 'id'),
        route_server_id=pulumi.get(__ret__, 'route_server_id'),
        subnet_id=pulumi.get(__ret__, 'subnet_id'),
        tags=pulumi.get(__ret__, 'tags'),
        vpc_id=pulumi.get(__ret__, 'vpc_id'))
def get_route_server_peer_output(id: Optional[pulumi.Input[builtins.str]] = None,
                                 opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetRouteServerPeerResult]:
    """
    VPC Route Server Peer


    :param builtins.str id: The ID of the Route Server Peer.
    """
    __args__ = dict()
    __args__['id'] = id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:ec2:getRouteServerPeer', __args__, opts=opts, typ=GetRouteServerPeerResult)
    return __ret__.apply(lambda __response__: GetRouteServerPeerResult(
        arn=pulumi.get(__response__, 'arn'),
        endpoint_eni_address=pulumi.get(__response__, 'endpoint_eni_address'),
        endpoint_eni_id=pulumi.get(__response__, 'endpoint_eni_id'),
        id=pulumi.get(__response__, 'id'),
        route_server_id=pulumi.get(__response__, 'route_server_id'),
        subnet_id=pulumi.get(__response__, 'subnet_id'),
        tags=pulumi.get(__response__, 'tags'),
        vpc_id=pulumi.get(__response__, 'vpc_id')))
