# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from .. import outputs as _root_outputs

__all__ = [
    'GetRouteServerEndpointResult',
    'AwaitableGetRouteServerEndpointResult',
    'get_route_server_endpoint',
    'get_route_server_endpoint_output',
]

@pulumi.output_type
class GetRouteServerEndpointResult:
    def __init__(__self__, arn=None, eni_address=None, eni_id=None, id=None, tags=None, vpc_id=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if eni_address and not isinstance(eni_address, str):
            raise TypeError("Expected argument 'eni_address' to be a str")
        pulumi.set(__self__, "eni_address", eni_address)
        if eni_id and not isinstance(eni_id, str):
            raise TypeError("Expected argument 'eni_id' to be a str")
        pulumi.set(__self__, "eni_id", eni_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if vpc_id and not isinstance(vpc_id, str):
            raise TypeError("Expected argument 'vpc_id' to be a str")
        pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter
    def arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the Route Server Endpoint.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="eniAddress")
    def eni_address(self) -> Optional[builtins.str]:
        """
        Elastic Network Interface IP address owned by the Route Server Endpoint
        """
        return pulumi.get(self, "eni_address")

    @property
    @pulumi.getter(name="eniId")
    def eni_id(self) -> Optional[builtins.str]:
        """
        Elastic Network Interface ID owned by the Route Server Endpoint
        """
        return pulumi.get(self, "eni_id")

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        The ID of the Route Server Endpoint.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[builtins.str]:
        """
        VPC ID
        """
        return pulumi.get(self, "vpc_id")


class AwaitableGetRouteServerEndpointResult(GetRouteServerEndpointResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRouteServerEndpointResult(
            arn=self.arn,
            eni_address=self.eni_address,
            eni_id=self.eni_id,
            id=self.id,
            tags=self.tags,
            vpc_id=self.vpc_id)


def get_route_server_endpoint(id: Optional[builtins.str] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRouteServerEndpointResult:
    """
    VPC Route Server Endpoint


    :param builtins.str id: The ID of the Route Server Endpoint.
    """
    __args__ = dict()
    __args__['id'] = id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:ec2:getRouteServerEndpoint', __args__, opts=opts, typ=GetRouteServerEndpointResult).value

    return AwaitableGetRouteServerEndpointResult(
        arn=pulumi.get(__ret__, 'arn'),
        eni_address=pulumi.get(__ret__, 'eni_address'),
        eni_id=pulumi.get(__ret__, 'eni_id'),
        id=pulumi.get(__ret__, 'id'),
        tags=pulumi.get(__ret__, 'tags'),
        vpc_id=pulumi.get(__ret__, 'vpc_id'))
def get_route_server_endpoint_output(id: Optional[pulumi.Input[builtins.str]] = None,
                                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetRouteServerEndpointResult]:
    """
    VPC Route Server Endpoint


    :param builtins.str id: The ID of the Route Server Endpoint.
    """
    __args__ = dict()
    __args__['id'] = id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:ec2:getRouteServerEndpoint', __args__, opts=opts, typ=GetRouteServerEndpointResult)
    return __ret__.apply(lambda __response__: GetRouteServerEndpointResult(
        arn=pulumi.get(__response__, 'arn'),
        eni_address=pulumi.get(__response__, 'eni_address'),
        eni_id=pulumi.get(__response__, 'eni_id'),
        id=pulumi.get(__response__, 'id'),
        tags=pulumi.get(__response__, 'tags'),
        vpc_id=pulumi.get(__response__, 'vpc_id')))
