# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from .. import outputs as _root_outputs
from ._enums import *

__all__ = [
    'GetRouteServerResult',
    'AwaitableGetRouteServerResult',
    'get_route_server',
    'get_route_server_output',
]

@pulumi.output_type
class GetRouteServerResult:
    def __init__(__self__, arn=None, id=None, persist_routes=None, sns_notifications_enabled=None, tags=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if persist_routes and not isinstance(persist_routes, str):
            raise TypeError("Expected argument 'persist_routes' to be a str")
        pulumi.set(__self__, "persist_routes", persist_routes)
        if sns_notifications_enabled and not isinstance(sns_notifications_enabled, bool):
            raise TypeError("Expected argument 'sns_notifications_enabled' to be a bool")
        pulumi.set(__self__, "sns_notifications_enabled", sns_notifications_enabled)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the Route Server.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        The ID of the Route Server.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="persistRoutes")
    def persist_routes(self) -> Optional['RouteServerPersistRoutes']:
        """
        Whether to enable persistent routes
        """
        return pulumi.get(self, "persist_routes")

    @property
    @pulumi.getter(name="snsNotificationsEnabled")
    def sns_notifications_enabled(self) -> Optional[builtins.bool]:
        """
        Whether to enable SNS notifications
        """
        return pulumi.get(self, "sns_notifications_enabled")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")


class AwaitableGetRouteServerResult(GetRouteServerResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRouteServerResult(
            arn=self.arn,
            id=self.id,
            persist_routes=self.persist_routes,
            sns_notifications_enabled=self.sns_notifications_enabled,
            tags=self.tags)


def get_route_server(id: Optional[builtins.str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRouteServerResult:
    """
    VPC Route Server


    :param builtins.str id: The ID of the Route Server.
    """
    __args__ = dict()
    __args__['id'] = id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:ec2:getRouteServer', __args__, opts=opts, typ=GetRouteServerResult).value

    return AwaitableGetRouteServerResult(
        arn=pulumi.get(__ret__, 'arn'),
        id=pulumi.get(__ret__, 'id'),
        persist_routes=pulumi.get(__ret__, 'persist_routes'),
        sns_notifications_enabled=pulumi.get(__ret__, 'sns_notifications_enabled'),
        tags=pulumi.get(__ret__, 'tags'))
def get_route_server_output(id: Optional[pulumi.Input[builtins.str]] = None,
                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetRouteServerResult]:
    """
    VPC Route Server


    :param builtins.str id: The ID of the Route Server.
    """
    __args__ = dict()
    __args__['id'] = id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:ec2:getRouteServer', __args__, opts=opts, typ=GetRouteServerResult)
    return __ret__.apply(lambda __response__: GetRouteServerResult(
        arn=pulumi.get(__response__, 'arn'),
        id=pulumi.get(__response__, 'id'),
        persist_routes=pulumi.get(__response__, 'persist_routes'),
        sns_notifications_enabled=pulumi.get(__response__, 'sns_notifications_enabled'),
        tags=pulumi.get(__response__, 'tags')))
