# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetNetworkInterfaceAttachmentResult',
    'AwaitableGetNetworkInterfaceAttachmentResult',
    'get_network_interface_attachment',
    'get_network_interface_attachment_output',
]

@pulumi.output_type
class GetNetworkInterfaceAttachmentResult:
    def __init__(__self__, attachment_id=None, delete_on_termination=None, ena_srd_specification=None):
        if attachment_id and not isinstance(attachment_id, str):
            raise TypeError("Expected argument 'attachment_id' to be a str")
        pulumi.set(__self__, "attachment_id", attachment_id)
        if delete_on_termination and not isinstance(delete_on_termination, bool):
            raise TypeError("Expected argument 'delete_on_termination' to be a bool")
        pulumi.set(__self__, "delete_on_termination", delete_on_termination)
        if ena_srd_specification and not isinstance(ena_srd_specification, dict):
            raise TypeError("Expected argument 'ena_srd_specification' to be a dict")
        pulumi.set(__self__, "ena_srd_specification", ena_srd_specification)

    @property
    @pulumi.getter(name="attachmentId")
    def attachment_id(self) -> Optional[builtins.str]:
        """
        The ID of the network interface attachment.
        """
        return pulumi.get(self, "attachment_id")

    @property
    @pulumi.getter(name="deleteOnTermination")
    def delete_on_termination(self) -> Optional[builtins.bool]:
        """
        Whether to delete the network interface when the instance terminates. By default, this value is set to ``true``.
        """
        return pulumi.get(self, "delete_on_termination")

    @property
    @pulumi.getter(name="enaSrdSpecification")
    def ena_srd_specification(self) -> Optional['outputs.NetworkInterfaceAttachmentEnaSrdSpecification']:
        """
        Configures ENA Express for the network interface that this action attaches to the instance.
        """
        return pulumi.get(self, "ena_srd_specification")


class AwaitableGetNetworkInterfaceAttachmentResult(GetNetworkInterfaceAttachmentResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetNetworkInterfaceAttachmentResult(
            attachment_id=self.attachment_id,
            delete_on_termination=self.delete_on_termination,
            ena_srd_specification=self.ena_srd_specification)


def get_network_interface_attachment(attachment_id: Optional[builtins.str] = None,
                                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetNetworkInterfaceAttachmentResult:
    """
    Attaches an elastic network interface (ENI) to an Amazon EC2 instance. You can use this resource type to attach additional network interfaces to an instance without interruption.


    :param builtins.str attachment_id: The ID of the network interface attachment.
    """
    __args__ = dict()
    __args__['attachmentId'] = attachment_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:ec2:getNetworkInterfaceAttachment', __args__, opts=opts, typ=GetNetworkInterfaceAttachmentResult).value

    return AwaitableGetNetworkInterfaceAttachmentResult(
        attachment_id=pulumi.get(__ret__, 'attachment_id'),
        delete_on_termination=pulumi.get(__ret__, 'delete_on_termination'),
        ena_srd_specification=pulumi.get(__ret__, 'ena_srd_specification'))
def get_network_interface_attachment_output(attachment_id: Optional[pulumi.Input[builtins.str]] = None,
                                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetNetworkInterfaceAttachmentResult]:
    """
    Attaches an elastic network interface (ENI) to an Amazon EC2 instance. You can use this resource type to attach additional network interfaces to an instance without interruption.


    :param builtins.str attachment_id: The ID of the network interface attachment.
    """
    __args__ = dict()
    __args__['attachmentId'] = attachment_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:ec2:getNetworkInterfaceAttachment', __args__, opts=opts, typ=GetNetworkInterfaceAttachmentResult)
    return __ret__.apply(lambda __response__: GetNetworkInterfaceAttachmentResult(
        attachment_id=pulumi.get(__response__, 'attachment_id'),
        delete_on_termination=pulumi.get(__response__, 'delete_on_termination'),
        ena_srd_specification=pulumi.get(__response__, 'ena_srd_specification')))
