# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetKeyPairResult',
    'AwaitableGetKeyPairResult',
    'get_key_pair',
    'get_key_pair_output',
]

@pulumi.output_type
class GetKeyPairResult:
    def __init__(__self__, key_fingerprint=None, key_pair_id=None):
        if key_fingerprint and not isinstance(key_fingerprint, str):
            raise TypeError("Expected argument 'key_fingerprint' to be a str")
        pulumi.set(__self__, "key_fingerprint", key_fingerprint)
        if key_pair_id and not isinstance(key_pair_id, str):
            raise TypeError("Expected argument 'key_pair_id' to be a str")
        pulumi.set(__self__, "key_pair_id", key_pair_id)

    @property
    @pulumi.getter(name="keyFingerprint")
    def key_fingerprint(self) -> Optional[builtins.str]:
        """
        If you created the key pair using Amazon EC2:

        - For RSA key pairs, the key fingerprint is the SHA-1 digest of the DER encoded private key.
        - For ED25519 key pairs, the key fingerprint is the base64-encoded SHA-256 digest, which is the default for OpenSSH, starting with [OpenSSH 6.8](https://docs.aws.amazon.com/http://www.openssh.com/txt/release-6.8) .

        If you imported the key pair to Amazon EC2:

        - For RSA key pairs, the key fingerprint is the MD5 public key fingerprint as specified in section 4 of RFC 4716.
        - For ED25519 key pairs, the key fingerprint is the base64-encoded SHA-256 digest, which is the default for OpenSSH, starting with [OpenSSH 6.8](https://docs.aws.amazon.com/http://www.openssh.com/txt/release-6.8) .
        """
        return pulumi.get(self, "key_fingerprint")

    @property
    @pulumi.getter(name="keyPairId")
    def key_pair_id(self) -> Optional[builtins.str]:
        """
        The ID of the key pair.
        """
        return pulumi.get(self, "key_pair_id")


class AwaitableGetKeyPairResult(GetKeyPairResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetKeyPairResult(
            key_fingerprint=self.key_fingerprint,
            key_pair_id=self.key_pair_id)


def get_key_pair(key_name: Optional[builtins.str] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetKeyPairResult:
    """
    Specifies a key pair for use with an EC2long instance as follows:
      +  To import an existing key pair, include the ``PublicKeyMaterial`` property.
      +  To create a new key pair, omit the ``PublicKeyMaterial`` property.

     When you import an existing key pair, you specify the public key material for the key. We assume that you have the private key material for the key. CFNlong does not create or return the private key material when you import a key pair.
     When you create a new key pair, the private key is saved to SYSlong Parameter Store, using a parameter with the following name: ``/ec2/keypair/{key_pair_id}``. For more information about retrieving private key, and the required permissions, see [Create a key pair using](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/create-key-pairs.html#create-key-pair-cloudformation) in the *User Guide*.
     When CFN deletes a key pair that was created or imported by a stack, it also deletes the parameter that was used to store the private key material in Parameter Store.


    :param builtins.str key_name: A unique name for the key pair.
            Constraints: Up to 255 ASCII characters
    """
    __args__ = dict()
    __args__['keyName'] = key_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:ec2:getKeyPair', __args__, opts=opts, typ=GetKeyPairResult).value

    return AwaitableGetKeyPairResult(
        key_fingerprint=pulumi.get(__ret__, 'key_fingerprint'),
        key_pair_id=pulumi.get(__ret__, 'key_pair_id'))
def get_key_pair_output(key_name: Optional[pulumi.Input[builtins.str]] = None,
                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetKeyPairResult]:
    """
    Specifies a key pair for use with an EC2long instance as follows:
      +  To import an existing key pair, include the ``PublicKeyMaterial`` property.
      +  To create a new key pair, omit the ``PublicKeyMaterial`` property.

     When you import an existing key pair, you specify the public key material for the key. We assume that you have the private key material for the key. CFNlong does not create or return the private key material when you import a key pair.
     When you create a new key pair, the private key is saved to SYSlong Parameter Store, using a parameter with the following name: ``/ec2/keypair/{key_pair_id}``. For more information about retrieving private key, and the required permissions, see [Create a key pair using](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/create-key-pairs.html#create-key-pair-cloudformation) in the *User Guide*.
     When CFN deletes a key pair that was created or imported by a stack, it also deletes the parameter that was used to store the private key material in Parameter Store.


    :param builtins.str key_name: A unique name for the key pair.
            Constraints: Up to 255 ASCII characters
    """
    __args__ = dict()
    __args__['keyName'] = key_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:ec2:getKeyPair', __args__, opts=opts, typ=GetKeyPairResult)
    return __ret__.apply(lambda __response__: GetKeyPairResult(
        key_fingerprint=pulumi.get(__response__, 'key_fingerprint'),
        key_pair_id=pulumi.get(__response__, 'key_pair_id')))
