# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import outputs as _root_outputs

__all__ = [
    'GetIpamResourceDiscoveryResult',
    'AwaitableGetIpamResourceDiscoveryResult',
    'get_ipam_resource_discovery',
    'get_ipam_resource_discovery_output',
]

@pulumi.output_type
class GetIpamResourceDiscoveryResult:
    def __init__(__self__, description=None, ipam_resource_discovery_arn=None, ipam_resource_discovery_id=None, ipam_resource_discovery_region=None, is_default=None, operating_regions=None, organizational_unit_exclusions=None, owner_id=None, state=None, tags=None):
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if ipam_resource_discovery_arn and not isinstance(ipam_resource_discovery_arn, str):
            raise TypeError("Expected argument 'ipam_resource_discovery_arn' to be a str")
        pulumi.set(__self__, "ipam_resource_discovery_arn", ipam_resource_discovery_arn)
        if ipam_resource_discovery_id and not isinstance(ipam_resource_discovery_id, str):
            raise TypeError("Expected argument 'ipam_resource_discovery_id' to be a str")
        pulumi.set(__self__, "ipam_resource_discovery_id", ipam_resource_discovery_id)
        if ipam_resource_discovery_region and not isinstance(ipam_resource_discovery_region, str):
            raise TypeError("Expected argument 'ipam_resource_discovery_region' to be a str")
        pulumi.set(__self__, "ipam_resource_discovery_region", ipam_resource_discovery_region)
        if is_default and not isinstance(is_default, bool):
            raise TypeError("Expected argument 'is_default' to be a bool")
        pulumi.set(__self__, "is_default", is_default)
        if operating_regions and not isinstance(operating_regions, list):
            raise TypeError("Expected argument 'operating_regions' to be a list")
        pulumi.set(__self__, "operating_regions", operating_regions)
        if organizational_unit_exclusions and not isinstance(organizational_unit_exclusions, list):
            raise TypeError("Expected argument 'organizational_unit_exclusions' to be a list")
        pulumi.set(__self__, "organizational_unit_exclusions", organizational_unit_exclusions)
        if owner_id and not isinstance(owner_id, str):
            raise TypeError("Expected argument 'owner_id' to be a str")
        pulumi.set(__self__, "owner_id", owner_id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        The resource discovery description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="ipamResourceDiscoveryArn")
    def ipam_resource_discovery_arn(self) -> Optional[builtins.str]:
        """
        Amazon Resource Name (Arn) for the Resource Discovery.
        """
        return pulumi.get(self, "ipam_resource_discovery_arn")

    @property
    @pulumi.getter(name="ipamResourceDiscoveryId")
    def ipam_resource_discovery_id(self) -> Optional[builtins.str]:
        """
        Id of the IPAM Pool.
        """
        return pulumi.get(self, "ipam_resource_discovery_id")

    @property
    @pulumi.getter(name="ipamResourceDiscoveryRegion")
    def ipam_resource_discovery_region(self) -> Optional[builtins.str]:
        """
        The region the resource discovery is setup in. 
        """
        return pulumi.get(self, "ipam_resource_discovery_region")

    @property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> Optional[builtins.bool]:
        """
        Determines whether or not address space from this pool is publicly advertised. Must be set if and only if the pool is IPv6.
        """
        return pulumi.get(self, "is_default")

    @property
    @pulumi.getter(name="operatingRegions")
    def operating_regions(self) -> Optional[Sequence['outputs.IpamResourceDiscoveryIpamOperatingRegion']]:
        """
        The regions Resource Discovery is enabled for. Allows resource discoveries to be created in these regions, as well as enabling monitoring
        """
        return pulumi.get(self, "operating_regions")

    @property
    @pulumi.getter(name="organizationalUnitExclusions")
    def organizational_unit_exclusions(self) -> Optional[Sequence['outputs.IpamResourceDiscoveryOrganizationalUnitExclusion']]:
        """
        A set of organizational unit (OU) exclusions for this resource.
        """
        return pulumi.get(self, "organizational_unit_exclusions")

    @property
    @pulumi.getter(name="ownerId")
    def owner_id(self) -> Optional[builtins.str]:
        """
        Owner Account ID of the Resource Discovery
        """
        return pulumi.get(self, "owner_id")

    @property
    @pulumi.getter
    def state(self) -> Optional[builtins.str]:
        """
        The state of this Resource Discovery.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")


class AwaitableGetIpamResourceDiscoveryResult(GetIpamResourceDiscoveryResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetIpamResourceDiscoveryResult(
            description=self.description,
            ipam_resource_discovery_arn=self.ipam_resource_discovery_arn,
            ipam_resource_discovery_id=self.ipam_resource_discovery_id,
            ipam_resource_discovery_region=self.ipam_resource_discovery_region,
            is_default=self.is_default,
            operating_regions=self.operating_regions,
            organizational_unit_exclusions=self.organizational_unit_exclusions,
            owner_id=self.owner_id,
            state=self.state,
            tags=self.tags)


def get_ipam_resource_discovery(ipam_resource_discovery_id: Optional[builtins.str] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetIpamResourceDiscoveryResult:
    """
    Resource Schema of AWS::EC2::IPAMResourceDiscovery Type


    :param builtins.str ipam_resource_discovery_id: Id of the IPAM Pool.
    """
    __args__ = dict()
    __args__['ipamResourceDiscoveryId'] = ipam_resource_discovery_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:ec2:getIpamResourceDiscovery', __args__, opts=opts, typ=GetIpamResourceDiscoveryResult).value

    return AwaitableGetIpamResourceDiscoveryResult(
        description=pulumi.get(__ret__, 'description'),
        ipam_resource_discovery_arn=pulumi.get(__ret__, 'ipam_resource_discovery_arn'),
        ipam_resource_discovery_id=pulumi.get(__ret__, 'ipam_resource_discovery_id'),
        ipam_resource_discovery_region=pulumi.get(__ret__, 'ipam_resource_discovery_region'),
        is_default=pulumi.get(__ret__, 'is_default'),
        operating_regions=pulumi.get(__ret__, 'operating_regions'),
        organizational_unit_exclusions=pulumi.get(__ret__, 'organizational_unit_exclusions'),
        owner_id=pulumi.get(__ret__, 'owner_id'),
        state=pulumi.get(__ret__, 'state'),
        tags=pulumi.get(__ret__, 'tags'))
def get_ipam_resource_discovery_output(ipam_resource_discovery_id: Optional[pulumi.Input[builtins.str]] = None,
                                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetIpamResourceDiscoveryResult]:
    """
    Resource Schema of AWS::EC2::IPAMResourceDiscovery Type


    :param builtins.str ipam_resource_discovery_id: Id of the IPAM Pool.
    """
    __args__ = dict()
    __args__['ipamResourceDiscoveryId'] = ipam_resource_discovery_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:ec2:getIpamResourceDiscovery', __args__, opts=opts, typ=GetIpamResourceDiscoveryResult)
    return __ret__.apply(lambda __response__: GetIpamResourceDiscoveryResult(
        description=pulumi.get(__response__, 'description'),
        ipam_resource_discovery_arn=pulumi.get(__response__, 'ipam_resource_discovery_arn'),
        ipam_resource_discovery_id=pulumi.get(__response__, 'ipam_resource_discovery_id'),
        ipam_resource_discovery_region=pulumi.get(__response__, 'ipam_resource_discovery_region'),
        is_default=pulumi.get(__response__, 'is_default'),
        operating_regions=pulumi.get(__response__, 'operating_regions'),
        organizational_unit_exclusions=pulumi.get(__response__, 'organizational_unit_exclusions'),
        owner_id=pulumi.get(__response__, 'owner_id'),
        state=pulumi.get(__response__, 'state'),
        tags=pulumi.get(__response__, 'tags')))
