# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import outputs as _root_outputs
from ._enums import *

__all__ = [
    'GetIpamResult',
    'AwaitableGetIpamResult',
    'get_ipam',
    'get_ipam_output',
]

@pulumi.output_type
class GetIpamResult:
    def __init__(__self__, arn=None, default_resource_discovery_association_id=None, default_resource_discovery_id=None, default_resource_discovery_organizational_unit_exclusions=None, description=None, enable_private_gua=None, ipam_id=None, metered_account=None, operating_regions=None, private_default_scope_id=None, public_default_scope_id=None, resource_discovery_association_count=None, scope_count=None, tags=None, tier=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if default_resource_discovery_association_id and not isinstance(default_resource_discovery_association_id, str):
            raise TypeError("Expected argument 'default_resource_discovery_association_id' to be a str")
        pulumi.set(__self__, "default_resource_discovery_association_id", default_resource_discovery_association_id)
        if default_resource_discovery_id and not isinstance(default_resource_discovery_id, str):
            raise TypeError("Expected argument 'default_resource_discovery_id' to be a str")
        pulumi.set(__self__, "default_resource_discovery_id", default_resource_discovery_id)
        if default_resource_discovery_organizational_unit_exclusions and not isinstance(default_resource_discovery_organizational_unit_exclusions, list):
            raise TypeError("Expected argument 'default_resource_discovery_organizational_unit_exclusions' to be a list")
        pulumi.set(__self__, "default_resource_discovery_organizational_unit_exclusions", default_resource_discovery_organizational_unit_exclusions)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if enable_private_gua and not isinstance(enable_private_gua, bool):
            raise TypeError("Expected argument 'enable_private_gua' to be a bool")
        pulumi.set(__self__, "enable_private_gua", enable_private_gua)
        if ipam_id and not isinstance(ipam_id, str):
            raise TypeError("Expected argument 'ipam_id' to be a str")
        pulumi.set(__self__, "ipam_id", ipam_id)
        if metered_account and not isinstance(metered_account, str):
            raise TypeError("Expected argument 'metered_account' to be a str")
        pulumi.set(__self__, "metered_account", metered_account)
        if operating_regions and not isinstance(operating_regions, list):
            raise TypeError("Expected argument 'operating_regions' to be a list")
        pulumi.set(__self__, "operating_regions", operating_regions)
        if private_default_scope_id and not isinstance(private_default_scope_id, str):
            raise TypeError("Expected argument 'private_default_scope_id' to be a str")
        pulumi.set(__self__, "private_default_scope_id", private_default_scope_id)
        if public_default_scope_id and not isinstance(public_default_scope_id, str):
            raise TypeError("Expected argument 'public_default_scope_id' to be a str")
        pulumi.set(__self__, "public_default_scope_id", public_default_scope_id)
        if resource_discovery_association_count and not isinstance(resource_discovery_association_count, int):
            raise TypeError("Expected argument 'resource_discovery_association_count' to be a int")
        pulumi.set(__self__, "resource_discovery_association_count", resource_discovery_association_count)
        if scope_count and not isinstance(scope_count, int):
            raise TypeError("Expected argument 'scope_count' to be a int")
        pulumi.set(__self__, "scope_count", scope_count)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if tier and not isinstance(tier, str):
            raise TypeError("Expected argument 'tier' to be a str")
        pulumi.set(__self__, "tier", tier)

    @property
    @pulumi.getter
    def arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the IPAM.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="defaultResourceDiscoveryAssociationId")
    def default_resource_discovery_association_id(self) -> Optional[builtins.str]:
        """
        The Id of the default association to the default resource discovery, created with this IPAM.
        """
        return pulumi.get(self, "default_resource_discovery_association_id")

    @property
    @pulumi.getter(name="defaultResourceDiscoveryId")
    def default_resource_discovery_id(self) -> Optional[builtins.str]:
        """
        The Id of the default resource discovery, created with this IPAM.
        """
        return pulumi.get(self, "default_resource_discovery_id")

    @property
    @pulumi.getter(name="defaultResourceDiscoveryOrganizationalUnitExclusions")
    def default_resource_discovery_organizational_unit_exclusions(self) -> Optional[Sequence['outputs.IpamOrganizationalUnitExclusion']]:
        """
        A set of organizational unit (OU) exclusions for the default resource discovery, created with this IPAM.
        """
        return pulumi.get(self, "default_resource_discovery_organizational_unit_exclusions")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        The description for the IPAM.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="enablePrivateGua")
    def enable_private_gua(self) -> Optional[builtins.bool]:
        """
        Enable provisioning of GUA space in private pools.
        """
        return pulumi.get(self, "enable_private_gua")

    @property
    @pulumi.getter(name="ipamId")
    def ipam_id(self) -> Optional[builtins.str]:
        """
        Id of the IPAM.
        """
        return pulumi.get(self, "ipam_id")

    @property
    @pulumi.getter(name="meteredAccount")
    def metered_account(self) -> Optional['IpamMeteredAccount']:
        """
        A metered account is an account that is charged for active IP addresses managed in IPAM
        """
        return pulumi.get(self, "metered_account")

    @property
    @pulumi.getter(name="operatingRegions")
    def operating_regions(self) -> Optional[Sequence['outputs.IpamOperatingRegion']]:
        """
        The regions IPAM is enabled for. Allows pools to be created in these regions, as well as enabling monitoring
        """
        return pulumi.get(self, "operating_regions")

    @property
    @pulumi.getter(name="privateDefaultScopeId")
    def private_default_scope_id(self) -> Optional[builtins.str]:
        """
        The Id of the default scope for publicly routable IP space, created with this IPAM.
        """
        return pulumi.get(self, "private_default_scope_id")

    @property
    @pulumi.getter(name="publicDefaultScopeId")
    def public_default_scope_id(self) -> Optional[builtins.str]:
        """
        The Id of the default scope for publicly routable IP space, created with this IPAM.
        """
        return pulumi.get(self, "public_default_scope_id")

    @property
    @pulumi.getter(name="resourceDiscoveryAssociationCount")
    def resource_discovery_association_count(self) -> Optional[builtins.int]:
        """
        The count of resource discoveries associated with this IPAM.
        """
        return pulumi.get(self, "resource_discovery_association_count")

    @property
    @pulumi.getter(name="scopeCount")
    def scope_count(self) -> Optional[builtins.int]:
        """
        The number of scopes that currently exist in this IPAM.
        """
        return pulumi.get(self, "scope_count")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def tier(self) -> Optional['IpamTier']:
        """
        The tier of the IPAM.
        """
        return pulumi.get(self, "tier")


class AwaitableGetIpamResult(GetIpamResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetIpamResult(
            arn=self.arn,
            default_resource_discovery_association_id=self.default_resource_discovery_association_id,
            default_resource_discovery_id=self.default_resource_discovery_id,
            default_resource_discovery_organizational_unit_exclusions=self.default_resource_discovery_organizational_unit_exclusions,
            description=self.description,
            enable_private_gua=self.enable_private_gua,
            ipam_id=self.ipam_id,
            metered_account=self.metered_account,
            operating_regions=self.operating_regions,
            private_default_scope_id=self.private_default_scope_id,
            public_default_scope_id=self.public_default_scope_id,
            resource_discovery_association_count=self.resource_discovery_association_count,
            scope_count=self.scope_count,
            tags=self.tags,
            tier=self.tier)


def get_ipam(ipam_id: Optional[builtins.str] = None,
             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetIpamResult:
    """
    Resource Schema of AWS::EC2::IPAM Type


    :param builtins.str ipam_id: Id of the IPAM.
    """
    __args__ = dict()
    __args__['ipamId'] = ipam_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:ec2:getIpam', __args__, opts=opts, typ=GetIpamResult).value

    return AwaitableGetIpamResult(
        arn=pulumi.get(__ret__, 'arn'),
        default_resource_discovery_association_id=pulumi.get(__ret__, 'default_resource_discovery_association_id'),
        default_resource_discovery_id=pulumi.get(__ret__, 'default_resource_discovery_id'),
        default_resource_discovery_organizational_unit_exclusions=pulumi.get(__ret__, 'default_resource_discovery_organizational_unit_exclusions'),
        description=pulumi.get(__ret__, 'description'),
        enable_private_gua=pulumi.get(__ret__, 'enable_private_gua'),
        ipam_id=pulumi.get(__ret__, 'ipam_id'),
        metered_account=pulumi.get(__ret__, 'metered_account'),
        operating_regions=pulumi.get(__ret__, 'operating_regions'),
        private_default_scope_id=pulumi.get(__ret__, 'private_default_scope_id'),
        public_default_scope_id=pulumi.get(__ret__, 'public_default_scope_id'),
        resource_discovery_association_count=pulumi.get(__ret__, 'resource_discovery_association_count'),
        scope_count=pulumi.get(__ret__, 'scope_count'),
        tags=pulumi.get(__ret__, 'tags'),
        tier=pulumi.get(__ret__, 'tier'))
def get_ipam_output(ipam_id: Optional[pulumi.Input[builtins.str]] = None,
                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetIpamResult]:
    """
    Resource Schema of AWS::EC2::IPAM Type


    :param builtins.str ipam_id: Id of the IPAM.
    """
    __args__ = dict()
    __args__['ipamId'] = ipam_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:ec2:getIpam', __args__, opts=opts, typ=GetIpamResult)
    return __ret__.apply(lambda __response__: GetIpamResult(
        arn=pulumi.get(__response__, 'arn'),
        default_resource_discovery_association_id=pulumi.get(__response__, 'default_resource_discovery_association_id'),
        default_resource_discovery_id=pulumi.get(__response__, 'default_resource_discovery_id'),
        default_resource_discovery_organizational_unit_exclusions=pulumi.get(__response__, 'default_resource_discovery_organizational_unit_exclusions'),
        description=pulumi.get(__response__, 'description'),
        enable_private_gua=pulumi.get(__response__, 'enable_private_gua'),
        ipam_id=pulumi.get(__response__, 'ipam_id'),
        metered_account=pulumi.get(__response__, 'metered_account'),
        operating_regions=pulumi.get(__response__, 'operating_regions'),
        private_default_scope_id=pulumi.get(__response__, 'private_default_scope_id'),
        public_default_scope_id=pulumi.get(__response__, 'public_default_scope_id'),
        resource_discovery_association_count=pulumi.get(__response__, 'resource_discovery_association_count'),
        scope_count=pulumi.get(__response__, 'scope_count'),
        tags=pulumi.get(__response__, 'tags'),
        tier=pulumi.get(__response__, 'tier')))
