# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from .. import outputs as _root_outputs

__all__ = [
    'GetInternetGatewayResult',
    'AwaitableGetInternetGatewayResult',
    'get_internet_gateway',
    'get_internet_gateway_output',
]

@pulumi.output_type
class GetInternetGatewayResult:
    def __init__(__self__, internet_gateway_id=None, tags=None):
        if internet_gateway_id and not isinstance(internet_gateway_id, str):
            raise TypeError("Expected argument 'internet_gateway_id' to be a str")
        pulumi.set(__self__, "internet_gateway_id", internet_gateway_id)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="internetGatewayId")
    def internet_gateway_id(self) -> Optional[builtins.str]:
        """
        The ID of the internet gateway.
        """
        return pulumi.get(self, "internet_gateway_id")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        Any tags to assign to the internet gateway.
        """
        return pulumi.get(self, "tags")


class AwaitableGetInternetGatewayResult(GetInternetGatewayResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetInternetGatewayResult(
            internet_gateway_id=self.internet_gateway_id,
            tags=self.tags)


def get_internet_gateway(internet_gateway_id: Optional[builtins.str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetInternetGatewayResult:
    """
    Allocates an internet gateway for use with a VPC. After creating the Internet gateway, you then attach it to a VPC.


    :param builtins.str internet_gateway_id: The ID of the internet gateway.
    """
    __args__ = dict()
    __args__['internetGatewayId'] = internet_gateway_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:ec2:getInternetGateway', __args__, opts=opts, typ=GetInternetGatewayResult).value

    return AwaitableGetInternetGatewayResult(
        internet_gateway_id=pulumi.get(__ret__, 'internet_gateway_id'),
        tags=pulumi.get(__ret__, 'tags'))
def get_internet_gateway_output(internet_gateway_id: Optional[pulumi.Input[builtins.str]] = None,
                                opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetInternetGatewayResult]:
    """
    Allocates an internet gateway for use with a VPC. After creating the Internet gateway, you then attach it to a VPC.


    :param builtins.str internet_gateway_id: The ID of the internet gateway.
    """
    __args__ = dict()
    __args__['internetGatewayId'] = internet_gateway_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:ec2:getInternetGateway', __args__, opts=opts, typ=GetInternetGatewayResult)
    return __ret__.apply(lambda __response__: GetInternetGatewayResult(
        internet_gateway_id=pulumi.get(__response__, 'internet_gateway_id'),
        tags=pulumi.get(__response__, 'tags')))
