# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from .. import outputs as _root_outputs

__all__ = [
    'GetFlowLogResult',
    'AwaitableGetFlowLogResult',
    'get_flow_log',
    'get_flow_log_output',
]

@pulumi.output_type
class GetFlowLogResult:
    def __init__(__self__, id=None, tags=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        The Flow Log ID
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        The tags to apply to the flow logs.
        """
        return pulumi.get(self, "tags")


class AwaitableGetFlowLogResult(GetFlowLogResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetFlowLogResult(
            id=self.id,
            tags=self.tags)


def get_flow_log(id: Optional[builtins.str] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetFlowLogResult:
    """
    Specifies a VPC flow log, which enables you to capture IP traffic for a specific network interface, subnet, or VPC.


    :param builtins.str id: The Flow Log ID
    """
    __args__ = dict()
    __args__['id'] = id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:ec2:getFlowLog', __args__, opts=opts, typ=GetFlowLogResult).value

    return AwaitableGetFlowLogResult(
        id=pulumi.get(__ret__, 'id'),
        tags=pulumi.get(__ret__, 'tags'))
def get_flow_log_output(id: Optional[pulumi.Input[builtins.str]] = None,
                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetFlowLogResult]:
    """
    Specifies a VPC flow log, which enables you to capture IP traffic for a specific network interface, subnet, or VPC.


    :param builtins.str id: The Flow Log ID
    """
    __args__ = dict()
    __args__['id'] = id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:ec2:getFlowLog', __args__, opts=opts, typ=GetFlowLogResult)
    return __ret__.apply(lambda __response__: GetFlowLogResult(
        id=pulumi.get(__response__, 'id'),
        tags=pulumi.get(__response__, 'tags')))
