# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from .. import outputs as _root_outputs

__all__ = [
    'GetCarrierGatewayResult',
    'AwaitableGetCarrierGatewayResult',
    'get_carrier_gateway',
    'get_carrier_gateway_output',
]

@pulumi.output_type
class GetCarrierGatewayResult:
    def __init__(__self__, carrier_gateway_id=None, owner_id=None, state=None, tags=None):
        if carrier_gateway_id and not isinstance(carrier_gateway_id, str):
            raise TypeError("Expected argument 'carrier_gateway_id' to be a str")
        pulumi.set(__self__, "carrier_gateway_id", carrier_gateway_id)
        if owner_id and not isinstance(owner_id, str):
            raise TypeError("Expected argument 'owner_id' to be a str")
        pulumi.set(__self__, "owner_id", owner_id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="carrierGatewayId")
    def carrier_gateway_id(self) -> Optional[builtins.str]:
        """
        The ID of the carrier gateway.
        """
        return pulumi.get(self, "carrier_gateway_id")

    @property
    @pulumi.getter(name="ownerId")
    def owner_id(self) -> Optional[builtins.str]:
        """
        The ID of the owner.
        """
        return pulumi.get(self, "owner_id")

    @property
    @pulumi.getter
    def state(self) -> Optional[builtins.str]:
        """
        The state of the carrier gateway.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        The tags for the carrier gateway.
        """
        return pulumi.get(self, "tags")


class AwaitableGetCarrierGatewayResult(GetCarrierGatewayResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCarrierGatewayResult(
            carrier_gateway_id=self.carrier_gateway_id,
            owner_id=self.owner_id,
            state=self.state,
            tags=self.tags)


def get_carrier_gateway(carrier_gateway_id: Optional[builtins.str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCarrierGatewayResult:
    """
    Resource Type definition for Carrier Gateway which describes the Carrier Gateway resource


    :param builtins.str carrier_gateway_id: The ID of the carrier gateway.
    """
    __args__ = dict()
    __args__['carrierGatewayId'] = carrier_gateway_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:ec2:getCarrierGateway', __args__, opts=opts, typ=GetCarrierGatewayResult).value

    return AwaitableGetCarrierGatewayResult(
        carrier_gateway_id=pulumi.get(__ret__, 'carrier_gateway_id'),
        owner_id=pulumi.get(__ret__, 'owner_id'),
        state=pulumi.get(__ret__, 'state'),
        tags=pulumi.get(__ret__, 'tags'))
def get_carrier_gateway_output(carrier_gateway_id: Optional[pulumi.Input[builtins.str]] = None,
                               opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetCarrierGatewayResult]:
    """
    Resource Type definition for Carrier Gateway which describes the Carrier Gateway resource


    :param builtins.str carrier_gateway_id: The ID of the carrier gateway.
    """
    __args__ = dict()
    __args__['carrierGatewayId'] = carrier_gateway_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:ec2:getCarrierGateway', __args__, opts=opts, typ=GetCarrierGatewayResult)
    return __ret__.apply(lambda __response__: GetCarrierGatewayResult(
        carrier_gateway_id=pulumi.get(__response__, 'carrier_gateway_id'),
        owner_id=pulumi.get(__response__, 'owner_id'),
        state=pulumi.get(__response__, 'state'),
        tags=pulumi.get(__response__, 'tags')))
