# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetCapacityReservationResult',
    'AwaitableGetCapacityReservationResult',
    'get_capacity_reservation',
    'get_capacity_reservation_output',
]

@pulumi.output_type
class GetCapacityReservationResult:
    def __init__(__self__, available_instance_count=None, capacity_allocation_set=None, capacity_reservation_arn=None, capacity_reservation_fleet_id=None, commitment_info=None, create_date=None, delivery_preference=None, end_date=None, end_date_type=None, id=None, instance_count=None, instance_match_criteria=None, owner_id=None, reservation_type=None, start_date=None, state=None, total_instance_count=None):
        if available_instance_count and not isinstance(available_instance_count, int):
            raise TypeError("Expected argument 'available_instance_count' to be a int")
        pulumi.set(__self__, "available_instance_count", available_instance_count)
        if capacity_allocation_set and not isinstance(capacity_allocation_set, list):
            raise TypeError("Expected argument 'capacity_allocation_set' to be a list")
        pulumi.set(__self__, "capacity_allocation_set", capacity_allocation_set)
        if capacity_reservation_arn and not isinstance(capacity_reservation_arn, str):
            raise TypeError("Expected argument 'capacity_reservation_arn' to be a str")
        pulumi.set(__self__, "capacity_reservation_arn", capacity_reservation_arn)
        if capacity_reservation_fleet_id and not isinstance(capacity_reservation_fleet_id, str):
            raise TypeError("Expected argument 'capacity_reservation_fleet_id' to be a str")
        pulumi.set(__self__, "capacity_reservation_fleet_id", capacity_reservation_fleet_id)
        if commitment_info and not isinstance(commitment_info, dict):
            raise TypeError("Expected argument 'commitment_info' to be a dict")
        pulumi.set(__self__, "commitment_info", commitment_info)
        if create_date and not isinstance(create_date, str):
            raise TypeError("Expected argument 'create_date' to be a str")
        pulumi.set(__self__, "create_date", create_date)
        if delivery_preference and not isinstance(delivery_preference, str):
            raise TypeError("Expected argument 'delivery_preference' to be a str")
        pulumi.set(__self__, "delivery_preference", delivery_preference)
        if end_date and not isinstance(end_date, str):
            raise TypeError("Expected argument 'end_date' to be a str")
        pulumi.set(__self__, "end_date", end_date)
        if end_date_type and not isinstance(end_date_type, str):
            raise TypeError("Expected argument 'end_date_type' to be a str")
        pulumi.set(__self__, "end_date_type", end_date_type)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if instance_count and not isinstance(instance_count, int):
            raise TypeError("Expected argument 'instance_count' to be a int")
        pulumi.set(__self__, "instance_count", instance_count)
        if instance_match_criteria and not isinstance(instance_match_criteria, str):
            raise TypeError("Expected argument 'instance_match_criteria' to be a str")
        pulumi.set(__self__, "instance_match_criteria", instance_match_criteria)
        if owner_id and not isinstance(owner_id, str):
            raise TypeError("Expected argument 'owner_id' to be a str")
        pulumi.set(__self__, "owner_id", owner_id)
        if reservation_type and not isinstance(reservation_type, str):
            raise TypeError("Expected argument 'reservation_type' to be a str")
        pulumi.set(__self__, "reservation_type", reservation_type)
        if start_date and not isinstance(start_date, str):
            raise TypeError("Expected argument 'start_date' to be a str")
        pulumi.set(__self__, "start_date", start_date)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if total_instance_count and not isinstance(total_instance_count, int):
            raise TypeError("Expected argument 'total_instance_count' to be a int")
        pulumi.set(__self__, "total_instance_count", total_instance_count)

    @property
    @pulumi.getter(name="availableInstanceCount")
    def available_instance_count(self) -> Optional[builtins.int]:
        """
        Returns the remaining capacity, which indicates the number of instances that can be launched in the Capacity Reservation. For example: `9` .
        """
        return pulumi.get(self, "available_instance_count")

    @property
    @pulumi.getter(name="capacityAllocationSet")
    def capacity_allocation_set(self) -> Optional[Sequence['outputs.CapacityReservationCapacityAllocation']]:
        return pulumi.get(self, "capacity_allocation_set")

    @property
    @pulumi.getter(name="capacityReservationArn")
    def capacity_reservation_arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the Capacity Reservation.
        """
        return pulumi.get(self, "capacity_reservation_arn")

    @property
    @pulumi.getter(name="capacityReservationFleetId")
    def capacity_reservation_fleet_id(self) -> Optional[builtins.str]:
        """
        The ID of the Capacity Reservation Fleet to which the Capacity Reservation belongs. Only valid for Capacity Reservations that were created by a Capacity Reservation Fleet.
        """
        return pulumi.get(self, "capacity_reservation_fleet_id")

    @property
    @pulumi.getter(name="commitmentInfo")
    def commitment_info(self) -> Optional['outputs.CommitmentInfoProperties']:
        return pulumi.get(self, "commitment_info")

    @property
    @pulumi.getter(name="createDate")
    def create_date(self) -> Optional[builtins.str]:
        """
        The date and time at which the Capacity Reservation was created.
        """
        return pulumi.get(self, "create_date")

    @property
    @pulumi.getter(name="deliveryPreference")
    def delivery_preference(self) -> Optional[builtins.str]:
        """
        The delivery method for a future-dated Capacity Reservation. `incremental` indicates that the requested capacity is delivered in addition to any running instances and reserved capacity that you have in your account at the requested date and time.
        """
        return pulumi.get(self, "delivery_preference")

    @property
    @pulumi.getter(name="endDate")
    def end_date(self) -> Optional[builtins.str]:
        """
        The date and time at which the Capacity Reservation expires. When a Capacity Reservation expires, the reserved capacity is released and you can no longer launch instances into it. The Capacity Reservation's state changes to `expired` when it reaches its end date and time.

        You must provide an `EndDate` value if `EndDateType` is `limited` . Omit `EndDate` if `EndDateType` is `unlimited` .

        If the `EndDateType` is `limited` , the Capacity Reservation is cancelled within an hour from the specified time. For example, if you specify 5/31/2019, 13:30:55, the Capacity Reservation is guaranteed to end between 13:30:55 and 14:30:55 on 5/31/2019.

        If you are requesting a future-dated Capacity Reservation, you can't specify an end date and time that is within the commitment duration.
        """
        return pulumi.get(self, "end_date")

    @property
    @pulumi.getter(name="endDateType")
    def end_date_type(self) -> Optional[builtins.str]:
        """
        Indicates the way in which the Capacity Reservation ends. A Capacity Reservation can have one of the following end types:

        - `unlimited` - The Capacity Reservation remains active until you explicitly cancel it. Do not provide an `EndDate` if the `EndDateType` is `unlimited` .
        - `limited` - The Capacity Reservation expires automatically at a specified date and time. You must provide an `EndDate` value if the `EndDateType` value is `limited` .
        """
        return pulumi.get(self, "end_date_type")

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        The ID of the Capacity Reservation.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="instanceCount")
    def instance_count(self) -> Optional[builtins.int]:
        """
        The number of instances for which to reserve capacity.

        > You can request future-dated Capacity Reservations for an instance count with a minimum of 100 vCPUs. For example, if you request a future-dated Capacity Reservation for `m5.xlarge` instances, you must request at least 25 instances ( *25 * m5.xlarge = 100 vCPUs* ). 

        Valid range: 1 - 1000
        """
        return pulumi.get(self, "instance_count")

    @property
    @pulumi.getter(name="instanceMatchCriteria")
    def instance_match_criteria(self) -> Optional[builtins.str]:
        """
        Indicates the type of instance launches that the Capacity Reservation accepts. The options include:

        - `open` - The Capacity Reservation automatically matches all instances that have matching attributes (instance type, platform, and Availability Zone). Instances that have matching attributes run in the Capacity Reservation automatically without specifying any additional parameters.
        - `targeted` - The Capacity Reservation only accepts instances that have matching attributes (instance type, platform, and Availability Zone), and explicitly target the Capacity Reservation. This ensures that only permitted instances can use the reserved capacity.

        > If you are requesting a future-dated Capacity Reservation, you must specify `targeted` . 

        Default: `open`
        """
        return pulumi.get(self, "instance_match_criteria")

    @property
    @pulumi.getter(name="ownerId")
    def owner_id(self) -> Optional[builtins.str]:
        """
        The ID of the AWS account that owns the Capacity Reservation.
        """
        return pulumi.get(self, "owner_id")

    @property
    @pulumi.getter(name="reservationType")
    def reservation_type(self) -> Optional[builtins.str]:
        """
        The type of Capacity Reservation.
        """
        return pulumi.get(self, "reservation_type")

    @property
    @pulumi.getter(name="startDate")
    def start_date(self) -> Optional[builtins.str]:
        """
        The date and time at which the Capacity Reservation was started.
        """
        return pulumi.get(self, "start_date")

    @property
    @pulumi.getter
    def state(self) -> Optional[builtins.str]:
        """
        The current state of the Capacity Reservation. A Capacity Reservation can be in one of the following states:

        - `active` - The capacity is available for use.
        - `expired` - The Capacity Reservation expired automatically at the date and time specified in your reservation request. The reserved capacity is no longer available for your use.
        - `cancelled` - The Capacity Reservation was canceled. The reserved capacity is no longer available for your use.
        - `pending` - The Capacity Reservation request was successful but the capacity provisioning is still pending.
        - `failed` - The Capacity Reservation request has failed. A request can fail due to request parameters that are not valid, capacity constraints, or instance limit constraints. You can view a failed request for 60 minutes.
        - `scheduled` - ( *Future-dated Capacity Reservations* ) The future-dated Capacity Reservation request was approved and the Capacity Reservation is scheduled for delivery on the requested start date.
        - `payment-pending` - ( *Capacity Blocks* ) The upfront payment has not been processed yet.
        - `payment-failed` - ( *Capacity Blocks* ) The upfront payment was not processed in the 12-hour time frame. Your Capacity Block was released.
        - `assessing` - ( *Future-dated Capacity Reservations* ) Amazon EC2 is assessing your request for a future-dated Capacity Reservation.
        - `delayed` - ( *Future-dated Capacity Reservations* ) Amazon EC2 encountered a delay in provisioning the requested future-dated Capacity Reservation. Amazon EC2 is unable to deliver the requested capacity by the requested start date and time.
        - `unsupported` - ( *Future-dated Capacity Reservations* ) Amazon EC2 can't support the future-dated Capacity Reservation request due to capacity constraints. You can view unsupported requests for 30 days. The Capacity Reservation will not be delivered.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="totalInstanceCount")
    def total_instance_count(self) -> Optional[builtins.int]:
        """
        Returns the total number of instances for which the Capacity Reservation reserves capacity. For example: `15` .
        """
        return pulumi.get(self, "total_instance_count")


class AwaitableGetCapacityReservationResult(GetCapacityReservationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCapacityReservationResult(
            available_instance_count=self.available_instance_count,
            capacity_allocation_set=self.capacity_allocation_set,
            capacity_reservation_arn=self.capacity_reservation_arn,
            capacity_reservation_fleet_id=self.capacity_reservation_fleet_id,
            commitment_info=self.commitment_info,
            create_date=self.create_date,
            delivery_preference=self.delivery_preference,
            end_date=self.end_date,
            end_date_type=self.end_date_type,
            id=self.id,
            instance_count=self.instance_count,
            instance_match_criteria=self.instance_match_criteria,
            owner_id=self.owner_id,
            reservation_type=self.reservation_type,
            start_date=self.start_date,
            state=self.state,
            total_instance_count=self.total_instance_count)


def get_capacity_reservation(id: Optional[builtins.str] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCapacityReservationResult:
    """
    Resource Type definition for AWS::EC2::CapacityReservation


    :param builtins.str id: The ID of the Capacity Reservation.
    """
    __args__ = dict()
    __args__['id'] = id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:ec2:getCapacityReservation', __args__, opts=opts, typ=GetCapacityReservationResult).value

    return AwaitableGetCapacityReservationResult(
        available_instance_count=pulumi.get(__ret__, 'available_instance_count'),
        capacity_allocation_set=pulumi.get(__ret__, 'capacity_allocation_set'),
        capacity_reservation_arn=pulumi.get(__ret__, 'capacity_reservation_arn'),
        capacity_reservation_fleet_id=pulumi.get(__ret__, 'capacity_reservation_fleet_id'),
        commitment_info=pulumi.get(__ret__, 'commitment_info'),
        create_date=pulumi.get(__ret__, 'create_date'),
        delivery_preference=pulumi.get(__ret__, 'delivery_preference'),
        end_date=pulumi.get(__ret__, 'end_date'),
        end_date_type=pulumi.get(__ret__, 'end_date_type'),
        id=pulumi.get(__ret__, 'id'),
        instance_count=pulumi.get(__ret__, 'instance_count'),
        instance_match_criteria=pulumi.get(__ret__, 'instance_match_criteria'),
        owner_id=pulumi.get(__ret__, 'owner_id'),
        reservation_type=pulumi.get(__ret__, 'reservation_type'),
        start_date=pulumi.get(__ret__, 'start_date'),
        state=pulumi.get(__ret__, 'state'),
        total_instance_count=pulumi.get(__ret__, 'total_instance_count'))
def get_capacity_reservation_output(id: Optional[pulumi.Input[builtins.str]] = None,
                                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetCapacityReservationResult]:
    """
    Resource Type definition for AWS::EC2::CapacityReservation


    :param builtins.str id: The ID of the Capacity Reservation.
    """
    __args__ = dict()
    __args__['id'] = id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:ec2:getCapacityReservation', __args__, opts=opts, typ=GetCapacityReservationResult)
    return __ret__.apply(lambda __response__: GetCapacityReservationResult(
        available_instance_count=pulumi.get(__response__, 'available_instance_count'),
        capacity_allocation_set=pulumi.get(__response__, 'capacity_allocation_set'),
        capacity_reservation_arn=pulumi.get(__response__, 'capacity_reservation_arn'),
        capacity_reservation_fleet_id=pulumi.get(__response__, 'capacity_reservation_fleet_id'),
        commitment_info=pulumi.get(__response__, 'commitment_info'),
        create_date=pulumi.get(__response__, 'create_date'),
        delivery_preference=pulumi.get(__response__, 'delivery_preference'),
        end_date=pulumi.get(__response__, 'end_date'),
        end_date_type=pulumi.get(__response__, 'end_date_type'),
        id=pulumi.get(__response__, 'id'),
        instance_count=pulumi.get(__response__, 'instance_count'),
        instance_match_criteria=pulumi.get(__response__, 'instance_match_criteria'),
        owner_id=pulumi.get(__response__, 'owner_id'),
        reservation_type=pulumi.get(__response__, 'reservation_type'),
        start_date=pulumi.get(__response__, 'start_date'),
        state=pulumi.get(__response__, 'state'),
        total_instance_count=pulumi.get(__response__, 'total_instance_count')))
