# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._enums import *
from ._inputs import *

__all__ = ['TableArgs', 'Table']

@pulumi.input_type
class TableArgs:
    def __init__(__self__, *,
                 key_schema: pulumi.Input[Union[Sequence[pulumi.Input['TableKeySchemaArgs']], Any]],
                 attribute_definitions: Optional[pulumi.Input[Sequence[pulumi.Input['TableAttributeDefinitionArgs']]]] = None,
                 billing_mode: Optional[pulumi.Input[builtins.str]] = None,
                 contributor_insights_specification: Optional[pulumi.Input['TableContributorInsightsSpecificationArgs']] = None,
                 deletion_protection_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 global_secondary_indexes: Optional[pulumi.Input[Sequence[pulumi.Input['TableGlobalSecondaryIndexArgs']]]] = None,
                 import_source_specification: Optional[pulumi.Input['TableImportSourceSpecificationArgs']] = None,
                 kinesis_stream_specification: Optional[pulumi.Input['TableKinesisStreamSpecificationArgs']] = None,
                 local_secondary_indexes: Optional[pulumi.Input[Sequence[pulumi.Input['TableLocalSecondaryIndexArgs']]]] = None,
                 on_demand_throughput: Optional[pulumi.Input['TableOnDemandThroughputArgs']] = None,
                 point_in_time_recovery_specification: Optional[pulumi.Input['TablePointInTimeRecoverySpecificationArgs']] = None,
                 provisioned_throughput: Optional[pulumi.Input['TableProvisionedThroughputArgs']] = None,
                 resource_policy: Optional[pulumi.Input['TableResourcePolicyArgs']] = None,
                 sse_specification: Optional[pulumi.Input['TableSseSpecificationArgs']] = None,
                 stream_specification: Optional[pulumi.Input['TableStreamSpecificationArgs']] = None,
                 table_class: Optional[pulumi.Input[builtins.str]] = None,
                 table_name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None,
                 time_to_live_specification: Optional[pulumi.Input['TableTimeToLiveSpecificationArgs']] = None,
                 warm_throughput: Optional[pulumi.Input['TableWarmThroughputArgs']] = None):
        """
        The set of arguments for constructing a Table resource.
        :param pulumi.Input[Union[Sequence[pulumi.Input['TableKeySchemaArgs']], Any]] key_schema: Specifies the attributes that make up the primary key for the table. The attributes in the ``KeySchema`` property must also be defined in the ``AttributeDefinitions`` property.
        :param pulumi.Input[Sequence[pulumi.Input['TableAttributeDefinitionArgs']]] attribute_definitions: A list of attributes that describe the key schema for the table and indexes.
                This property is required to create a DDB table.
                Update requires: [Some interruptions](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-update-behaviors.html#update-some-interrupt). Replacement if you edit an existing AttributeDefinition.
        :param pulumi.Input[builtins.str] billing_mode: Specify how you are charged for read and write throughput and how you manage capacity.
                Valid values include:
                 +  ``PAY_PER_REQUEST`` - We recommend using ``PAY_PER_REQUEST`` for most DynamoDB workloads. ``PAY_PER_REQUEST`` sets the billing mode to [On-demand capacity mode](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/on-demand-capacity-mode.html). 
                 +  ``PROVISIONED`` - We recommend using ``PROVISIONED`` for steady workloads with predictable growth where capacity requirements can be reliably forecasted. ``PROVISIONED`` sets the billing mode to [Provisioned capacity mode](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/provisioned-capacity-mode.html).
                 
                If not specified, the default is ``PROVISIONED``.
        :param pulumi.Input['TableContributorInsightsSpecificationArgs'] contributor_insights_specification: The settings used to enable or disable CloudWatch Contributor Insights for the specified table.
        :param pulumi.Input[builtins.bool] deletion_protection_enabled: Determines if a table is protected from deletion. When enabled, the table cannot be deleted by any user or process. This setting is disabled by default. For more information, see [Using deletion protection](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.Basics.html#WorkingWithTables.Basics.DeletionProtection) in the *Developer Guide*.
        :param pulumi.Input[Sequence[pulumi.Input['TableGlobalSecondaryIndexArgs']]] global_secondary_indexes: Global secondary indexes to be created on the table. You can create up to 20 global secondary indexes.
                 If you update a table to include a new global secondary index, CFNlong initiates the index creation and then proceeds with the stack update. CFNlong doesn't wait for the index to complete creation because the backfilling phase can take a long time, depending on the size of the table. You can't use the index or update the table until the index's status is ``ACTIVE``. You can track its status by using the DynamoDB [DescribeTable](https://docs.aws.amazon.com/cli/latest/reference/dynamodb/describe-table.html) command.
                If you add or delete an index during an update, we recommend that you don't update any other resources. If your stack fails to update and is rolled back while adding a new index, you must manually delete the index. 
                Updates are not supported. The following are exceptions:
                 +  If you update either the contributor insights specification or the provisioned throughput values of global secondary indexes, you can update the table without interruption.
                 +  You can delete or add one global secondary index without interruption. If you do both in the same update (for example, by changing the index's logical ID), the update fails.
        :param pulumi.Input['TableImportSourceSpecificationArgs'] import_source_specification: Specifies the properties of data being imported from the S3 bucket source to the" table.
                 If you specify the ``ImportSourceSpecification`` property, and also specify either the ``StreamSpecification``, the ``TableClass`` property, the ``DeletionProtectionEnabled`` property, or the ``WarmThroughput`` property, the IAM entity creating/updating stack must have ``UpdateTable`` permission.
        :param pulumi.Input['TableKinesisStreamSpecificationArgs'] kinesis_stream_specification: The Kinesis Data Streams configuration for the specified table.
        :param pulumi.Input[Sequence[pulumi.Input['TableLocalSecondaryIndexArgs']]] local_secondary_indexes: Local secondary indexes to be created on the table. You can create up to 5 local secondary indexes. Each index is scoped to a given hash key value. The size of each hash key can be up to 10 gigabytes.
        :param pulumi.Input['TableOnDemandThroughputArgs'] on_demand_throughput: Sets the maximum number of read and write units for the specified on-demand table. If you use this property, you must specify ``MaxReadRequestUnits``, ``MaxWriteRequestUnits``, or both.
        :param pulumi.Input['TablePointInTimeRecoverySpecificationArgs'] point_in_time_recovery_specification: The settings used to enable point in time recovery.
        :param pulumi.Input['TableProvisionedThroughputArgs'] provisioned_throughput: Throughput for the specified table, which consists of values for ``ReadCapacityUnits`` and ``WriteCapacityUnits``. For more information about the contents of a provisioned throughput structure, see [Amazon DynamoDB Table ProvisionedThroughput](https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_ProvisionedThroughput.html). 
                If you set ``BillingMode`` as ``PROVISIONED``, you must specify this property. If you set ``BillingMode`` as ``PAY_PER_REQUEST``, you cannot specify this property.
        :param pulumi.Input['TableResourcePolicyArgs'] resource_policy: A resource-based policy document that contains permissions to add to the specified table. In a CFNshort template, you can provide the policy in JSON or YAML format because CFNshort converts YAML to JSON before submitting it to DDB. For more information about resource-based policies, see [Using resource-based policies for](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/access-control-resource-based.html) and [Resource-based policy examples](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/rbac-examples.html).
                When you attach a resource-based policy while creating a table, the policy creation is *strongly consistent*. For information about the considerations that you should keep in mind while attaching a resource-based policy, see [Resource-based policy considerations](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/rbac-considerations.html).
        :param pulumi.Input['TableSseSpecificationArgs'] sse_specification: Specifies the settings to enable server-side encryption.
        :param pulumi.Input['TableStreamSpecificationArgs'] stream_specification: The settings for the DDB table stream, which capture changes to items stored in the table.
        :param pulumi.Input[builtins.str] table_class: The table class of the new table. Valid values are ``STANDARD`` and ``STANDARD_INFREQUENT_ACCESS``.
        :param pulumi.Input[builtins.str] table_name: A name for the table. If you don't specify a name, CFNlong generates a unique physical ID and uses that ID for the table name. For more information, see [Name Type](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-name.html).
                 If you specify a name, you cannot perform updates that require replacement of this resource. You can perform updates that require no or some interruption. If you must replace the resource, specify a new name.
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: An array of key-value pairs to apply to this resource.
                For more information, see [Tag](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html).
        :param pulumi.Input['TableTimeToLiveSpecificationArgs'] time_to_live_specification: Specifies the Time to Live (TTL) settings for the table.
                 For detailed information about the limits in DynamoDB, see [Limits in Amazon DynamoDB](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html) in the Amazon DynamoDB Developer Guide.
        :param pulumi.Input['TableWarmThroughputArgs'] warm_throughput: Represents the warm throughput (in read units per second and write units per second) for creating a table.
        """
        pulumi.set(__self__, "key_schema", key_schema)
        if attribute_definitions is not None:
            pulumi.set(__self__, "attribute_definitions", attribute_definitions)
        if billing_mode is not None:
            pulumi.set(__self__, "billing_mode", billing_mode)
        if contributor_insights_specification is not None:
            pulumi.set(__self__, "contributor_insights_specification", contributor_insights_specification)
        if deletion_protection_enabled is not None:
            pulumi.set(__self__, "deletion_protection_enabled", deletion_protection_enabled)
        if global_secondary_indexes is not None:
            pulumi.set(__self__, "global_secondary_indexes", global_secondary_indexes)
        if import_source_specification is not None:
            pulumi.set(__self__, "import_source_specification", import_source_specification)
        if kinesis_stream_specification is not None:
            pulumi.set(__self__, "kinesis_stream_specification", kinesis_stream_specification)
        if local_secondary_indexes is not None:
            pulumi.set(__self__, "local_secondary_indexes", local_secondary_indexes)
        if on_demand_throughput is not None:
            pulumi.set(__self__, "on_demand_throughput", on_demand_throughput)
        if point_in_time_recovery_specification is not None:
            pulumi.set(__self__, "point_in_time_recovery_specification", point_in_time_recovery_specification)
        if provisioned_throughput is not None:
            pulumi.set(__self__, "provisioned_throughput", provisioned_throughput)
        if resource_policy is not None:
            pulumi.set(__self__, "resource_policy", resource_policy)
        if sse_specification is not None:
            pulumi.set(__self__, "sse_specification", sse_specification)
        if stream_specification is not None:
            pulumi.set(__self__, "stream_specification", stream_specification)
        if table_class is not None:
            pulumi.set(__self__, "table_class", table_class)
        if table_name is not None:
            pulumi.set(__self__, "table_name", table_name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if time_to_live_specification is not None:
            pulumi.set(__self__, "time_to_live_specification", time_to_live_specification)
        if warm_throughput is not None:
            pulumi.set(__self__, "warm_throughput", warm_throughput)

    @property
    @pulumi.getter(name="keySchema")
    def key_schema(self) -> pulumi.Input[Union[Sequence[pulumi.Input['TableKeySchemaArgs']], Any]]:
        """
        Specifies the attributes that make up the primary key for the table. The attributes in the ``KeySchema`` property must also be defined in the ``AttributeDefinitions`` property.
        """
        return pulumi.get(self, "key_schema")

    @key_schema.setter
    def key_schema(self, value: pulumi.Input[Union[Sequence[pulumi.Input['TableKeySchemaArgs']], Any]]):
        pulumi.set(self, "key_schema", value)

    @property
    @pulumi.getter(name="attributeDefinitions")
    def attribute_definitions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TableAttributeDefinitionArgs']]]]:
        """
        A list of attributes that describe the key schema for the table and indexes.
         This property is required to create a DDB table.
         Update requires: [Some interruptions](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-update-behaviors.html#update-some-interrupt). Replacement if you edit an existing AttributeDefinition.
        """
        return pulumi.get(self, "attribute_definitions")

    @attribute_definitions.setter
    def attribute_definitions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TableAttributeDefinitionArgs']]]]):
        pulumi.set(self, "attribute_definitions", value)

    @property
    @pulumi.getter(name="billingMode")
    def billing_mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specify how you are charged for read and write throughput and how you manage capacity.
         Valid values include:
          +  ``PAY_PER_REQUEST`` - We recommend using ``PAY_PER_REQUEST`` for most DynamoDB workloads. ``PAY_PER_REQUEST`` sets the billing mode to [On-demand capacity mode](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/on-demand-capacity-mode.html). 
          +  ``PROVISIONED`` - We recommend using ``PROVISIONED`` for steady workloads with predictable growth where capacity requirements can be reliably forecasted. ``PROVISIONED`` sets the billing mode to [Provisioned capacity mode](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/provisioned-capacity-mode.html).
          
         If not specified, the default is ``PROVISIONED``.
        """
        return pulumi.get(self, "billing_mode")

    @billing_mode.setter
    def billing_mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "billing_mode", value)

    @property
    @pulumi.getter(name="contributorInsightsSpecification")
    def contributor_insights_specification(self) -> Optional[pulumi.Input['TableContributorInsightsSpecificationArgs']]:
        """
        The settings used to enable or disable CloudWatch Contributor Insights for the specified table.
        """
        return pulumi.get(self, "contributor_insights_specification")

    @contributor_insights_specification.setter
    def contributor_insights_specification(self, value: Optional[pulumi.Input['TableContributorInsightsSpecificationArgs']]):
        pulumi.set(self, "contributor_insights_specification", value)

    @property
    @pulumi.getter(name="deletionProtectionEnabled")
    def deletion_protection_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Determines if a table is protected from deletion. When enabled, the table cannot be deleted by any user or process. This setting is disabled by default. For more information, see [Using deletion protection](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.Basics.html#WorkingWithTables.Basics.DeletionProtection) in the *Developer Guide*.
        """
        return pulumi.get(self, "deletion_protection_enabled")

    @deletion_protection_enabled.setter
    def deletion_protection_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "deletion_protection_enabled", value)

    @property
    @pulumi.getter(name="globalSecondaryIndexes")
    def global_secondary_indexes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TableGlobalSecondaryIndexArgs']]]]:
        """
        Global secondary indexes to be created on the table. You can create up to 20 global secondary indexes.
          If you update a table to include a new global secondary index, CFNlong initiates the index creation and then proceeds with the stack update. CFNlong doesn't wait for the index to complete creation because the backfilling phase can take a long time, depending on the size of the table. You can't use the index or update the table until the index's status is ``ACTIVE``. You can track its status by using the DynamoDB [DescribeTable](https://docs.aws.amazon.com/cli/latest/reference/dynamodb/describe-table.html) command.
         If you add or delete an index during an update, we recommend that you don't update any other resources. If your stack fails to update and is rolled back while adding a new index, you must manually delete the index. 
         Updates are not supported. The following are exceptions:
          +  If you update either the contributor insights specification or the provisioned throughput values of global secondary indexes, you can update the table without interruption.
          +  You can delete or add one global secondary index without interruption. If you do both in the same update (for example, by changing the index's logical ID), the update fails.
        """
        return pulumi.get(self, "global_secondary_indexes")

    @global_secondary_indexes.setter
    def global_secondary_indexes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TableGlobalSecondaryIndexArgs']]]]):
        pulumi.set(self, "global_secondary_indexes", value)

    @property
    @pulumi.getter(name="importSourceSpecification")
    def import_source_specification(self) -> Optional[pulumi.Input['TableImportSourceSpecificationArgs']]:
        """
        Specifies the properties of data being imported from the S3 bucket source to the" table.
          If you specify the ``ImportSourceSpecification`` property, and also specify either the ``StreamSpecification``, the ``TableClass`` property, the ``DeletionProtectionEnabled`` property, or the ``WarmThroughput`` property, the IAM entity creating/updating stack must have ``UpdateTable`` permission.
        """
        return pulumi.get(self, "import_source_specification")

    @import_source_specification.setter
    def import_source_specification(self, value: Optional[pulumi.Input['TableImportSourceSpecificationArgs']]):
        pulumi.set(self, "import_source_specification", value)

    @property
    @pulumi.getter(name="kinesisStreamSpecification")
    def kinesis_stream_specification(self) -> Optional[pulumi.Input['TableKinesisStreamSpecificationArgs']]:
        """
        The Kinesis Data Streams configuration for the specified table.
        """
        return pulumi.get(self, "kinesis_stream_specification")

    @kinesis_stream_specification.setter
    def kinesis_stream_specification(self, value: Optional[pulumi.Input['TableKinesisStreamSpecificationArgs']]):
        pulumi.set(self, "kinesis_stream_specification", value)

    @property
    @pulumi.getter(name="localSecondaryIndexes")
    def local_secondary_indexes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TableLocalSecondaryIndexArgs']]]]:
        """
        Local secondary indexes to be created on the table. You can create up to 5 local secondary indexes. Each index is scoped to a given hash key value. The size of each hash key can be up to 10 gigabytes.
        """
        return pulumi.get(self, "local_secondary_indexes")

    @local_secondary_indexes.setter
    def local_secondary_indexes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TableLocalSecondaryIndexArgs']]]]):
        pulumi.set(self, "local_secondary_indexes", value)

    @property
    @pulumi.getter(name="onDemandThroughput")
    def on_demand_throughput(self) -> Optional[pulumi.Input['TableOnDemandThroughputArgs']]:
        """
        Sets the maximum number of read and write units for the specified on-demand table. If you use this property, you must specify ``MaxReadRequestUnits``, ``MaxWriteRequestUnits``, or both.
        """
        return pulumi.get(self, "on_demand_throughput")

    @on_demand_throughput.setter
    def on_demand_throughput(self, value: Optional[pulumi.Input['TableOnDemandThroughputArgs']]):
        pulumi.set(self, "on_demand_throughput", value)

    @property
    @pulumi.getter(name="pointInTimeRecoverySpecification")
    def point_in_time_recovery_specification(self) -> Optional[pulumi.Input['TablePointInTimeRecoverySpecificationArgs']]:
        """
        The settings used to enable point in time recovery.
        """
        return pulumi.get(self, "point_in_time_recovery_specification")

    @point_in_time_recovery_specification.setter
    def point_in_time_recovery_specification(self, value: Optional[pulumi.Input['TablePointInTimeRecoverySpecificationArgs']]):
        pulumi.set(self, "point_in_time_recovery_specification", value)

    @property
    @pulumi.getter(name="provisionedThroughput")
    def provisioned_throughput(self) -> Optional[pulumi.Input['TableProvisionedThroughputArgs']]:
        """
        Throughput for the specified table, which consists of values for ``ReadCapacityUnits`` and ``WriteCapacityUnits``. For more information about the contents of a provisioned throughput structure, see [Amazon DynamoDB Table ProvisionedThroughput](https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_ProvisionedThroughput.html). 
         If you set ``BillingMode`` as ``PROVISIONED``, you must specify this property. If you set ``BillingMode`` as ``PAY_PER_REQUEST``, you cannot specify this property.
        """
        return pulumi.get(self, "provisioned_throughput")

    @provisioned_throughput.setter
    def provisioned_throughput(self, value: Optional[pulumi.Input['TableProvisionedThroughputArgs']]):
        pulumi.set(self, "provisioned_throughput", value)

    @property
    @pulumi.getter(name="resourcePolicy")
    def resource_policy(self) -> Optional[pulumi.Input['TableResourcePolicyArgs']]:
        """
        A resource-based policy document that contains permissions to add to the specified table. In a CFNshort template, you can provide the policy in JSON or YAML format because CFNshort converts YAML to JSON before submitting it to DDB. For more information about resource-based policies, see [Using resource-based policies for](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/access-control-resource-based.html) and [Resource-based policy examples](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/rbac-examples.html).
         When you attach a resource-based policy while creating a table, the policy creation is *strongly consistent*. For information about the considerations that you should keep in mind while attaching a resource-based policy, see [Resource-based policy considerations](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/rbac-considerations.html).
        """
        return pulumi.get(self, "resource_policy")

    @resource_policy.setter
    def resource_policy(self, value: Optional[pulumi.Input['TableResourcePolicyArgs']]):
        pulumi.set(self, "resource_policy", value)

    @property
    @pulumi.getter(name="sseSpecification")
    def sse_specification(self) -> Optional[pulumi.Input['TableSseSpecificationArgs']]:
        """
        Specifies the settings to enable server-side encryption.
        """
        return pulumi.get(self, "sse_specification")

    @sse_specification.setter
    def sse_specification(self, value: Optional[pulumi.Input['TableSseSpecificationArgs']]):
        pulumi.set(self, "sse_specification", value)

    @property
    @pulumi.getter(name="streamSpecification")
    def stream_specification(self) -> Optional[pulumi.Input['TableStreamSpecificationArgs']]:
        """
        The settings for the DDB table stream, which capture changes to items stored in the table.
        """
        return pulumi.get(self, "stream_specification")

    @stream_specification.setter
    def stream_specification(self, value: Optional[pulumi.Input['TableStreamSpecificationArgs']]):
        pulumi.set(self, "stream_specification", value)

    @property
    @pulumi.getter(name="tableClass")
    def table_class(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The table class of the new table. Valid values are ``STANDARD`` and ``STANDARD_INFREQUENT_ACCESS``.
        """
        return pulumi.get(self, "table_class")

    @table_class.setter
    def table_class(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "table_class", value)

    @property
    @pulumi.getter(name="tableName")
    def table_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A name for the table. If you don't specify a name, CFNlong generates a unique physical ID and uses that ID for the table name. For more information, see [Name Type](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-name.html).
          If you specify a name, you cannot perform updates that require replacement of this resource. You can perform updates that require no or some interruption. If you must replace the resource, specify a new name.
        """
        return pulumi.get(self, "table_name")

    @table_name.setter
    def table_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "table_name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        An array of key-value pairs to apply to this resource.
         For more information, see [Tag](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html).
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="timeToLiveSpecification")
    def time_to_live_specification(self) -> Optional[pulumi.Input['TableTimeToLiveSpecificationArgs']]:
        """
        Specifies the Time to Live (TTL) settings for the table.
          For detailed information about the limits in DynamoDB, see [Limits in Amazon DynamoDB](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html) in the Amazon DynamoDB Developer Guide.
        """
        return pulumi.get(self, "time_to_live_specification")

    @time_to_live_specification.setter
    def time_to_live_specification(self, value: Optional[pulumi.Input['TableTimeToLiveSpecificationArgs']]):
        pulumi.set(self, "time_to_live_specification", value)

    @property
    @pulumi.getter(name="warmThroughput")
    def warm_throughput(self) -> Optional[pulumi.Input['TableWarmThroughputArgs']]:
        """
        Represents the warm throughput (in read units per second and write units per second) for creating a table.
        """
        return pulumi.get(self, "warm_throughput")

    @warm_throughput.setter
    def warm_throughput(self, value: Optional[pulumi.Input['TableWarmThroughputArgs']]):
        pulumi.set(self, "warm_throughput", value)


@pulumi.type_token("aws-native:dynamodb:Table")
class Table(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 attribute_definitions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TableAttributeDefinitionArgs', 'TableAttributeDefinitionArgsDict']]]]] = None,
                 billing_mode: Optional[pulumi.Input[builtins.str]] = None,
                 contributor_insights_specification: Optional[pulumi.Input[Union['TableContributorInsightsSpecificationArgs', 'TableContributorInsightsSpecificationArgsDict']]] = None,
                 deletion_protection_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 global_secondary_indexes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TableGlobalSecondaryIndexArgs', 'TableGlobalSecondaryIndexArgsDict']]]]] = None,
                 import_source_specification: Optional[pulumi.Input[Union['TableImportSourceSpecificationArgs', 'TableImportSourceSpecificationArgsDict']]] = None,
                 key_schema: Optional[pulumi.Input[Union[Sequence[pulumi.Input[Union['TableKeySchemaArgs', 'TableKeySchemaArgsDict']]], Any]]] = None,
                 kinesis_stream_specification: Optional[pulumi.Input[Union['TableKinesisStreamSpecificationArgs', 'TableKinesisStreamSpecificationArgsDict']]] = None,
                 local_secondary_indexes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TableLocalSecondaryIndexArgs', 'TableLocalSecondaryIndexArgsDict']]]]] = None,
                 on_demand_throughput: Optional[pulumi.Input[Union['TableOnDemandThroughputArgs', 'TableOnDemandThroughputArgsDict']]] = None,
                 point_in_time_recovery_specification: Optional[pulumi.Input[Union['TablePointInTimeRecoverySpecificationArgs', 'TablePointInTimeRecoverySpecificationArgsDict']]] = None,
                 provisioned_throughput: Optional[pulumi.Input[Union['TableProvisionedThroughputArgs', 'TableProvisionedThroughputArgsDict']]] = None,
                 resource_policy: Optional[pulumi.Input[Union['TableResourcePolicyArgs', 'TableResourcePolicyArgsDict']]] = None,
                 sse_specification: Optional[pulumi.Input[Union['TableSseSpecificationArgs', 'TableSseSpecificationArgsDict']]] = None,
                 stream_specification: Optional[pulumi.Input[Union['TableStreamSpecificationArgs', 'TableStreamSpecificationArgsDict']]] = None,
                 table_class: Optional[pulumi.Input[builtins.str]] = None,
                 table_name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 time_to_live_specification: Optional[pulumi.Input[Union['TableTimeToLiveSpecificationArgs', 'TableTimeToLiveSpecificationArgsDict']]] = None,
                 warm_throughput: Optional[pulumi.Input[Union['TableWarmThroughputArgs', 'TableWarmThroughputArgsDict']]] = None,
                 __props__=None):
        """
        The ``AWS::DynamoDB::Table`` resource creates a DDB table. For more information, see [CreateTable](https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_CreateTable.html) in the *API Reference*.
         You should be aware of the following behaviors when working with DDB tables:
          +  CFNlong typically creates DDB tables in parallel. However, if your template includes multiple DDB tables with indexes, you must declare dependencies so that the tables are created sequentially. DDBlong limits the number of tables with secondary indexes that are in the creating state. If you create multiple tables with indexes at the same time, DDB returns an error and the stack operation fails. For an example, see [DynamoDB Table with a DependsOn Attribute](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#aws-resource-dynamodb-table--examples--DynamoDB_Table_with_a_DependsOn_Attribute).

           Our guidance is to use the latest schema documented for your CFNlong templates. This schema supports the provisioning of all table settings below. When using this schema in your CFNlong templates, please ensure that your Identity and Access Management (IAM) policies are updated with appropriate permissions to allow for the authorization of these setting changes.

        ## Example Usage
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        my_dynamo_db_table = aws_native.dynamodb.Table("myDynamoDBTable",
            attribute_definitions=[
                {
                    "attribute_name": "Album",
                    "attribute_type": "S",
                },
                {
                    "attribute_name": "Artist",
                    "attribute_type": "S",
                },
                {
                    "attribute_name": "Sales",
                    "attribute_type": "N",
                },
                {
                    "attribute_name": "NumberOfSongs",
                    "attribute_type": "N",
                },
            ],
            key_schema=[
                {
                    "attributeName": "Album",
                    "keyType": "HASH",
                },
                {
                    "attributeName": "Artist",
                    "keyType": "RANGE",
                },
            ],
            provisioned_throughput={
                "read_capacity_units": 5,
                "write_capacity_units": 5,
            },
            table_name="myTableName",
            global_secondary_indexes=[
                {
                    "index_name": "myGSI",
                    "key_schema": [
                        {
                            "attribute_name": "Sales",
                            "key_type": "HASH",
                        },
                        {
                            "attribute_name": "Artist",
                            "key_type": "RANGE",
                        },
                    ],
                    "projection": {
                        "non_key_attributes": [
                            "Album",
                            "NumberOfSongs",
                        ],
                        "projection_type": "INCLUDE",
                    },
                    "provisioned_throughput": {
                        "read_capacity_units": 5,
                        "write_capacity_units": 5,
                    },
                },
                {
                    "index_name": "myGSI2",
                    "key_schema": [
                        {
                            "attribute_name": "NumberOfSongs",
                            "key_type": "HASH",
                        },
                        {
                            "attribute_name": "Sales",
                            "key_type": "RANGE",
                        },
                    ],
                    "projection": {
                        "non_key_attributes": [
                            "Album",
                            "Artist",
                        ],
                        "projection_type": "INCLUDE",
                    },
                    "provisioned_throughput": {
                        "read_capacity_units": 5,
                        "write_capacity_units": 5,
                    },
                },
            ],
            local_secondary_indexes=[{
                "index_name": "myLSI",
                "key_schema": [
                    {
                        "attribute_name": "Album",
                        "key_type": "HASH",
                    },
                    {
                        "attribute_name": "Sales",
                        "key_type": "RANGE",
                    },
                ],
                "projection": {
                    "non_key_attributes": [
                        "Artist",
                        "NumberOfSongs",
                    ],
                    "projection_type": "INCLUDE",
                },
            }])

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        my_dynamo_db_table = aws_native.dynamodb.Table("myDynamoDBTable",
            attribute_definitions=[
                {
                    "attribute_name": "Album",
                    "attribute_type": "S",
                },
                {
                    "attribute_name": "Artist",
                    "attribute_type": "S",
                },
                {
                    "attribute_name": "Sales",
                    "attribute_type": "N",
                },
                {
                    "attribute_name": "NumberOfSongs",
                    "attribute_type": "N",
                },
            ],
            key_schema=[
                {
                    "attributeName": "Album",
                    "keyType": "HASH",
                },
                {
                    "attributeName": "Artist",
                    "keyType": "RANGE",
                },
            ],
            provisioned_throughput={
                "read_capacity_units": 5,
                "write_capacity_units": 5,
            },
            table_name="myTableName",
            global_secondary_indexes=[
                {
                    "index_name": "myGSI",
                    "key_schema": [
                        {
                            "attribute_name": "Sales",
                            "key_type": "HASH",
                        },
                        {
                            "attribute_name": "Artist",
                            "key_type": "RANGE",
                        },
                    ],
                    "projection": {
                        "non_key_attributes": [
                            "Album",
                            "NumberOfSongs",
                        ],
                        "projection_type": "INCLUDE",
                    },
                    "provisioned_throughput": {
                        "read_capacity_units": 5,
                        "write_capacity_units": 5,
                    },
                },
                {
                    "index_name": "myGSI2",
                    "key_schema": [
                        {
                            "attribute_name": "NumberOfSongs",
                            "key_type": "HASH",
                        },
                        {
                            "attribute_name": "Sales",
                            "key_type": "RANGE",
                        },
                    ],
                    "projection": {
                        "non_key_attributes": [
                            "Album",
                            "Artist",
                        ],
                        "projection_type": "INCLUDE",
                    },
                    "provisioned_throughput": {
                        "read_capacity_units": 5,
                        "write_capacity_units": 5,
                    },
                },
            ],
            local_secondary_indexes=[{
                "index_name": "myLSI",
                "key_schema": [
                    {
                        "attribute_name": "Album",
                        "key_type": "HASH",
                    },
                    {
                        "attribute_name": "Sales",
                        "key_type": "RANGE",
                    },
                ],
                "projection": {
                    "non_key_attributes": [
                        "Artist",
                        "NumberOfSongs",
                    ],
                    "projection_type": "INCLUDE",
                },
            }])

        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['TableAttributeDefinitionArgs', 'TableAttributeDefinitionArgsDict']]]] attribute_definitions: A list of attributes that describe the key schema for the table and indexes.
                This property is required to create a DDB table.
                Update requires: [Some interruptions](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-update-behaviors.html#update-some-interrupt). Replacement if you edit an existing AttributeDefinition.
        :param pulumi.Input[builtins.str] billing_mode: Specify how you are charged for read and write throughput and how you manage capacity.
                Valid values include:
                 +  ``PAY_PER_REQUEST`` - We recommend using ``PAY_PER_REQUEST`` for most DynamoDB workloads. ``PAY_PER_REQUEST`` sets the billing mode to [On-demand capacity mode](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/on-demand-capacity-mode.html). 
                 +  ``PROVISIONED`` - We recommend using ``PROVISIONED`` for steady workloads with predictable growth where capacity requirements can be reliably forecasted. ``PROVISIONED`` sets the billing mode to [Provisioned capacity mode](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/provisioned-capacity-mode.html).
                 
                If not specified, the default is ``PROVISIONED``.
        :param pulumi.Input[Union['TableContributorInsightsSpecificationArgs', 'TableContributorInsightsSpecificationArgsDict']] contributor_insights_specification: The settings used to enable or disable CloudWatch Contributor Insights for the specified table.
        :param pulumi.Input[builtins.bool] deletion_protection_enabled: Determines if a table is protected from deletion. When enabled, the table cannot be deleted by any user or process. This setting is disabled by default. For more information, see [Using deletion protection](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.Basics.html#WorkingWithTables.Basics.DeletionProtection) in the *Developer Guide*.
        :param pulumi.Input[Sequence[pulumi.Input[Union['TableGlobalSecondaryIndexArgs', 'TableGlobalSecondaryIndexArgsDict']]]] global_secondary_indexes: Global secondary indexes to be created on the table. You can create up to 20 global secondary indexes.
                 If you update a table to include a new global secondary index, CFNlong initiates the index creation and then proceeds with the stack update. CFNlong doesn't wait for the index to complete creation because the backfilling phase can take a long time, depending on the size of the table. You can't use the index or update the table until the index's status is ``ACTIVE``. You can track its status by using the DynamoDB [DescribeTable](https://docs.aws.amazon.com/cli/latest/reference/dynamodb/describe-table.html) command.
                If you add or delete an index during an update, we recommend that you don't update any other resources. If your stack fails to update and is rolled back while adding a new index, you must manually delete the index. 
                Updates are not supported. The following are exceptions:
                 +  If you update either the contributor insights specification or the provisioned throughput values of global secondary indexes, you can update the table without interruption.
                 +  You can delete or add one global secondary index without interruption. If you do both in the same update (for example, by changing the index's logical ID), the update fails.
        :param pulumi.Input[Union['TableImportSourceSpecificationArgs', 'TableImportSourceSpecificationArgsDict']] import_source_specification: Specifies the properties of data being imported from the S3 bucket source to the" table.
                 If you specify the ``ImportSourceSpecification`` property, and also specify either the ``StreamSpecification``, the ``TableClass`` property, the ``DeletionProtectionEnabled`` property, or the ``WarmThroughput`` property, the IAM entity creating/updating stack must have ``UpdateTable`` permission.
        :param pulumi.Input[Union[Sequence[pulumi.Input[Union['TableKeySchemaArgs', 'TableKeySchemaArgsDict']]], Any]] key_schema: Specifies the attributes that make up the primary key for the table. The attributes in the ``KeySchema`` property must also be defined in the ``AttributeDefinitions`` property.
        :param pulumi.Input[Union['TableKinesisStreamSpecificationArgs', 'TableKinesisStreamSpecificationArgsDict']] kinesis_stream_specification: The Kinesis Data Streams configuration for the specified table.
        :param pulumi.Input[Sequence[pulumi.Input[Union['TableLocalSecondaryIndexArgs', 'TableLocalSecondaryIndexArgsDict']]]] local_secondary_indexes: Local secondary indexes to be created on the table. You can create up to 5 local secondary indexes. Each index is scoped to a given hash key value. The size of each hash key can be up to 10 gigabytes.
        :param pulumi.Input[Union['TableOnDemandThroughputArgs', 'TableOnDemandThroughputArgsDict']] on_demand_throughput: Sets the maximum number of read and write units for the specified on-demand table. If you use this property, you must specify ``MaxReadRequestUnits``, ``MaxWriteRequestUnits``, or both.
        :param pulumi.Input[Union['TablePointInTimeRecoverySpecificationArgs', 'TablePointInTimeRecoverySpecificationArgsDict']] point_in_time_recovery_specification: The settings used to enable point in time recovery.
        :param pulumi.Input[Union['TableProvisionedThroughputArgs', 'TableProvisionedThroughputArgsDict']] provisioned_throughput: Throughput for the specified table, which consists of values for ``ReadCapacityUnits`` and ``WriteCapacityUnits``. For more information about the contents of a provisioned throughput structure, see [Amazon DynamoDB Table ProvisionedThroughput](https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_ProvisionedThroughput.html). 
                If you set ``BillingMode`` as ``PROVISIONED``, you must specify this property. If you set ``BillingMode`` as ``PAY_PER_REQUEST``, you cannot specify this property.
        :param pulumi.Input[Union['TableResourcePolicyArgs', 'TableResourcePolicyArgsDict']] resource_policy: A resource-based policy document that contains permissions to add to the specified table. In a CFNshort template, you can provide the policy in JSON or YAML format because CFNshort converts YAML to JSON before submitting it to DDB. For more information about resource-based policies, see [Using resource-based policies for](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/access-control-resource-based.html) and [Resource-based policy examples](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/rbac-examples.html).
                When you attach a resource-based policy while creating a table, the policy creation is *strongly consistent*. For information about the considerations that you should keep in mind while attaching a resource-based policy, see [Resource-based policy considerations](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/rbac-considerations.html).
        :param pulumi.Input[Union['TableSseSpecificationArgs', 'TableSseSpecificationArgsDict']] sse_specification: Specifies the settings to enable server-side encryption.
        :param pulumi.Input[Union['TableStreamSpecificationArgs', 'TableStreamSpecificationArgsDict']] stream_specification: The settings for the DDB table stream, which capture changes to items stored in the table.
        :param pulumi.Input[builtins.str] table_class: The table class of the new table. Valid values are ``STANDARD`` and ``STANDARD_INFREQUENT_ACCESS``.
        :param pulumi.Input[builtins.str] table_name: A name for the table. If you don't specify a name, CFNlong generates a unique physical ID and uses that ID for the table name. For more information, see [Name Type](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-name.html).
                 If you specify a name, you cannot perform updates that require replacement of this resource. You can perform updates that require no or some interruption. If you must replace the resource, specify a new name.
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: An array of key-value pairs to apply to this resource.
                For more information, see [Tag](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html).
        :param pulumi.Input[Union['TableTimeToLiveSpecificationArgs', 'TableTimeToLiveSpecificationArgsDict']] time_to_live_specification: Specifies the Time to Live (TTL) settings for the table.
                 For detailed information about the limits in DynamoDB, see [Limits in Amazon DynamoDB](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html) in the Amazon DynamoDB Developer Guide.
        :param pulumi.Input[Union['TableWarmThroughputArgs', 'TableWarmThroughputArgsDict']] warm_throughput: Represents the warm throughput (in read units per second and write units per second) for creating a table.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TableArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The ``AWS::DynamoDB::Table`` resource creates a DDB table. For more information, see [CreateTable](https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_CreateTable.html) in the *API Reference*.
         You should be aware of the following behaviors when working with DDB tables:
          +  CFNlong typically creates DDB tables in parallel. However, if your template includes multiple DDB tables with indexes, you must declare dependencies so that the tables are created sequentially. DDBlong limits the number of tables with secondary indexes that are in the creating state. If you create multiple tables with indexes at the same time, DDB returns an error and the stack operation fails. For an example, see [DynamoDB Table with a DependsOn Attribute](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#aws-resource-dynamodb-table--examples--DynamoDB_Table_with_a_DependsOn_Attribute).

           Our guidance is to use the latest schema documented for your CFNlong templates. This schema supports the provisioning of all table settings below. When using this schema in your CFNlong templates, please ensure that your Identity and Access Management (IAM) policies are updated with appropriate permissions to allow for the authorization of these setting changes.

        ## Example Usage
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        my_dynamo_db_table = aws_native.dynamodb.Table("myDynamoDBTable",
            attribute_definitions=[
                {
                    "attribute_name": "Album",
                    "attribute_type": "S",
                },
                {
                    "attribute_name": "Artist",
                    "attribute_type": "S",
                },
                {
                    "attribute_name": "Sales",
                    "attribute_type": "N",
                },
                {
                    "attribute_name": "NumberOfSongs",
                    "attribute_type": "N",
                },
            ],
            key_schema=[
                {
                    "attributeName": "Album",
                    "keyType": "HASH",
                },
                {
                    "attributeName": "Artist",
                    "keyType": "RANGE",
                },
            ],
            provisioned_throughput={
                "read_capacity_units": 5,
                "write_capacity_units": 5,
            },
            table_name="myTableName",
            global_secondary_indexes=[
                {
                    "index_name": "myGSI",
                    "key_schema": [
                        {
                            "attribute_name": "Sales",
                            "key_type": "HASH",
                        },
                        {
                            "attribute_name": "Artist",
                            "key_type": "RANGE",
                        },
                    ],
                    "projection": {
                        "non_key_attributes": [
                            "Album",
                            "NumberOfSongs",
                        ],
                        "projection_type": "INCLUDE",
                    },
                    "provisioned_throughput": {
                        "read_capacity_units": 5,
                        "write_capacity_units": 5,
                    },
                },
                {
                    "index_name": "myGSI2",
                    "key_schema": [
                        {
                            "attribute_name": "NumberOfSongs",
                            "key_type": "HASH",
                        },
                        {
                            "attribute_name": "Sales",
                            "key_type": "RANGE",
                        },
                    ],
                    "projection": {
                        "non_key_attributes": [
                            "Album",
                            "Artist",
                        ],
                        "projection_type": "INCLUDE",
                    },
                    "provisioned_throughput": {
                        "read_capacity_units": 5,
                        "write_capacity_units": 5,
                    },
                },
            ],
            local_secondary_indexes=[{
                "index_name": "myLSI",
                "key_schema": [
                    {
                        "attribute_name": "Album",
                        "key_type": "HASH",
                    },
                    {
                        "attribute_name": "Sales",
                        "key_type": "RANGE",
                    },
                ],
                "projection": {
                    "non_key_attributes": [
                        "Artist",
                        "NumberOfSongs",
                    ],
                    "projection_type": "INCLUDE",
                },
            }])

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        my_dynamo_db_table = aws_native.dynamodb.Table("myDynamoDBTable",
            attribute_definitions=[
                {
                    "attribute_name": "Album",
                    "attribute_type": "S",
                },
                {
                    "attribute_name": "Artist",
                    "attribute_type": "S",
                },
                {
                    "attribute_name": "Sales",
                    "attribute_type": "N",
                },
                {
                    "attribute_name": "NumberOfSongs",
                    "attribute_type": "N",
                },
            ],
            key_schema=[
                {
                    "attributeName": "Album",
                    "keyType": "HASH",
                },
                {
                    "attributeName": "Artist",
                    "keyType": "RANGE",
                },
            ],
            provisioned_throughput={
                "read_capacity_units": 5,
                "write_capacity_units": 5,
            },
            table_name="myTableName",
            global_secondary_indexes=[
                {
                    "index_name": "myGSI",
                    "key_schema": [
                        {
                            "attribute_name": "Sales",
                            "key_type": "HASH",
                        },
                        {
                            "attribute_name": "Artist",
                            "key_type": "RANGE",
                        },
                    ],
                    "projection": {
                        "non_key_attributes": [
                            "Album",
                            "NumberOfSongs",
                        ],
                        "projection_type": "INCLUDE",
                    },
                    "provisioned_throughput": {
                        "read_capacity_units": 5,
                        "write_capacity_units": 5,
                    },
                },
                {
                    "index_name": "myGSI2",
                    "key_schema": [
                        {
                            "attribute_name": "NumberOfSongs",
                            "key_type": "HASH",
                        },
                        {
                            "attribute_name": "Sales",
                            "key_type": "RANGE",
                        },
                    ],
                    "projection": {
                        "non_key_attributes": [
                            "Album",
                            "Artist",
                        ],
                        "projection_type": "INCLUDE",
                    },
                    "provisioned_throughput": {
                        "read_capacity_units": 5,
                        "write_capacity_units": 5,
                    },
                },
            ],
            local_secondary_indexes=[{
                "index_name": "myLSI",
                "key_schema": [
                    {
                        "attribute_name": "Album",
                        "key_type": "HASH",
                    },
                    {
                        "attribute_name": "Sales",
                        "key_type": "RANGE",
                    },
                ],
                "projection": {
                    "non_key_attributes": [
                        "Artist",
                        "NumberOfSongs",
                    ],
                    "projection_type": "INCLUDE",
                },
            }])

        ```

        :param str resource_name: The name of the resource.
        :param TableArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TableArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 attribute_definitions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TableAttributeDefinitionArgs', 'TableAttributeDefinitionArgsDict']]]]] = None,
                 billing_mode: Optional[pulumi.Input[builtins.str]] = None,
                 contributor_insights_specification: Optional[pulumi.Input[Union['TableContributorInsightsSpecificationArgs', 'TableContributorInsightsSpecificationArgsDict']]] = None,
                 deletion_protection_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 global_secondary_indexes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TableGlobalSecondaryIndexArgs', 'TableGlobalSecondaryIndexArgsDict']]]]] = None,
                 import_source_specification: Optional[pulumi.Input[Union['TableImportSourceSpecificationArgs', 'TableImportSourceSpecificationArgsDict']]] = None,
                 key_schema: Optional[pulumi.Input[Union[Sequence[pulumi.Input[Union['TableKeySchemaArgs', 'TableKeySchemaArgsDict']]], Any]]] = None,
                 kinesis_stream_specification: Optional[pulumi.Input[Union['TableKinesisStreamSpecificationArgs', 'TableKinesisStreamSpecificationArgsDict']]] = None,
                 local_secondary_indexes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TableLocalSecondaryIndexArgs', 'TableLocalSecondaryIndexArgsDict']]]]] = None,
                 on_demand_throughput: Optional[pulumi.Input[Union['TableOnDemandThroughputArgs', 'TableOnDemandThroughputArgsDict']]] = None,
                 point_in_time_recovery_specification: Optional[pulumi.Input[Union['TablePointInTimeRecoverySpecificationArgs', 'TablePointInTimeRecoverySpecificationArgsDict']]] = None,
                 provisioned_throughput: Optional[pulumi.Input[Union['TableProvisionedThroughputArgs', 'TableProvisionedThroughputArgsDict']]] = None,
                 resource_policy: Optional[pulumi.Input[Union['TableResourcePolicyArgs', 'TableResourcePolicyArgsDict']]] = None,
                 sse_specification: Optional[pulumi.Input[Union['TableSseSpecificationArgs', 'TableSseSpecificationArgsDict']]] = None,
                 stream_specification: Optional[pulumi.Input[Union['TableStreamSpecificationArgs', 'TableStreamSpecificationArgsDict']]] = None,
                 table_class: Optional[pulumi.Input[builtins.str]] = None,
                 table_name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 time_to_live_specification: Optional[pulumi.Input[Union['TableTimeToLiveSpecificationArgs', 'TableTimeToLiveSpecificationArgsDict']]] = None,
                 warm_throughput: Optional[pulumi.Input[Union['TableWarmThroughputArgs', 'TableWarmThroughputArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TableArgs.__new__(TableArgs)

            __props__.__dict__["attribute_definitions"] = attribute_definitions
            __props__.__dict__["billing_mode"] = billing_mode
            __props__.__dict__["contributor_insights_specification"] = contributor_insights_specification
            __props__.__dict__["deletion_protection_enabled"] = deletion_protection_enabled
            __props__.__dict__["global_secondary_indexes"] = global_secondary_indexes
            __props__.__dict__["import_source_specification"] = import_source_specification
            if key_schema is None and not opts.urn:
                raise TypeError("Missing required property 'key_schema'")
            __props__.__dict__["key_schema"] = key_schema
            __props__.__dict__["kinesis_stream_specification"] = kinesis_stream_specification
            __props__.__dict__["local_secondary_indexes"] = local_secondary_indexes
            __props__.__dict__["on_demand_throughput"] = on_demand_throughput
            __props__.__dict__["point_in_time_recovery_specification"] = point_in_time_recovery_specification
            __props__.__dict__["provisioned_throughput"] = provisioned_throughput
            __props__.__dict__["resource_policy"] = resource_policy
            __props__.__dict__["sse_specification"] = sse_specification
            __props__.__dict__["stream_specification"] = stream_specification
            __props__.__dict__["table_class"] = table_class
            __props__.__dict__["table_name"] = table_name
            __props__.__dict__["tags"] = tags
            __props__.__dict__["time_to_live_specification"] = time_to_live_specification
            __props__.__dict__["warm_throughput"] = warm_throughput
            __props__.__dict__["arn"] = None
            __props__.__dict__["stream_arn"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["importSourceSpecification", "tableName"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(Table, __self__).__init__(
            'aws-native:dynamodb:Table',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Table':
        """
        Get an existing Table resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = TableArgs.__new__(TableArgs)

        __props__.__dict__["arn"] = None
        __props__.__dict__["attribute_definitions"] = None
        __props__.__dict__["billing_mode"] = None
        __props__.__dict__["contributor_insights_specification"] = None
        __props__.__dict__["deletion_protection_enabled"] = None
        __props__.__dict__["global_secondary_indexes"] = None
        __props__.__dict__["import_source_specification"] = None
        __props__.__dict__["key_schema"] = None
        __props__.__dict__["kinesis_stream_specification"] = None
        __props__.__dict__["local_secondary_indexes"] = None
        __props__.__dict__["on_demand_throughput"] = None
        __props__.__dict__["point_in_time_recovery_specification"] = None
        __props__.__dict__["provisioned_throughput"] = None
        __props__.__dict__["resource_policy"] = None
        __props__.__dict__["sse_specification"] = None
        __props__.__dict__["stream_arn"] = None
        __props__.__dict__["stream_specification"] = None
        __props__.__dict__["table_class"] = None
        __props__.__dict__["table_name"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["time_to_live_specification"] = None
        __props__.__dict__["warm_throughput"] = None
        return Table(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the DynamoDB table, such as `arn:aws:dynamodb:us-east-2:123456789012:table/myDynamoDBTable` .
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="attributeDefinitions")
    def attribute_definitions(self) -> pulumi.Output[Optional[Sequence['outputs.TableAttributeDefinition']]]:
        """
        A list of attributes that describe the key schema for the table and indexes.
         This property is required to create a DDB table.
         Update requires: [Some interruptions](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-update-behaviors.html#update-some-interrupt). Replacement if you edit an existing AttributeDefinition.
        """
        return pulumi.get(self, "attribute_definitions")

    @property
    @pulumi.getter(name="billingMode")
    def billing_mode(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Specify how you are charged for read and write throughput and how you manage capacity.
         Valid values include:
          +  ``PAY_PER_REQUEST`` - We recommend using ``PAY_PER_REQUEST`` for most DynamoDB workloads. ``PAY_PER_REQUEST`` sets the billing mode to [On-demand capacity mode](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/on-demand-capacity-mode.html). 
          +  ``PROVISIONED`` - We recommend using ``PROVISIONED`` for steady workloads with predictable growth where capacity requirements can be reliably forecasted. ``PROVISIONED`` sets the billing mode to [Provisioned capacity mode](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/provisioned-capacity-mode.html).
          
         If not specified, the default is ``PROVISIONED``.
        """
        return pulumi.get(self, "billing_mode")

    @property
    @pulumi.getter(name="contributorInsightsSpecification")
    def contributor_insights_specification(self) -> pulumi.Output[Optional['outputs.TableContributorInsightsSpecification']]:
        """
        The settings used to enable or disable CloudWatch Contributor Insights for the specified table.
        """
        return pulumi.get(self, "contributor_insights_specification")

    @property
    @pulumi.getter(name="deletionProtectionEnabled")
    def deletion_protection_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Determines if a table is protected from deletion. When enabled, the table cannot be deleted by any user or process. This setting is disabled by default. For more information, see [Using deletion protection](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.Basics.html#WorkingWithTables.Basics.DeletionProtection) in the *Developer Guide*.
        """
        return pulumi.get(self, "deletion_protection_enabled")

    @property
    @pulumi.getter(name="globalSecondaryIndexes")
    def global_secondary_indexes(self) -> pulumi.Output[Optional[Sequence['outputs.TableGlobalSecondaryIndex']]]:
        """
        Global secondary indexes to be created on the table. You can create up to 20 global secondary indexes.
          If you update a table to include a new global secondary index, CFNlong initiates the index creation and then proceeds with the stack update. CFNlong doesn't wait for the index to complete creation because the backfilling phase can take a long time, depending on the size of the table. You can't use the index or update the table until the index's status is ``ACTIVE``. You can track its status by using the DynamoDB [DescribeTable](https://docs.aws.amazon.com/cli/latest/reference/dynamodb/describe-table.html) command.
         If you add or delete an index during an update, we recommend that you don't update any other resources. If your stack fails to update and is rolled back while adding a new index, you must manually delete the index. 
         Updates are not supported. The following are exceptions:
          +  If you update either the contributor insights specification or the provisioned throughput values of global secondary indexes, you can update the table without interruption.
          +  You can delete or add one global secondary index without interruption. If you do both in the same update (for example, by changing the index's logical ID), the update fails.
        """
        return pulumi.get(self, "global_secondary_indexes")

    @property
    @pulumi.getter(name="importSourceSpecification")
    def import_source_specification(self) -> pulumi.Output[Optional['outputs.TableImportSourceSpecification']]:
        """
        Specifies the properties of data being imported from the S3 bucket source to the" table.
          If you specify the ``ImportSourceSpecification`` property, and also specify either the ``StreamSpecification``, the ``TableClass`` property, the ``DeletionProtectionEnabled`` property, or the ``WarmThroughput`` property, the IAM entity creating/updating stack must have ``UpdateTable`` permission.
        """
        return pulumi.get(self, "import_source_specification")

    @property
    @pulumi.getter(name="keySchema")
    def key_schema(self) -> pulumi.Output[Any]:
        """
        Specifies the attributes that make up the primary key for the table. The attributes in the ``KeySchema`` property must also be defined in the ``AttributeDefinitions`` property.
        """
        return pulumi.get(self, "key_schema")

    @property
    @pulumi.getter(name="kinesisStreamSpecification")
    def kinesis_stream_specification(self) -> pulumi.Output[Optional['outputs.TableKinesisStreamSpecification']]:
        """
        The Kinesis Data Streams configuration for the specified table.
        """
        return pulumi.get(self, "kinesis_stream_specification")

    @property
    @pulumi.getter(name="localSecondaryIndexes")
    def local_secondary_indexes(self) -> pulumi.Output[Optional[Sequence['outputs.TableLocalSecondaryIndex']]]:
        """
        Local secondary indexes to be created on the table. You can create up to 5 local secondary indexes. Each index is scoped to a given hash key value. The size of each hash key can be up to 10 gigabytes.
        """
        return pulumi.get(self, "local_secondary_indexes")

    @property
    @pulumi.getter(name="onDemandThroughput")
    def on_demand_throughput(self) -> pulumi.Output[Optional['outputs.TableOnDemandThroughput']]:
        """
        Sets the maximum number of read and write units for the specified on-demand table. If you use this property, you must specify ``MaxReadRequestUnits``, ``MaxWriteRequestUnits``, or both.
        """
        return pulumi.get(self, "on_demand_throughput")

    @property
    @pulumi.getter(name="pointInTimeRecoverySpecification")
    def point_in_time_recovery_specification(self) -> pulumi.Output[Optional['outputs.TablePointInTimeRecoverySpecification']]:
        """
        The settings used to enable point in time recovery.
        """
        return pulumi.get(self, "point_in_time_recovery_specification")

    @property
    @pulumi.getter(name="provisionedThroughput")
    def provisioned_throughput(self) -> pulumi.Output[Optional['outputs.TableProvisionedThroughput']]:
        """
        Throughput for the specified table, which consists of values for ``ReadCapacityUnits`` and ``WriteCapacityUnits``. For more information about the contents of a provisioned throughput structure, see [Amazon DynamoDB Table ProvisionedThroughput](https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_ProvisionedThroughput.html). 
         If you set ``BillingMode`` as ``PROVISIONED``, you must specify this property. If you set ``BillingMode`` as ``PAY_PER_REQUEST``, you cannot specify this property.
        """
        return pulumi.get(self, "provisioned_throughput")

    @property
    @pulumi.getter(name="resourcePolicy")
    def resource_policy(self) -> pulumi.Output[Optional['outputs.TableResourcePolicy']]:
        """
        A resource-based policy document that contains permissions to add to the specified table. In a CFNshort template, you can provide the policy in JSON or YAML format because CFNshort converts YAML to JSON before submitting it to DDB. For more information about resource-based policies, see [Using resource-based policies for](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/access-control-resource-based.html) and [Resource-based policy examples](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/rbac-examples.html).
         When you attach a resource-based policy while creating a table, the policy creation is *strongly consistent*. For information about the considerations that you should keep in mind while attaching a resource-based policy, see [Resource-based policy considerations](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/rbac-considerations.html).
        """
        return pulumi.get(self, "resource_policy")

    @property
    @pulumi.getter(name="sseSpecification")
    def sse_specification(self) -> pulumi.Output[Optional['outputs.TableSseSpecification']]:
        """
        Specifies the settings to enable server-side encryption.
        """
        return pulumi.get(self, "sse_specification")

    @property
    @pulumi.getter(name="streamArn")
    def stream_arn(self) -> pulumi.Output[builtins.str]:
        """
        The ARN of the DynamoDB stream, such as `arn:aws:dynamodb:us-east-1:123456789012:table/testddbstack-myDynamoDBTable-012A1SL7SMP5Q/stream/2015-11-30T20:10:00.000` .

        > You must specify the `StreamSpecification` property to use this attribute.
        """
        return pulumi.get(self, "stream_arn")

    @property
    @pulumi.getter(name="streamSpecification")
    def stream_specification(self) -> pulumi.Output[Optional['outputs.TableStreamSpecification']]:
        """
        The settings for the DDB table stream, which capture changes to items stored in the table.
        """
        return pulumi.get(self, "stream_specification")

    @property
    @pulumi.getter(name="tableClass")
    def table_class(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The table class of the new table. Valid values are ``STANDARD`` and ``STANDARD_INFREQUENT_ACCESS``.
        """
        return pulumi.get(self, "table_class")

    @property
    @pulumi.getter(name="tableName")
    def table_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        A name for the table. If you don't specify a name, CFNlong generates a unique physical ID and uses that ID for the table name. For more information, see [Name Type](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-name.html).
          If you specify a name, you cannot perform updates that require replacement of this resource. You can perform updates that require no or some interruption. If you must replace the resource, specify a new name.
        """
        return pulumi.get(self, "table_name")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        An array of key-value pairs to apply to this resource.
         For more information, see [Tag](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html).
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="timeToLiveSpecification")
    def time_to_live_specification(self) -> pulumi.Output[Optional['outputs.TableTimeToLiveSpecification']]:
        """
        Specifies the Time to Live (TTL) settings for the table.
          For detailed information about the limits in DynamoDB, see [Limits in Amazon DynamoDB](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html) in the Amazon DynamoDB Developer Guide.
        """
        return pulumi.get(self, "time_to_live_specification")

    @property
    @pulumi.getter(name="warmThroughput")
    def warm_throughput(self) -> pulumi.Output[Optional['outputs.TableWarmThroughput']]:
        """
        Represents the warm throughput (in read units per second and write units per second) for creating a table.
        """
        return pulumi.get(self, "warm_throughput")

