# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'MultiRegionPropertiesProperties',
]

@pulumi.output_type
class MultiRegionPropertiesProperties(dict):
    """
    The Multi-region properties associated to this cluster.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "witnessRegion":
            suggest = "witness_region"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MultiRegionPropertiesProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MultiRegionPropertiesProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MultiRegionPropertiesProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 clusters: Optional[Sequence[builtins.str]] = None,
                 witness_region: Optional[builtins.str] = None):
        """
        The Multi-region properties associated to this cluster.
        :param Sequence[builtins.str] clusters: The set of peered clusters that form the multi-Region cluster configuration. Each peered cluster represents a database instance in a different Region.
        :param builtins.str witness_region: The witness region in a multi-region cluster.
        """
        if clusters is not None:
            pulumi.set(__self__, "clusters", clusters)
        if witness_region is not None:
            pulumi.set(__self__, "witness_region", witness_region)

    @property
    @pulumi.getter
    def clusters(self) -> Optional[Sequence[builtins.str]]:
        """
        The set of peered clusters that form the multi-Region cluster configuration. Each peered cluster represents a database instance in a different Region.
        """
        return pulumi.get(self, "clusters")

    @property
    @pulumi.getter(name="witnessRegion")
    def witness_region(self) -> Optional[builtins.str]:
        """
        The witness region in a multi-region cluster.
        """
        return pulumi.get(self, "witness_region")


