# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import outputs as _root_outputs

__all__ = [
    'GetClusterResult',
    'AwaitableGetClusterResult',
    'get_cluster',
    'get_cluster_output',
]

@pulumi.output_type
class GetClusterResult:
    def __init__(__self__, creation_time=None, deletion_protection_enabled=None, identifier=None, multi_region_properties=None, resource_arn=None, status=None, tags=None, vpc_endpoint_service_name=None):
        if creation_time and not isinstance(creation_time, str):
            raise TypeError("Expected argument 'creation_time' to be a str")
        pulumi.set(__self__, "creation_time", creation_time)
        if deletion_protection_enabled and not isinstance(deletion_protection_enabled, bool):
            raise TypeError("Expected argument 'deletion_protection_enabled' to be a bool")
        pulumi.set(__self__, "deletion_protection_enabled", deletion_protection_enabled)
        if identifier and not isinstance(identifier, str):
            raise TypeError("Expected argument 'identifier' to be a str")
        pulumi.set(__self__, "identifier", identifier)
        if multi_region_properties and not isinstance(multi_region_properties, dict):
            raise TypeError("Expected argument 'multi_region_properties' to be a dict")
        pulumi.set(__self__, "multi_region_properties", multi_region_properties)
        if resource_arn and not isinstance(resource_arn, str):
            raise TypeError("Expected argument 'resource_arn' to be a str")
        pulumi.set(__self__, "resource_arn", resource_arn)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if vpc_endpoint_service_name and not isinstance(vpc_endpoint_service_name, str):
            raise TypeError("Expected argument 'vpc_endpoint_service_name' to be a str")
        pulumi.set(__self__, "vpc_endpoint_service_name", vpc_endpoint_service_name)

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> Optional[builtins.str]:
        """
        The time of when the cluster was created in ISO-8601 format.
        """
        return pulumi.get(self, "creation_time")

    @property
    @pulumi.getter(name="deletionProtectionEnabled")
    def deletion_protection_enabled(self) -> Optional[builtins.bool]:
        """
        Whether deletion protection is enabled in this cluster.
        """
        return pulumi.get(self, "deletion_protection_enabled")

    @property
    @pulumi.getter
    def identifier(self) -> Optional[builtins.str]:
        """
        The ID of the created cluster.
        """
        return pulumi.get(self, "identifier")

    @property
    @pulumi.getter(name="multiRegionProperties")
    def multi_region_properties(self) -> Optional['outputs.MultiRegionPropertiesProperties']:
        """
        The Multi-region properties associated to this cluster.
        """
        return pulumi.get(self, "multi_region_properties")

    @property
    @pulumi.getter(name="resourceArn")
    def resource_arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) for the cluster.
        """
        return pulumi.get(self, "resource_arn")

    @property
    @pulumi.getter
    def status(self) -> Optional[builtins.str]:
        """
        The status of the cluster.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        A map of key and value pairs this cluster is tagged with.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="vpcEndpointServiceName")
    def vpc_endpoint_service_name(self) -> Optional[builtins.str]:
        """
        The VPC endpoint service name.
        """
        return pulumi.get(self, "vpc_endpoint_service_name")


class AwaitableGetClusterResult(GetClusterResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetClusterResult(
            creation_time=self.creation_time,
            deletion_protection_enabled=self.deletion_protection_enabled,
            identifier=self.identifier,
            multi_region_properties=self.multi_region_properties,
            resource_arn=self.resource_arn,
            status=self.status,
            tags=self.tags,
            vpc_endpoint_service_name=self.vpc_endpoint_service_name)


def get_cluster(identifier: Optional[builtins.str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetClusterResult:
    """
    Resource Type definition for AWS::DSQL::Cluster


    :param builtins.str identifier: The ID of the created cluster.
    """
    __args__ = dict()
    __args__['identifier'] = identifier
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:dsql:getCluster', __args__, opts=opts, typ=GetClusterResult).value

    return AwaitableGetClusterResult(
        creation_time=pulumi.get(__ret__, 'creation_time'),
        deletion_protection_enabled=pulumi.get(__ret__, 'deletion_protection_enabled'),
        identifier=pulumi.get(__ret__, 'identifier'),
        multi_region_properties=pulumi.get(__ret__, 'multi_region_properties'),
        resource_arn=pulumi.get(__ret__, 'resource_arn'),
        status=pulumi.get(__ret__, 'status'),
        tags=pulumi.get(__ret__, 'tags'),
        vpc_endpoint_service_name=pulumi.get(__ret__, 'vpc_endpoint_service_name'))
def get_cluster_output(identifier: Optional[pulumi.Input[builtins.str]] = None,
                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetClusterResult]:
    """
    Resource Type definition for AWS::DSQL::Cluster


    :param builtins.str identifier: The ID of the created cluster.
    """
    __args__ = dict()
    __args__['identifier'] = identifier
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:dsql:getCluster', __args__, opts=opts, typ=GetClusterResult)
    return __ret__.apply(lambda __response__: GetClusterResult(
        creation_time=pulumi.get(__response__, 'creation_time'),
        deletion_protection_enabled=pulumi.get(__response__, 'deletion_protection_enabled'),
        identifier=pulumi.get(__response__, 'identifier'),
        multi_region_properties=pulumi.get(__response__, 'multi_region_properties'),
        resource_arn=pulumi.get(__response__, 'resource_arn'),
        status=pulumi.get(__response__, 'status'),
        tags=pulumi.get(__response__, 'tags'),
        vpc_endpoint_service_name=pulumi.get(__response__, 'vpc_endpoint_service_name')))
