# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._inputs import *

__all__ = ['ClusterArgs', 'Cluster']

@pulumi.input_type
class ClusterArgs:
    def __init__(__self__, *,
                 deletion_protection_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 multi_region_properties: Optional[pulumi.Input['MultiRegionPropertiesPropertiesArgs']] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None):
        """
        The set of arguments for constructing a Cluster resource.
        :param pulumi.Input[builtins.bool] deletion_protection_enabled: Whether deletion protection is enabled in this cluster.
        :param pulumi.Input['MultiRegionPropertiesPropertiesArgs'] multi_region_properties: The Multi-region properties associated to this cluster.
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: A map of key and value pairs this cluster is tagged with.
        """
        if deletion_protection_enabled is not None:
            pulumi.set(__self__, "deletion_protection_enabled", deletion_protection_enabled)
        if multi_region_properties is not None:
            pulumi.set(__self__, "multi_region_properties", multi_region_properties)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="deletionProtectionEnabled")
    def deletion_protection_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether deletion protection is enabled in this cluster.
        """
        return pulumi.get(self, "deletion_protection_enabled")

    @deletion_protection_enabled.setter
    def deletion_protection_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "deletion_protection_enabled", value)

    @property
    @pulumi.getter(name="multiRegionProperties")
    def multi_region_properties(self) -> Optional[pulumi.Input['MultiRegionPropertiesPropertiesArgs']]:
        """
        The Multi-region properties associated to this cluster.
        """
        return pulumi.get(self, "multi_region_properties")

    @multi_region_properties.setter
    def multi_region_properties(self, value: Optional[pulumi.Input['MultiRegionPropertiesPropertiesArgs']]):
        pulumi.set(self, "multi_region_properties", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        A map of key and value pairs this cluster is tagged with.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("aws-native:dsql:Cluster")
class Cluster(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 deletion_protection_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 multi_region_properties: Optional[pulumi.Input[Union['MultiRegionPropertiesPropertiesArgs', 'MultiRegionPropertiesPropertiesArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        """
        Resource Type definition for AWS::DSQL::Cluster

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] deletion_protection_enabled: Whether deletion protection is enabled in this cluster.
        :param pulumi.Input[Union['MultiRegionPropertiesPropertiesArgs', 'MultiRegionPropertiesPropertiesArgsDict']] multi_region_properties: The Multi-region properties associated to this cluster.
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: A map of key and value pairs this cluster is tagged with.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ClusterArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource Type definition for AWS::DSQL::Cluster

        :param str resource_name: The name of the resource.
        :param ClusterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ClusterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 deletion_protection_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 multi_region_properties: Optional[pulumi.Input[Union['MultiRegionPropertiesPropertiesArgs', 'MultiRegionPropertiesPropertiesArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ClusterArgs.__new__(ClusterArgs)

            __props__.__dict__["deletion_protection_enabled"] = deletion_protection_enabled
            __props__.__dict__["multi_region_properties"] = multi_region_properties
            __props__.__dict__["tags"] = tags
            __props__.__dict__["creation_time"] = None
            __props__.__dict__["identifier"] = None
            __props__.__dict__["resource_arn"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["vpc_endpoint_service_name"] = None
        super(Cluster, __self__).__init__(
            'aws-native:dsql:Cluster',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Cluster':
        """
        Get an existing Cluster resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = ClusterArgs.__new__(ClusterArgs)

        __props__.__dict__["creation_time"] = None
        __props__.__dict__["deletion_protection_enabled"] = None
        __props__.__dict__["identifier"] = None
        __props__.__dict__["multi_region_properties"] = None
        __props__.__dict__["resource_arn"] = None
        __props__.__dict__["status"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["vpc_endpoint_service_name"] = None
        return Cluster(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> pulumi.Output[builtins.str]:
        """
        The time of when the cluster was created in ISO-8601 format.
        """
        return pulumi.get(self, "creation_time")

    @property
    @pulumi.getter(name="deletionProtectionEnabled")
    def deletion_protection_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Whether deletion protection is enabled in this cluster.
        """
        return pulumi.get(self, "deletion_protection_enabled")

    @property
    @pulumi.getter
    def identifier(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the created cluster.
        """
        return pulumi.get(self, "identifier")

    @property
    @pulumi.getter(name="multiRegionProperties")
    def multi_region_properties(self) -> pulumi.Output[Optional['outputs.MultiRegionPropertiesProperties']]:
        """
        The Multi-region properties associated to this cluster.
        """
        return pulumi.get(self, "multi_region_properties")

    @property
    @pulumi.getter(name="resourceArn")
    def resource_arn(self) -> pulumi.Output[builtins.str]:
        """
        The Amazon Resource Name (ARN) for the cluster.
        """
        return pulumi.get(self, "resource_arn")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[builtins.str]:
        """
        The status of the cluster.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        A map of key and value pairs this cluster is tagged with.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="vpcEndpointServiceName")
    def vpc_endpoint_service_name(self) -> pulumi.Output[builtins.str]:
        """
        The VPC endpoint service name.
        """
        return pulumi.get(self, "vpc_endpoint_service_name")

