# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'DataMigrationSettings',
    'DataMigrationSourceDataSettings',
    'MigrationProjectDataProviderDescriptor',
    'ReplicationConfigComputeConfig',
    'SchemaConversionApplicationAttributesProperties',
    'SettingsProperties',
    'SettingsPropertiesDocDbSettingsProperties',
    'SettingsPropertiesIbmDb2LuwSettingsProperties',
    'SettingsPropertiesIbmDb2zOsSettingsProperties',
    'SettingsPropertiesMariaDbSettingsProperties',
    'SettingsPropertiesMicrosoftSqlServerSettingsProperties',
    'SettingsPropertiesMongoDbSettingsProperties',
    'SettingsPropertiesMySqlSettingsProperties',
    'SettingsPropertiesOracleSettingsProperties',
    'SettingsPropertiesPostgreSqlSettingsProperties',
    'SettingsPropertiesRedshiftSettingsProperties',
]

@pulumi.output_type
class DataMigrationSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cloudwatchLogsEnabled":
            suggest = "cloudwatch_logs_enabled"
        elif key == "numberOfJobs":
            suggest = "number_of_jobs"
        elif key == "selectionRules":
            suggest = "selection_rules"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataMigrationSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataMigrationSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataMigrationSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cloudwatch_logs_enabled: Optional[builtins.bool] = None,
                 number_of_jobs: Optional[builtins.int] = None,
                 selection_rules: Optional[builtins.str] = None):
        """
        :param builtins.bool cloudwatch_logs_enabled: The property specifies whether to enable the Cloudwatch log.
        :param builtins.int number_of_jobs: The number of parallel jobs that trigger parallel threads to unload the tables from the source, and then load them to the target.
        :param builtins.str selection_rules: The property specifies the rules of selecting objects for data migration.
        """
        if cloudwatch_logs_enabled is not None:
            pulumi.set(__self__, "cloudwatch_logs_enabled", cloudwatch_logs_enabled)
        if number_of_jobs is not None:
            pulumi.set(__self__, "number_of_jobs", number_of_jobs)
        if selection_rules is not None:
            pulumi.set(__self__, "selection_rules", selection_rules)

    @property
    @pulumi.getter(name="cloudwatchLogsEnabled")
    def cloudwatch_logs_enabled(self) -> Optional[builtins.bool]:
        """
        The property specifies whether to enable the Cloudwatch log.
        """
        return pulumi.get(self, "cloudwatch_logs_enabled")

    @property
    @pulumi.getter(name="numberOfJobs")
    def number_of_jobs(self) -> Optional[builtins.int]:
        """
        The number of parallel jobs that trigger parallel threads to unload the tables from the source, and then load them to the target.
        """
        return pulumi.get(self, "number_of_jobs")

    @property
    @pulumi.getter(name="selectionRules")
    def selection_rules(self) -> Optional[builtins.str]:
        """
        The property specifies the rules of selecting objects for data migration.
        """
        return pulumi.get(self, "selection_rules")


@pulumi.output_type
class DataMigrationSourceDataSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cdcStartPosition":
            suggest = "cdc_start_position"
        elif key == "cdcStartTime":
            suggest = "cdc_start_time"
        elif key == "cdcStopTime":
            suggest = "cdc_stop_time"
        elif key == "slotName":
            suggest = "slot_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataMigrationSourceDataSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataMigrationSourceDataSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataMigrationSourceDataSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cdc_start_position: Optional[builtins.str] = None,
                 cdc_start_time: Optional[builtins.str] = None,
                 cdc_stop_time: Optional[builtins.str] = None,
                 slot_name: Optional[builtins.str] = None):
        """
        :param builtins.str cdc_start_position: The property is a point in the database engine's log that defines a time where you can begin CDC.
        :param builtins.str cdc_start_time: The property indicates the start time for a change data capture (CDC) operation. The value is server time in UTC format.
        :param builtins.str cdc_stop_time: The property indicates the stop time for a change data capture (CDC) operation. The value is server time in UTC format.
        :param builtins.str slot_name: The property sets the name of a previously created logical replication slot for a change data capture (CDC) load of the source instance.
        """
        if cdc_start_position is not None:
            pulumi.set(__self__, "cdc_start_position", cdc_start_position)
        if cdc_start_time is not None:
            pulumi.set(__self__, "cdc_start_time", cdc_start_time)
        if cdc_stop_time is not None:
            pulumi.set(__self__, "cdc_stop_time", cdc_stop_time)
        if slot_name is not None:
            pulumi.set(__self__, "slot_name", slot_name)

    @property
    @pulumi.getter(name="cdcStartPosition")
    def cdc_start_position(self) -> Optional[builtins.str]:
        """
        The property is a point in the database engine's log that defines a time where you can begin CDC.
        """
        return pulumi.get(self, "cdc_start_position")

    @property
    @pulumi.getter(name="cdcStartTime")
    def cdc_start_time(self) -> Optional[builtins.str]:
        """
        The property indicates the start time for a change data capture (CDC) operation. The value is server time in UTC format.
        """
        return pulumi.get(self, "cdc_start_time")

    @property
    @pulumi.getter(name="cdcStopTime")
    def cdc_stop_time(self) -> Optional[builtins.str]:
        """
        The property indicates the stop time for a change data capture (CDC) operation. The value is server time in UTC format.
        """
        return pulumi.get(self, "cdc_stop_time")

    @property
    @pulumi.getter(name="slotName")
    def slot_name(self) -> Optional[builtins.str]:
        """
        The property sets the name of a previously created logical replication slot for a change data capture (CDC) load of the source instance.
        """
        return pulumi.get(self, "slot_name")


@pulumi.output_type
class MigrationProjectDataProviderDescriptor(dict):
    """
    It is an object that describes Source and Target DataProviders and credentials for connecting to databases that are used in MigrationProject
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataProviderArn":
            suggest = "data_provider_arn"
        elif key == "dataProviderIdentifier":
            suggest = "data_provider_identifier"
        elif key == "dataProviderName":
            suggest = "data_provider_name"
        elif key == "secretsManagerAccessRoleArn":
            suggest = "secrets_manager_access_role_arn"
        elif key == "secretsManagerSecretId":
            suggest = "secrets_manager_secret_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MigrationProjectDataProviderDescriptor. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MigrationProjectDataProviderDescriptor.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MigrationProjectDataProviderDescriptor.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_provider_arn: Optional[builtins.str] = None,
                 data_provider_identifier: Optional[builtins.str] = None,
                 data_provider_name: Optional[builtins.str] = None,
                 secrets_manager_access_role_arn: Optional[builtins.str] = None,
                 secrets_manager_secret_id: Optional[builtins.str] = None):
        """
        It is an object that describes Source and Target DataProviders and credentials for connecting to databases that are used in MigrationProject
        :param builtins.str data_provider_arn: The Amazon Resource Name (ARN) of the data provider.
        :param builtins.str data_provider_name: The user-friendly name of the data provider.
        :param builtins.str secrets_manager_access_role_arn: The ARN of the role used to access AWS Secrets Manager.
        :param builtins.str secrets_manager_secret_id: The identifier of the AWS Secrets Manager Secret used to store access credentials for the data provider.
        """
        if data_provider_arn is not None:
            pulumi.set(__self__, "data_provider_arn", data_provider_arn)
        if data_provider_identifier is not None:
            pulumi.set(__self__, "data_provider_identifier", data_provider_identifier)
        if data_provider_name is not None:
            pulumi.set(__self__, "data_provider_name", data_provider_name)
        if secrets_manager_access_role_arn is not None:
            pulumi.set(__self__, "secrets_manager_access_role_arn", secrets_manager_access_role_arn)
        if secrets_manager_secret_id is not None:
            pulumi.set(__self__, "secrets_manager_secret_id", secrets_manager_secret_id)

    @property
    @pulumi.getter(name="dataProviderArn")
    def data_provider_arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the data provider.
        """
        return pulumi.get(self, "data_provider_arn")

    @property
    @pulumi.getter(name="dataProviderIdentifier")
    def data_provider_identifier(self) -> Optional[builtins.str]:
        return pulumi.get(self, "data_provider_identifier")

    @property
    @pulumi.getter(name="dataProviderName")
    def data_provider_name(self) -> Optional[builtins.str]:
        """
        The user-friendly name of the data provider.
        """
        return pulumi.get(self, "data_provider_name")

    @property
    @pulumi.getter(name="secretsManagerAccessRoleArn")
    def secrets_manager_access_role_arn(self) -> Optional[builtins.str]:
        """
        The ARN of the role used to access AWS Secrets Manager.
        """
        return pulumi.get(self, "secrets_manager_access_role_arn")

    @property
    @pulumi.getter(name="secretsManagerSecretId")
    def secrets_manager_secret_id(self) -> Optional[builtins.str]:
        """
        The identifier of the AWS Secrets Manager Secret used to store access credentials for the data provider.
        """
        return pulumi.get(self, "secrets_manager_secret_id")


@pulumi.output_type
class ReplicationConfigComputeConfig(dict):
    """
    Configuration parameters for provisioning a AWS DMS Serverless replication
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxCapacityUnits":
            suggest = "max_capacity_units"
        elif key == "availabilityZone":
            suggest = "availability_zone"
        elif key == "dnsNameServers":
            suggest = "dns_name_servers"
        elif key == "kmsKeyId":
            suggest = "kms_key_id"
        elif key == "minCapacityUnits":
            suggest = "min_capacity_units"
        elif key == "multiAz":
            suggest = "multi_az"
        elif key == "preferredMaintenanceWindow":
            suggest = "preferred_maintenance_window"
        elif key == "replicationSubnetGroupId":
            suggest = "replication_subnet_group_id"
        elif key == "vpcSecurityGroupIds":
            suggest = "vpc_security_group_ids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ReplicationConfigComputeConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ReplicationConfigComputeConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ReplicationConfigComputeConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_capacity_units: builtins.int,
                 availability_zone: Optional[builtins.str] = None,
                 dns_name_servers: Optional[builtins.str] = None,
                 kms_key_id: Optional[builtins.str] = None,
                 min_capacity_units: Optional[builtins.int] = None,
                 multi_az: Optional[builtins.bool] = None,
                 preferred_maintenance_window: Optional[builtins.str] = None,
                 replication_subnet_group_id: Optional[builtins.str] = None,
                 vpc_security_group_ids: Optional[Sequence[builtins.str]] = None):
        """
        Configuration parameters for provisioning a AWS DMS Serverless replication
        :param builtins.int max_capacity_units: Specifies the maximum value of the AWS DMS capacity units (DCUs) for which a given AWS DMS Serverless replication can be provisioned. A single DCU is 2GB of RAM, with 1 DCU as the minimum value allowed. The list of valid DCU values includes 1, 2, 4, 8, 16, 32, 64, 128, 192, 256, and 384. So, the maximum value that you can specify for AWS DMS Serverless is 384. The `MaxCapacityUnits` parameter is the only DCU parameter you are required to specify.
        :param builtins.str availability_zone: The Availability Zone where the AWS DMS Serverless replication using this configuration will run. The default value is a random, system-chosen Availability Zone in the configuration's AWS Region , for example, `"us-west-2"` . You can't set this parameter if the `MultiAZ` parameter is set to `true` .
        :param builtins.str dns_name_servers: A list of custom DNS name servers supported for the AWS DMS Serverless replication to access your source or target database. This list overrides the default name servers supported by the AWS DMS Serverless replication. You can specify a comma-separated list of internet addresses for up to four DNS name servers. For example: `"1.1.1.1,2.2.2.2,3.3.3.3,4.4.4.4"`
        :param builtins.str kms_key_id: An AWS Key Management Service ( AWS KMS ) key Amazon Resource Name (ARN) that is used to encrypt the data during AWS DMS Serverless replication.
               
               If you don't specify a value for the `KmsKeyId` parameter, AWS DMS uses your default encryption key.
               
               AWS KMS creates the default encryption key for your Amazon Web Services account. Your AWS account has a different default encryption key for each AWS Region .
        :param builtins.int min_capacity_units: Specifies the minimum value of the AWS DMS capacity units (DCUs) for which a given AWS DMS Serverless replication can be provisioned. A single DCU is 2GB of RAM, with 1 DCU as the minimum value allowed. The list of valid DCU values includes 1, 2, 4, 8, 16, 32, 64, 128, 192, 256, and 384. So, the minimum DCU value that you can specify for AWS DMS Serverless is 1. If you don't set this value, AWS DMS sets this parameter to the minimum DCU value allowed, 1. If there is no current source activity, AWS DMS scales down your replication until it reaches the value specified in `MinCapacityUnits` .
        :param builtins.bool multi_az: Specifies whether the AWS DMS Serverless replication is a Multi-AZ deployment. You can't set the `AvailabilityZone` parameter if the `MultiAZ` parameter is set to `true` .
        :param builtins.str preferred_maintenance_window: The weekly time range during which system maintenance can occur for the AWS DMS Serverless replication, in Universal Coordinated Time (UTC). The format is `ddd:hh24:mi-ddd:hh24:mi` .
               
               The default is a 30-minute window selected at random from an 8-hour block of time per AWS Region . This maintenance occurs on a random day of the week. Valid values for days of the week include `Mon` , `Tue` , `Wed` , `Thu` , `Fri` , `Sat` , and `Sun` .
               
               Constraints include a minimum 30-minute window.
        :param builtins.str replication_subnet_group_id: Specifies a subnet group identifier to associate with the AWS DMS Serverless replication.
        :param Sequence[builtins.str] vpc_security_group_ids: Specifies the virtual private cloud (VPC) security group to use with the AWS DMS Serverless replication. The VPC security group must work with the VPC containing the replication.
        """
        pulumi.set(__self__, "max_capacity_units", max_capacity_units)
        if availability_zone is not None:
            pulumi.set(__self__, "availability_zone", availability_zone)
        if dns_name_servers is not None:
            pulumi.set(__self__, "dns_name_servers", dns_name_servers)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if min_capacity_units is not None:
            pulumi.set(__self__, "min_capacity_units", min_capacity_units)
        if multi_az is not None:
            pulumi.set(__self__, "multi_az", multi_az)
        if preferred_maintenance_window is not None:
            pulumi.set(__self__, "preferred_maintenance_window", preferred_maintenance_window)
        if replication_subnet_group_id is not None:
            pulumi.set(__self__, "replication_subnet_group_id", replication_subnet_group_id)
        if vpc_security_group_ids is not None:
            pulumi.set(__self__, "vpc_security_group_ids", vpc_security_group_ids)

    @property
    @pulumi.getter(name="maxCapacityUnits")
    def max_capacity_units(self) -> builtins.int:
        """
        Specifies the maximum value of the AWS DMS capacity units (DCUs) for which a given AWS DMS Serverless replication can be provisioned. A single DCU is 2GB of RAM, with 1 DCU as the minimum value allowed. The list of valid DCU values includes 1, 2, 4, 8, 16, 32, 64, 128, 192, 256, and 384. So, the maximum value that you can specify for AWS DMS Serverless is 384. The `MaxCapacityUnits` parameter is the only DCU parameter you are required to specify.
        """
        return pulumi.get(self, "max_capacity_units")

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> Optional[builtins.str]:
        """
        The Availability Zone where the AWS DMS Serverless replication using this configuration will run. The default value is a random, system-chosen Availability Zone in the configuration's AWS Region , for example, `"us-west-2"` . You can't set this parameter if the `MultiAZ` parameter is set to `true` .
        """
        return pulumi.get(self, "availability_zone")

    @property
    @pulumi.getter(name="dnsNameServers")
    def dns_name_servers(self) -> Optional[builtins.str]:
        """
        A list of custom DNS name servers supported for the AWS DMS Serverless replication to access your source or target database. This list overrides the default name servers supported by the AWS DMS Serverless replication. You can specify a comma-separated list of internet addresses for up to four DNS name servers. For example: `"1.1.1.1,2.2.2.2,3.3.3.3,4.4.4.4"`
        """
        return pulumi.get(self, "dns_name_servers")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[builtins.str]:
        """
        An AWS Key Management Service ( AWS KMS ) key Amazon Resource Name (ARN) that is used to encrypt the data during AWS DMS Serverless replication.

        If you don't specify a value for the `KmsKeyId` parameter, AWS DMS uses your default encryption key.

        AWS KMS creates the default encryption key for your Amazon Web Services account. Your AWS account has a different default encryption key for each AWS Region .
        """
        return pulumi.get(self, "kms_key_id")

    @property
    @pulumi.getter(name="minCapacityUnits")
    def min_capacity_units(self) -> Optional[builtins.int]:
        """
        Specifies the minimum value of the AWS DMS capacity units (DCUs) for which a given AWS DMS Serverless replication can be provisioned. A single DCU is 2GB of RAM, with 1 DCU as the minimum value allowed. The list of valid DCU values includes 1, 2, 4, 8, 16, 32, 64, 128, 192, 256, and 384. So, the minimum DCU value that you can specify for AWS DMS Serverless is 1. If you don't set this value, AWS DMS sets this parameter to the minimum DCU value allowed, 1. If there is no current source activity, AWS DMS scales down your replication until it reaches the value specified in `MinCapacityUnits` .
        """
        return pulumi.get(self, "min_capacity_units")

    @property
    @pulumi.getter(name="multiAz")
    def multi_az(self) -> Optional[builtins.bool]:
        """
        Specifies whether the AWS DMS Serverless replication is a Multi-AZ deployment. You can't set the `AvailabilityZone` parameter if the `MultiAZ` parameter is set to `true` .
        """
        return pulumi.get(self, "multi_az")

    @property
    @pulumi.getter(name="preferredMaintenanceWindow")
    def preferred_maintenance_window(self) -> Optional[builtins.str]:
        """
        The weekly time range during which system maintenance can occur for the AWS DMS Serverless replication, in Universal Coordinated Time (UTC). The format is `ddd:hh24:mi-ddd:hh24:mi` .

        The default is a 30-minute window selected at random from an 8-hour block of time per AWS Region . This maintenance occurs on a random day of the week. Valid values for days of the week include `Mon` , `Tue` , `Wed` , `Thu` , `Fri` , `Sat` , and `Sun` .

        Constraints include a minimum 30-minute window.
        """
        return pulumi.get(self, "preferred_maintenance_window")

    @property
    @pulumi.getter(name="replicationSubnetGroupId")
    def replication_subnet_group_id(self) -> Optional[builtins.str]:
        """
        Specifies a subnet group identifier to associate with the AWS DMS Serverless replication.
        """
        return pulumi.get(self, "replication_subnet_group_id")

    @property
    @pulumi.getter(name="vpcSecurityGroupIds")
    def vpc_security_group_ids(self) -> Optional[Sequence[builtins.str]]:
        """
        Specifies the virtual private cloud (VPC) security group to use with the AWS DMS Serverless replication. The VPC security group must work with the VPC containing the replication.
        """
        return pulumi.get(self, "vpc_security_group_ids")


@pulumi.output_type
class SchemaConversionApplicationAttributesProperties(dict):
    """
    The property describes schema conversion application attributes for the migration project.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "s3BucketPath":
            suggest = "s3_bucket_path"
        elif key == "s3BucketRoleArn":
            suggest = "s3_bucket_role_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SchemaConversionApplicationAttributesProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SchemaConversionApplicationAttributesProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SchemaConversionApplicationAttributesProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 s3_bucket_path: Optional[builtins.str] = None,
                 s3_bucket_role_arn: Optional[builtins.str] = None):
        """
        The property describes schema conversion application attributes for the migration project.
        """
        if s3_bucket_path is not None:
            pulumi.set(__self__, "s3_bucket_path", s3_bucket_path)
        if s3_bucket_role_arn is not None:
            pulumi.set(__self__, "s3_bucket_role_arn", s3_bucket_role_arn)

    @property
    @pulumi.getter(name="s3BucketPath")
    def s3_bucket_path(self) -> Optional[builtins.str]:
        return pulumi.get(self, "s3_bucket_path")

    @property
    @pulumi.getter(name="s3BucketRoleArn")
    def s3_bucket_role_arn(self) -> Optional[builtins.str]:
        return pulumi.get(self, "s3_bucket_role_arn")


@pulumi.output_type
class SettingsProperties(dict):
    """
    The property identifies the exact type of settings for the data provider.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "docDbSettings":
            suggest = "doc_db_settings"
        elif key == "ibmDb2LuwSettings":
            suggest = "ibm_db2_luw_settings"
        elif key == "ibmDb2zOsSettings":
            suggest = "ibm_db2z_os_settings"
        elif key == "mariaDbSettings":
            suggest = "maria_db_settings"
        elif key == "microsoftSqlServerSettings":
            suggest = "microsoft_sql_server_settings"
        elif key == "mongoDbSettings":
            suggest = "mongo_db_settings"
        elif key == "mySqlSettings":
            suggest = "my_sql_settings"
        elif key == "oracleSettings":
            suggest = "oracle_settings"
        elif key == "postgreSqlSettings":
            suggest = "postgre_sql_settings"
        elif key == "redshiftSettings":
            suggest = "redshift_settings"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SettingsProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SettingsProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SettingsProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 doc_db_settings: Optional['outputs.SettingsPropertiesDocDbSettingsProperties'] = None,
                 ibm_db2_luw_settings: Optional['outputs.SettingsPropertiesIbmDb2LuwSettingsProperties'] = None,
                 ibm_db2z_os_settings: Optional['outputs.SettingsPropertiesIbmDb2zOsSettingsProperties'] = None,
                 maria_db_settings: Optional['outputs.SettingsPropertiesMariaDbSettingsProperties'] = None,
                 microsoft_sql_server_settings: Optional['outputs.SettingsPropertiesMicrosoftSqlServerSettingsProperties'] = None,
                 mongo_db_settings: Optional['outputs.SettingsPropertiesMongoDbSettingsProperties'] = None,
                 my_sql_settings: Optional['outputs.SettingsPropertiesMySqlSettingsProperties'] = None,
                 oracle_settings: Optional['outputs.SettingsPropertiesOracleSettingsProperties'] = None,
                 postgre_sql_settings: Optional['outputs.SettingsPropertiesPostgreSqlSettingsProperties'] = None,
                 redshift_settings: Optional['outputs.SettingsPropertiesRedshiftSettingsProperties'] = None):
        """
        The property identifies the exact type of settings for the data provider.
        :param 'SettingsPropertiesDocDbSettingsProperties' doc_db_settings: DocDbSettings property identifier.
        :param 'SettingsPropertiesIbmDb2LuwSettingsProperties' ibm_db2_luw_settings: IbmDb2LuwSettings property identifier.
        :param 'SettingsPropertiesIbmDb2zOsSettingsProperties' ibm_db2z_os_settings: IbmDb2zOsSettings property identifier.
        :param 'SettingsPropertiesMariaDbSettingsProperties' maria_db_settings: MariaDbSettings property identifier.
        :param 'SettingsPropertiesMicrosoftSqlServerSettingsProperties' microsoft_sql_server_settings: MicrosoftSqlServerSettings property identifier.
        :param 'SettingsPropertiesMongoDbSettingsProperties' mongo_db_settings: MongoDbSettings property identifier.
        :param 'SettingsPropertiesMySqlSettingsProperties' my_sql_settings: MySqlSettings property identifier.
        :param 'SettingsPropertiesOracleSettingsProperties' oracle_settings: OracleSettings property identifier.
        :param 'SettingsPropertiesPostgreSqlSettingsProperties' postgre_sql_settings: PostgreSqlSettings property identifier.
        :param 'SettingsPropertiesRedshiftSettingsProperties' redshift_settings: RedshiftSettings property identifier.
        """
        if doc_db_settings is not None:
            pulumi.set(__self__, "doc_db_settings", doc_db_settings)
        if ibm_db2_luw_settings is not None:
            pulumi.set(__self__, "ibm_db2_luw_settings", ibm_db2_luw_settings)
        if ibm_db2z_os_settings is not None:
            pulumi.set(__self__, "ibm_db2z_os_settings", ibm_db2z_os_settings)
        if maria_db_settings is not None:
            pulumi.set(__self__, "maria_db_settings", maria_db_settings)
        if microsoft_sql_server_settings is not None:
            pulumi.set(__self__, "microsoft_sql_server_settings", microsoft_sql_server_settings)
        if mongo_db_settings is not None:
            pulumi.set(__self__, "mongo_db_settings", mongo_db_settings)
        if my_sql_settings is not None:
            pulumi.set(__self__, "my_sql_settings", my_sql_settings)
        if oracle_settings is not None:
            pulumi.set(__self__, "oracle_settings", oracle_settings)
        if postgre_sql_settings is not None:
            pulumi.set(__self__, "postgre_sql_settings", postgre_sql_settings)
        if redshift_settings is not None:
            pulumi.set(__self__, "redshift_settings", redshift_settings)

    @property
    @pulumi.getter(name="docDbSettings")
    def doc_db_settings(self) -> Optional['outputs.SettingsPropertiesDocDbSettingsProperties']:
        """
        DocDbSettings property identifier.
        """
        return pulumi.get(self, "doc_db_settings")

    @property
    @pulumi.getter(name="ibmDb2LuwSettings")
    def ibm_db2_luw_settings(self) -> Optional['outputs.SettingsPropertiesIbmDb2LuwSettingsProperties']:
        """
        IbmDb2LuwSettings property identifier.
        """
        return pulumi.get(self, "ibm_db2_luw_settings")

    @property
    @pulumi.getter(name="ibmDb2zOsSettings")
    def ibm_db2z_os_settings(self) -> Optional['outputs.SettingsPropertiesIbmDb2zOsSettingsProperties']:
        """
        IbmDb2zOsSettings property identifier.
        """
        return pulumi.get(self, "ibm_db2z_os_settings")

    @property
    @pulumi.getter(name="mariaDbSettings")
    def maria_db_settings(self) -> Optional['outputs.SettingsPropertiesMariaDbSettingsProperties']:
        """
        MariaDbSettings property identifier.
        """
        return pulumi.get(self, "maria_db_settings")

    @property
    @pulumi.getter(name="microsoftSqlServerSettings")
    def microsoft_sql_server_settings(self) -> Optional['outputs.SettingsPropertiesMicrosoftSqlServerSettingsProperties']:
        """
        MicrosoftSqlServerSettings property identifier.
        """
        return pulumi.get(self, "microsoft_sql_server_settings")

    @property
    @pulumi.getter(name="mongoDbSettings")
    def mongo_db_settings(self) -> Optional['outputs.SettingsPropertiesMongoDbSettingsProperties']:
        """
        MongoDbSettings property identifier.
        """
        return pulumi.get(self, "mongo_db_settings")

    @property
    @pulumi.getter(name="mySqlSettings")
    def my_sql_settings(self) -> Optional['outputs.SettingsPropertiesMySqlSettingsProperties']:
        """
        MySqlSettings property identifier.
        """
        return pulumi.get(self, "my_sql_settings")

    @property
    @pulumi.getter(name="oracleSettings")
    def oracle_settings(self) -> Optional['outputs.SettingsPropertiesOracleSettingsProperties']:
        """
        OracleSettings property identifier.
        """
        return pulumi.get(self, "oracle_settings")

    @property
    @pulumi.getter(name="postgreSqlSettings")
    def postgre_sql_settings(self) -> Optional['outputs.SettingsPropertiesPostgreSqlSettingsProperties']:
        """
        PostgreSqlSettings property identifier.
        """
        return pulumi.get(self, "postgre_sql_settings")

    @property
    @pulumi.getter(name="redshiftSettings")
    def redshift_settings(self) -> Optional['outputs.SettingsPropertiesRedshiftSettingsProperties']:
        """
        RedshiftSettings property identifier.
        """
        return pulumi.get(self, "redshift_settings")


@pulumi.output_type
class SettingsPropertiesDocDbSettingsProperties(dict):
    """
    DocDbSettings property identifier.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "databaseName":
            suggest = "database_name"
        elif key == "serverName":
            suggest = "server_name"
        elif key == "certificateArn":
            suggest = "certificate_arn"
        elif key == "sslMode":
            suggest = "ssl_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SettingsPropertiesDocDbSettingsProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SettingsPropertiesDocDbSettingsProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SettingsPropertiesDocDbSettingsProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 database_name: builtins.str,
                 port: builtins.int,
                 server_name: builtins.str,
                 certificate_arn: Optional[builtins.str] = None,
                 ssl_mode: Optional['DataProviderMongoDbSslModeValue'] = None):
        """
        DocDbSettings property identifier.
        """
        pulumi.set(__self__, "database_name", database_name)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "server_name", server_name)
        if certificate_arn is not None:
            pulumi.set(__self__, "certificate_arn", certificate_arn)
        if ssl_mode is not None:
            pulumi.set(__self__, "ssl_mode", ssl_mode)

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> builtins.str:
        return pulumi.get(self, "database_name")

    @property
    @pulumi.getter
    def port(self) -> builtins.int:
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="serverName")
    def server_name(self) -> builtins.str:
        return pulumi.get(self, "server_name")

    @property
    @pulumi.getter(name="certificateArn")
    def certificate_arn(self) -> Optional[builtins.str]:
        return pulumi.get(self, "certificate_arn")

    @property
    @pulumi.getter(name="sslMode")
    def ssl_mode(self) -> Optional['DataProviderMongoDbSslModeValue']:
        return pulumi.get(self, "ssl_mode")


@pulumi.output_type
class SettingsPropertiesIbmDb2LuwSettingsProperties(dict):
    """
    IbmDb2LuwSettings property identifier.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "databaseName":
            suggest = "database_name"
        elif key == "serverName":
            suggest = "server_name"
        elif key == "sslMode":
            suggest = "ssl_mode"
        elif key == "certificateArn":
            suggest = "certificate_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SettingsPropertiesIbmDb2LuwSettingsProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SettingsPropertiesIbmDb2LuwSettingsProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SettingsPropertiesIbmDb2LuwSettingsProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 database_name: builtins.str,
                 port: builtins.int,
                 server_name: builtins.str,
                 ssl_mode: 'DataProviderDb2SslModeValue',
                 certificate_arn: Optional[builtins.str] = None):
        """
        IbmDb2LuwSettings property identifier.
        """
        pulumi.set(__self__, "database_name", database_name)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "server_name", server_name)
        pulumi.set(__self__, "ssl_mode", ssl_mode)
        if certificate_arn is not None:
            pulumi.set(__self__, "certificate_arn", certificate_arn)

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> builtins.str:
        return pulumi.get(self, "database_name")

    @property
    @pulumi.getter
    def port(self) -> builtins.int:
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="serverName")
    def server_name(self) -> builtins.str:
        return pulumi.get(self, "server_name")

    @property
    @pulumi.getter(name="sslMode")
    def ssl_mode(self) -> 'DataProviderDb2SslModeValue':
        return pulumi.get(self, "ssl_mode")

    @property
    @pulumi.getter(name="certificateArn")
    def certificate_arn(self) -> Optional[builtins.str]:
        return pulumi.get(self, "certificate_arn")


@pulumi.output_type
class SettingsPropertiesIbmDb2zOsSettingsProperties(dict):
    """
    IbmDb2zOsSettings property identifier.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "databaseName":
            suggest = "database_name"
        elif key == "serverName":
            suggest = "server_name"
        elif key == "sslMode":
            suggest = "ssl_mode"
        elif key == "certificateArn":
            suggest = "certificate_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SettingsPropertiesIbmDb2zOsSettingsProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SettingsPropertiesIbmDb2zOsSettingsProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SettingsPropertiesIbmDb2zOsSettingsProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 database_name: builtins.str,
                 port: builtins.int,
                 server_name: builtins.str,
                 ssl_mode: 'DataProviderDb2SslModeValue',
                 certificate_arn: Optional[builtins.str] = None):
        """
        IbmDb2zOsSettings property identifier.
        """
        pulumi.set(__self__, "database_name", database_name)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "server_name", server_name)
        pulumi.set(__self__, "ssl_mode", ssl_mode)
        if certificate_arn is not None:
            pulumi.set(__self__, "certificate_arn", certificate_arn)

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> builtins.str:
        return pulumi.get(self, "database_name")

    @property
    @pulumi.getter
    def port(self) -> builtins.int:
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="serverName")
    def server_name(self) -> builtins.str:
        return pulumi.get(self, "server_name")

    @property
    @pulumi.getter(name="sslMode")
    def ssl_mode(self) -> 'DataProviderDb2SslModeValue':
        return pulumi.get(self, "ssl_mode")

    @property
    @pulumi.getter(name="certificateArn")
    def certificate_arn(self) -> Optional[builtins.str]:
        return pulumi.get(self, "certificate_arn")


@pulumi.output_type
class SettingsPropertiesMariaDbSettingsProperties(dict):
    """
    MariaDbSettings property identifier.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "serverName":
            suggest = "server_name"
        elif key == "sslMode":
            suggest = "ssl_mode"
        elif key == "certificateArn":
            suggest = "certificate_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SettingsPropertiesMariaDbSettingsProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SettingsPropertiesMariaDbSettingsProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SettingsPropertiesMariaDbSettingsProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 port: builtins.int,
                 server_name: builtins.str,
                 ssl_mode: 'DataProviderDmsSslModeValue',
                 certificate_arn: Optional[builtins.str] = None):
        """
        MariaDbSettings property identifier.
        """
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "server_name", server_name)
        pulumi.set(__self__, "ssl_mode", ssl_mode)
        if certificate_arn is not None:
            pulumi.set(__self__, "certificate_arn", certificate_arn)

    @property
    @pulumi.getter
    def port(self) -> builtins.int:
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="serverName")
    def server_name(self) -> builtins.str:
        return pulumi.get(self, "server_name")

    @property
    @pulumi.getter(name="sslMode")
    def ssl_mode(self) -> 'DataProviderDmsSslModeValue':
        return pulumi.get(self, "ssl_mode")

    @property
    @pulumi.getter(name="certificateArn")
    def certificate_arn(self) -> Optional[builtins.str]:
        return pulumi.get(self, "certificate_arn")


@pulumi.output_type
class SettingsPropertiesMicrosoftSqlServerSettingsProperties(dict):
    """
    MicrosoftSqlServerSettings property identifier.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "databaseName":
            suggest = "database_name"
        elif key == "serverName":
            suggest = "server_name"
        elif key == "sslMode":
            suggest = "ssl_mode"
        elif key == "certificateArn":
            suggest = "certificate_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SettingsPropertiesMicrosoftSqlServerSettingsProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SettingsPropertiesMicrosoftSqlServerSettingsProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SettingsPropertiesMicrosoftSqlServerSettingsProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 database_name: builtins.str,
                 port: builtins.int,
                 server_name: builtins.str,
                 ssl_mode: 'DataProviderDmsSslModeValue',
                 certificate_arn: Optional[builtins.str] = None):
        """
        MicrosoftSqlServerSettings property identifier.
        """
        pulumi.set(__self__, "database_name", database_name)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "server_name", server_name)
        pulumi.set(__self__, "ssl_mode", ssl_mode)
        if certificate_arn is not None:
            pulumi.set(__self__, "certificate_arn", certificate_arn)

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> builtins.str:
        return pulumi.get(self, "database_name")

    @property
    @pulumi.getter
    def port(self) -> builtins.int:
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="serverName")
    def server_name(self) -> builtins.str:
        return pulumi.get(self, "server_name")

    @property
    @pulumi.getter(name="sslMode")
    def ssl_mode(self) -> 'DataProviderDmsSslModeValue':
        return pulumi.get(self, "ssl_mode")

    @property
    @pulumi.getter(name="certificateArn")
    def certificate_arn(self) -> Optional[builtins.str]:
        return pulumi.get(self, "certificate_arn")


@pulumi.output_type
class SettingsPropertiesMongoDbSettingsProperties(dict):
    """
    MongoDbSettings property identifier.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "serverName":
            suggest = "server_name"
        elif key == "authMechanism":
            suggest = "auth_mechanism"
        elif key == "authSource":
            suggest = "auth_source"
        elif key == "authType":
            suggest = "auth_type"
        elif key == "certificateArn":
            suggest = "certificate_arn"
        elif key == "databaseName":
            suggest = "database_name"
        elif key == "sslMode":
            suggest = "ssl_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SettingsPropertiesMongoDbSettingsProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SettingsPropertiesMongoDbSettingsProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SettingsPropertiesMongoDbSettingsProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 port: builtins.int,
                 server_name: builtins.str,
                 auth_mechanism: Optional['DataProviderMongoDbAuthMechanism'] = None,
                 auth_source: Optional[builtins.str] = None,
                 auth_type: Optional['DataProviderMongoDbAuthType'] = None,
                 certificate_arn: Optional[builtins.str] = None,
                 database_name: Optional[builtins.str] = None,
                 ssl_mode: Optional['DataProviderMongoDbSslModeValue'] = None):
        """
        MongoDbSettings property identifier.
        """
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "server_name", server_name)
        if auth_mechanism is not None:
            pulumi.set(__self__, "auth_mechanism", auth_mechanism)
        if auth_source is not None:
            pulumi.set(__self__, "auth_source", auth_source)
        if auth_type is not None:
            pulumi.set(__self__, "auth_type", auth_type)
        if certificate_arn is not None:
            pulumi.set(__self__, "certificate_arn", certificate_arn)
        if database_name is not None:
            pulumi.set(__self__, "database_name", database_name)
        if ssl_mode is not None:
            pulumi.set(__self__, "ssl_mode", ssl_mode)

    @property
    @pulumi.getter
    def port(self) -> builtins.int:
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="serverName")
    def server_name(self) -> builtins.str:
        return pulumi.get(self, "server_name")

    @property
    @pulumi.getter(name="authMechanism")
    def auth_mechanism(self) -> Optional['DataProviderMongoDbAuthMechanism']:
        return pulumi.get(self, "auth_mechanism")

    @property
    @pulumi.getter(name="authSource")
    def auth_source(self) -> Optional[builtins.str]:
        return pulumi.get(self, "auth_source")

    @property
    @pulumi.getter(name="authType")
    def auth_type(self) -> Optional['DataProviderMongoDbAuthType']:
        return pulumi.get(self, "auth_type")

    @property
    @pulumi.getter(name="certificateArn")
    def certificate_arn(self) -> Optional[builtins.str]:
        return pulumi.get(self, "certificate_arn")

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> Optional[builtins.str]:
        return pulumi.get(self, "database_name")

    @property
    @pulumi.getter(name="sslMode")
    def ssl_mode(self) -> Optional['DataProviderMongoDbSslModeValue']:
        return pulumi.get(self, "ssl_mode")


@pulumi.output_type
class SettingsPropertiesMySqlSettingsProperties(dict):
    """
    MySqlSettings property identifier.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "serverName":
            suggest = "server_name"
        elif key == "sslMode":
            suggest = "ssl_mode"
        elif key == "certificateArn":
            suggest = "certificate_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SettingsPropertiesMySqlSettingsProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SettingsPropertiesMySqlSettingsProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SettingsPropertiesMySqlSettingsProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 port: builtins.int,
                 server_name: builtins.str,
                 ssl_mode: 'DataProviderDmsSslModeValue',
                 certificate_arn: Optional[builtins.str] = None):
        """
        MySqlSettings property identifier.
        """
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "server_name", server_name)
        pulumi.set(__self__, "ssl_mode", ssl_mode)
        if certificate_arn is not None:
            pulumi.set(__self__, "certificate_arn", certificate_arn)

    @property
    @pulumi.getter
    def port(self) -> builtins.int:
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="serverName")
    def server_name(self) -> builtins.str:
        return pulumi.get(self, "server_name")

    @property
    @pulumi.getter(name="sslMode")
    def ssl_mode(self) -> 'DataProviderDmsSslModeValue':
        return pulumi.get(self, "ssl_mode")

    @property
    @pulumi.getter(name="certificateArn")
    def certificate_arn(self) -> Optional[builtins.str]:
        return pulumi.get(self, "certificate_arn")


@pulumi.output_type
class SettingsPropertiesOracleSettingsProperties(dict):
    """
    OracleSettings property identifier.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "databaseName":
            suggest = "database_name"
        elif key == "serverName":
            suggest = "server_name"
        elif key == "sslMode":
            suggest = "ssl_mode"
        elif key == "asmServer":
            suggest = "asm_server"
        elif key == "certificateArn":
            suggest = "certificate_arn"
        elif key == "secretsManagerOracleAsmAccessRoleArn":
            suggest = "secrets_manager_oracle_asm_access_role_arn"
        elif key == "secretsManagerOracleAsmSecretId":
            suggest = "secrets_manager_oracle_asm_secret_id"
        elif key == "secretsManagerSecurityDbEncryptionAccessRoleArn":
            suggest = "secrets_manager_security_db_encryption_access_role_arn"
        elif key == "secretsManagerSecurityDbEncryptionSecretId":
            suggest = "secrets_manager_security_db_encryption_secret_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SettingsPropertiesOracleSettingsProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SettingsPropertiesOracleSettingsProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SettingsPropertiesOracleSettingsProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 database_name: builtins.str,
                 port: builtins.int,
                 server_name: builtins.str,
                 ssl_mode: 'DataProviderDmsSslModeValue',
                 asm_server: Optional[builtins.str] = None,
                 certificate_arn: Optional[builtins.str] = None,
                 secrets_manager_oracle_asm_access_role_arn: Optional[builtins.str] = None,
                 secrets_manager_oracle_asm_secret_id: Optional[builtins.str] = None,
                 secrets_manager_security_db_encryption_access_role_arn: Optional[builtins.str] = None,
                 secrets_manager_security_db_encryption_secret_id: Optional[builtins.str] = None):
        """
        OracleSettings property identifier.
        """
        pulumi.set(__self__, "database_name", database_name)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "server_name", server_name)
        pulumi.set(__self__, "ssl_mode", ssl_mode)
        if asm_server is not None:
            pulumi.set(__self__, "asm_server", asm_server)
        if certificate_arn is not None:
            pulumi.set(__self__, "certificate_arn", certificate_arn)
        if secrets_manager_oracle_asm_access_role_arn is not None:
            pulumi.set(__self__, "secrets_manager_oracle_asm_access_role_arn", secrets_manager_oracle_asm_access_role_arn)
        if secrets_manager_oracle_asm_secret_id is not None:
            pulumi.set(__self__, "secrets_manager_oracle_asm_secret_id", secrets_manager_oracle_asm_secret_id)
        if secrets_manager_security_db_encryption_access_role_arn is not None:
            pulumi.set(__self__, "secrets_manager_security_db_encryption_access_role_arn", secrets_manager_security_db_encryption_access_role_arn)
        if secrets_manager_security_db_encryption_secret_id is not None:
            pulumi.set(__self__, "secrets_manager_security_db_encryption_secret_id", secrets_manager_security_db_encryption_secret_id)

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> builtins.str:
        return pulumi.get(self, "database_name")

    @property
    @pulumi.getter
    def port(self) -> builtins.int:
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="serverName")
    def server_name(self) -> builtins.str:
        return pulumi.get(self, "server_name")

    @property
    @pulumi.getter(name="sslMode")
    def ssl_mode(self) -> 'DataProviderDmsSslModeValue':
        return pulumi.get(self, "ssl_mode")

    @property
    @pulumi.getter(name="asmServer")
    def asm_server(self) -> Optional[builtins.str]:
        return pulumi.get(self, "asm_server")

    @property
    @pulumi.getter(name="certificateArn")
    def certificate_arn(self) -> Optional[builtins.str]:
        return pulumi.get(self, "certificate_arn")

    @property
    @pulumi.getter(name="secretsManagerOracleAsmAccessRoleArn")
    def secrets_manager_oracle_asm_access_role_arn(self) -> Optional[builtins.str]:
        return pulumi.get(self, "secrets_manager_oracle_asm_access_role_arn")

    @property
    @pulumi.getter(name="secretsManagerOracleAsmSecretId")
    def secrets_manager_oracle_asm_secret_id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "secrets_manager_oracle_asm_secret_id")

    @property
    @pulumi.getter(name="secretsManagerSecurityDbEncryptionAccessRoleArn")
    def secrets_manager_security_db_encryption_access_role_arn(self) -> Optional[builtins.str]:
        return pulumi.get(self, "secrets_manager_security_db_encryption_access_role_arn")

    @property
    @pulumi.getter(name="secretsManagerSecurityDbEncryptionSecretId")
    def secrets_manager_security_db_encryption_secret_id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "secrets_manager_security_db_encryption_secret_id")


@pulumi.output_type
class SettingsPropertiesPostgreSqlSettingsProperties(dict):
    """
    PostgreSqlSettings property identifier.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "databaseName":
            suggest = "database_name"
        elif key == "serverName":
            suggest = "server_name"
        elif key == "sslMode":
            suggest = "ssl_mode"
        elif key == "certificateArn":
            suggest = "certificate_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SettingsPropertiesPostgreSqlSettingsProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SettingsPropertiesPostgreSqlSettingsProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SettingsPropertiesPostgreSqlSettingsProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 database_name: builtins.str,
                 port: builtins.int,
                 server_name: builtins.str,
                 ssl_mode: 'DataProviderDmsSslModeValue',
                 certificate_arn: Optional[builtins.str] = None):
        """
        PostgreSqlSettings property identifier.
        """
        pulumi.set(__self__, "database_name", database_name)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "server_name", server_name)
        pulumi.set(__self__, "ssl_mode", ssl_mode)
        if certificate_arn is not None:
            pulumi.set(__self__, "certificate_arn", certificate_arn)

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> builtins.str:
        return pulumi.get(self, "database_name")

    @property
    @pulumi.getter
    def port(self) -> builtins.int:
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="serverName")
    def server_name(self) -> builtins.str:
        return pulumi.get(self, "server_name")

    @property
    @pulumi.getter(name="sslMode")
    def ssl_mode(self) -> 'DataProviderDmsSslModeValue':
        return pulumi.get(self, "ssl_mode")

    @property
    @pulumi.getter(name="certificateArn")
    def certificate_arn(self) -> Optional[builtins.str]:
        return pulumi.get(self, "certificate_arn")


@pulumi.output_type
class SettingsPropertiesRedshiftSettingsProperties(dict):
    """
    RedshiftSettings property identifier.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "databaseName":
            suggest = "database_name"
        elif key == "serverName":
            suggest = "server_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SettingsPropertiesRedshiftSettingsProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SettingsPropertiesRedshiftSettingsProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SettingsPropertiesRedshiftSettingsProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 database_name: builtins.str,
                 port: builtins.int,
                 server_name: builtins.str):
        """
        RedshiftSettings property identifier.
        """
        pulumi.set(__self__, "database_name", database_name)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "server_name", server_name)

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> builtins.str:
        return pulumi.get(self, "database_name")

    @property
    @pulumi.getter
    def port(self) -> builtins.int:
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="serverName")
    def server_name(self) -> builtins.str:
        return pulumi.get(self, "server_name")


