# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from .. import outputs as _root_outputs
from ._enums import *

__all__ = [
    'GetInstanceProfileResult',
    'AwaitableGetInstanceProfileResult',
    'get_instance_profile',
    'get_instance_profile_output',
]

@pulumi.output_type
class GetInstanceProfileResult:
    def __init__(__self__, availability_zone=None, description=None, instance_profile_arn=None, instance_profile_creation_time=None, instance_profile_name=None, kms_key_arn=None, network_type=None, publicly_accessible=None, subnet_group_identifier=None, tags=None, vpc_security_groups=None):
        if availability_zone and not isinstance(availability_zone, str):
            raise TypeError("Expected argument 'availability_zone' to be a str")
        pulumi.set(__self__, "availability_zone", availability_zone)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if instance_profile_arn and not isinstance(instance_profile_arn, str):
            raise TypeError("Expected argument 'instance_profile_arn' to be a str")
        pulumi.set(__self__, "instance_profile_arn", instance_profile_arn)
        if instance_profile_creation_time and not isinstance(instance_profile_creation_time, str):
            raise TypeError("Expected argument 'instance_profile_creation_time' to be a str")
        pulumi.set(__self__, "instance_profile_creation_time", instance_profile_creation_time)
        if instance_profile_name and not isinstance(instance_profile_name, str):
            raise TypeError("Expected argument 'instance_profile_name' to be a str")
        pulumi.set(__self__, "instance_profile_name", instance_profile_name)
        if kms_key_arn and not isinstance(kms_key_arn, str):
            raise TypeError("Expected argument 'kms_key_arn' to be a str")
        pulumi.set(__self__, "kms_key_arn", kms_key_arn)
        if network_type and not isinstance(network_type, str):
            raise TypeError("Expected argument 'network_type' to be a str")
        pulumi.set(__self__, "network_type", network_type)
        if publicly_accessible and not isinstance(publicly_accessible, bool):
            raise TypeError("Expected argument 'publicly_accessible' to be a bool")
        pulumi.set(__self__, "publicly_accessible", publicly_accessible)
        if subnet_group_identifier and not isinstance(subnet_group_identifier, str):
            raise TypeError("Expected argument 'subnet_group_identifier' to be a str")
        pulumi.set(__self__, "subnet_group_identifier", subnet_group_identifier)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if vpc_security_groups and not isinstance(vpc_security_groups, list):
            raise TypeError("Expected argument 'vpc_security_groups' to be a list")
        pulumi.set(__self__, "vpc_security_groups", vpc_security_groups)

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> Optional[builtins.str]:
        """
        The property describes an availability zone of the instance profile.
        """
        return pulumi.get(self, "availability_zone")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        The optional description of the instance profile.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="instanceProfileArn")
    def instance_profile_arn(self) -> Optional[builtins.str]:
        """
        The property describes an ARN of the instance profile.
        """
        return pulumi.get(self, "instance_profile_arn")

    @property
    @pulumi.getter(name="instanceProfileCreationTime")
    def instance_profile_creation_time(self) -> Optional[builtins.str]:
        """
        The property describes a creating time of the instance profile.
        """
        return pulumi.get(self, "instance_profile_creation_time")

    @property
    @pulumi.getter(name="instanceProfileName")
    def instance_profile_name(self) -> Optional[builtins.str]:
        """
        The property describes a name for the instance profile.
        """
        return pulumi.get(self, "instance_profile_name")

    @property
    @pulumi.getter(name="kmsKeyArn")
    def kms_key_arn(self) -> Optional[builtins.str]:
        """
        The property describes kms key arn for the instance profile.
        """
        return pulumi.get(self, "kms_key_arn")

    @property
    @pulumi.getter(name="networkType")
    def network_type(self) -> Optional['InstanceProfileNetworkType']:
        """
        The property describes a network type for the instance profile.
        """
        return pulumi.get(self, "network_type")

    @property
    @pulumi.getter(name="publiclyAccessible")
    def publicly_accessible(self) -> Optional[builtins.bool]:
        """
        The property describes the publicly accessible of the instance profile
        """
        return pulumi.get(self, "publicly_accessible")

    @property
    @pulumi.getter(name="subnetGroupIdentifier")
    def subnet_group_identifier(self) -> Optional[builtins.str]:
        """
        The property describes a subnet group identifier for the instance profile.
        """
        return pulumi.get(self, "subnet_group_identifier")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="vpcSecurityGroups")
    def vpc_security_groups(self) -> Optional[Sequence[builtins.str]]:
        """
        The property describes vps security groups for the instance profile.
        """
        return pulumi.get(self, "vpc_security_groups")


class AwaitableGetInstanceProfileResult(GetInstanceProfileResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetInstanceProfileResult(
            availability_zone=self.availability_zone,
            description=self.description,
            instance_profile_arn=self.instance_profile_arn,
            instance_profile_creation_time=self.instance_profile_creation_time,
            instance_profile_name=self.instance_profile_name,
            kms_key_arn=self.kms_key_arn,
            network_type=self.network_type,
            publicly_accessible=self.publicly_accessible,
            subnet_group_identifier=self.subnet_group_identifier,
            tags=self.tags,
            vpc_security_groups=self.vpc_security_groups)


def get_instance_profile(instance_profile_arn: Optional[builtins.str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetInstanceProfileResult:
    """
    Resource schema for AWS::DMS::InstanceProfile.


    :param builtins.str instance_profile_arn: The property describes an ARN of the instance profile.
    """
    __args__ = dict()
    __args__['instanceProfileArn'] = instance_profile_arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:dms:getInstanceProfile', __args__, opts=opts, typ=GetInstanceProfileResult).value

    return AwaitableGetInstanceProfileResult(
        availability_zone=pulumi.get(__ret__, 'availability_zone'),
        description=pulumi.get(__ret__, 'description'),
        instance_profile_arn=pulumi.get(__ret__, 'instance_profile_arn'),
        instance_profile_creation_time=pulumi.get(__ret__, 'instance_profile_creation_time'),
        instance_profile_name=pulumi.get(__ret__, 'instance_profile_name'),
        kms_key_arn=pulumi.get(__ret__, 'kms_key_arn'),
        network_type=pulumi.get(__ret__, 'network_type'),
        publicly_accessible=pulumi.get(__ret__, 'publicly_accessible'),
        subnet_group_identifier=pulumi.get(__ret__, 'subnet_group_identifier'),
        tags=pulumi.get(__ret__, 'tags'),
        vpc_security_groups=pulumi.get(__ret__, 'vpc_security_groups'))
def get_instance_profile_output(instance_profile_arn: Optional[pulumi.Input[builtins.str]] = None,
                                opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetInstanceProfileResult]:
    """
    Resource schema for AWS::DMS::InstanceProfile.


    :param builtins.str instance_profile_arn: The property describes an ARN of the instance profile.
    """
    __args__ = dict()
    __args__['instanceProfileArn'] = instance_profile_arn
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:dms:getInstanceProfile', __args__, opts=opts, typ=GetInstanceProfileResult)
    return __ret__.apply(lambda __response__: GetInstanceProfileResult(
        availability_zone=pulumi.get(__response__, 'availability_zone'),
        description=pulumi.get(__response__, 'description'),
        instance_profile_arn=pulumi.get(__response__, 'instance_profile_arn'),
        instance_profile_creation_time=pulumi.get(__response__, 'instance_profile_creation_time'),
        instance_profile_name=pulumi.get(__response__, 'instance_profile_name'),
        kms_key_arn=pulumi.get(__response__, 'kms_key_arn'),
        network_type=pulumi.get(__response__, 'network_type'),
        publicly_accessible=pulumi.get(__response__, 'publicly_accessible'),
        subnet_group_identifier=pulumi.get(__response__, 'subnet_group_identifier'),
        tags=pulumi.get(__response__, 'tags'),
        vpc_security_groups=pulumi.get(__response__, 'vpc_security_groups')))
