# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import outputs as _root_outputs
from ._enums import *

__all__ = [
    'GetDataProviderResult',
    'AwaitableGetDataProviderResult',
    'get_data_provider',
    'get_data_provider_output',
]

@pulumi.output_type
class GetDataProviderResult:
    def __init__(__self__, data_provider_arn=None, data_provider_creation_time=None, data_provider_name=None, description=None, engine=None, settings=None, tags=None):
        if data_provider_arn and not isinstance(data_provider_arn, str):
            raise TypeError("Expected argument 'data_provider_arn' to be a str")
        pulumi.set(__self__, "data_provider_arn", data_provider_arn)
        if data_provider_creation_time and not isinstance(data_provider_creation_time, str):
            raise TypeError("Expected argument 'data_provider_creation_time' to be a str")
        pulumi.set(__self__, "data_provider_creation_time", data_provider_creation_time)
        if data_provider_name and not isinstance(data_provider_name, str):
            raise TypeError("Expected argument 'data_provider_name' to be a str")
        pulumi.set(__self__, "data_provider_name", data_provider_name)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if engine and not isinstance(engine, str):
            raise TypeError("Expected argument 'engine' to be a str")
        pulumi.set(__self__, "engine", engine)
        if settings and not isinstance(settings, dict):
            raise TypeError("Expected argument 'settings' to be a dict")
        pulumi.set(__self__, "settings", settings)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="dataProviderArn")
    def data_provider_arn(self) -> Optional[builtins.str]:
        """
        The data provider ARN.
        """
        return pulumi.get(self, "data_provider_arn")

    @property
    @pulumi.getter(name="dataProviderCreationTime")
    def data_provider_creation_time(self) -> Optional[builtins.str]:
        """
        The data provider creation time.
        """
        return pulumi.get(self, "data_provider_creation_time")

    @property
    @pulumi.getter(name="dataProviderName")
    def data_provider_name(self) -> Optional[builtins.str]:
        """
        The property describes a name to identify the data provider.
        """
        return pulumi.get(self, "data_provider_name")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        The optional description of the data provider.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def engine(self) -> Optional['DataProviderEngine']:
        """
        The property describes a data engine for the data provider.
        """
        return pulumi.get(self, "engine")

    @property
    @pulumi.getter
    def settings(self) -> Optional['outputs.SettingsProperties']:
        """
        The property identifies the exact type of settings for the data provider.
        """
        return pulumi.get(self, "settings")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")


class AwaitableGetDataProviderResult(GetDataProviderResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDataProviderResult(
            data_provider_arn=self.data_provider_arn,
            data_provider_creation_time=self.data_provider_creation_time,
            data_provider_name=self.data_provider_name,
            description=self.description,
            engine=self.engine,
            settings=self.settings,
            tags=self.tags)


def get_data_provider(data_provider_arn: Optional[builtins.str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDataProviderResult:
    """
    Resource schema for AWS::DMS::DataProvider


    :param builtins.str data_provider_arn: The data provider ARN.
    """
    __args__ = dict()
    __args__['dataProviderArn'] = data_provider_arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:dms:getDataProvider', __args__, opts=opts, typ=GetDataProviderResult).value

    return AwaitableGetDataProviderResult(
        data_provider_arn=pulumi.get(__ret__, 'data_provider_arn'),
        data_provider_creation_time=pulumi.get(__ret__, 'data_provider_creation_time'),
        data_provider_name=pulumi.get(__ret__, 'data_provider_name'),
        description=pulumi.get(__ret__, 'description'),
        engine=pulumi.get(__ret__, 'engine'),
        settings=pulumi.get(__ret__, 'settings'),
        tags=pulumi.get(__ret__, 'tags'))
def get_data_provider_output(data_provider_arn: Optional[pulumi.Input[builtins.str]] = None,
                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDataProviderResult]:
    """
    Resource schema for AWS::DMS::DataProvider


    :param builtins.str data_provider_arn: The data provider ARN.
    """
    __args__ = dict()
    __args__['dataProviderArn'] = data_provider_arn
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:dms:getDataProvider', __args__, opts=opts, typ=GetDataProviderResult)
    return __ret__.apply(lambda __response__: GetDataProviderResult(
        data_provider_arn=pulumi.get(__response__, 'data_provider_arn'),
        data_provider_creation_time=pulumi.get(__response__, 'data_provider_creation_time'),
        data_provider_name=pulumi.get(__response__, 'data_provider_name'),
        description=pulumi.get(__response__, 'description'),
        engine=pulumi.get(__response__, 'engine'),
        settings=pulumi.get(__response__, 'settings'),
        tags=pulumi.get(__response__, 'tags')))
