# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._enums import *
from ._inputs import *

__all__ = ['DataProviderArgs', 'DataProvider']

@pulumi.input_type
class DataProviderArgs:
    def __init__(__self__, *,
                 engine: pulumi.Input['DataProviderEngine'],
                 data_provider_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 data_provider_name: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 exact_settings: Optional[pulumi.Input[builtins.bool]] = None,
                 settings: Optional[pulumi.Input['SettingsPropertiesArgs']] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None):
        """
        The set of arguments for constructing a DataProvider resource.
        :param pulumi.Input['DataProviderEngine'] engine: The property describes a data engine for the data provider.
        :param pulumi.Input[builtins.str] data_provider_identifier: The property describes an identifier for the data provider. It is used for describing/deleting/modifying can be name/arn
        :param pulumi.Input[builtins.str] data_provider_name: The property describes a name to identify the data provider.
        :param pulumi.Input[builtins.str] description: The optional description of the data provider.
        :param pulumi.Input[builtins.bool] exact_settings: The property describes the exact settings which can be modified
        :param pulumi.Input['SettingsPropertiesArgs'] settings: The property identifies the exact type of settings for the data provider.
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: An array of key-value pairs to apply to this resource.
        """
        pulumi.set(__self__, "engine", engine)
        if data_provider_identifier is not None:
            pulumi.set(__self__, "data_provider_identifier", data_provider_identifier)
        if data_provider_name is not None:
            pulumi.set(__self__, "data_provider_name", data_provider_name)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if exact_settings is not None:
            pulumi.set(__self__, "exact_settings", exact_settings)
        if settings is not None:
            pulumi.set(__self__, "settings", settings)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def engine(self) -> pulumi.Input['DataProviderEngine']:
        """
        The property describes a data engine for the data provider.
        """
        return pulumi.get(self, "engine")

    @engine.setter
    def engine(self, value: pulumi.Input['DataProviderEngine']):
        pulumi.set(self, "engine", value)

    @property
    @pulumi.getter(name="dataProviderIdentifier")
    def data_provider_identifier(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The property describes an identifier for the data provider. It is used for describing/deleting/modifying can be name/arn
        """
        return pulumi.get(self, "data_provider_identifier")

    @data_provider_identifier.setter
    def data_provider_identifier(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "data_provider_identifier", value)

    @property
    @pulumi.getter(name="dataProviderName")
    def data_provider_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The property describes a name to identify the data provider.
        """
        return pulumi.get(self, "data_provider_name")

    @data_provider_name.setter
    def data_provider_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "data_provider_name", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The optional description of the data provider.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="exactSettings")
    def exact_settings(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        The property describes the exact settings which can be modified
        """
        return pulumi.get(self, "exact_settings")

    @exact_settings.setter
    def exact_settings(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "exact_settings", value)

    @property
    @pulumi.getter
    def settings(self) -> Optional[pulumi.Input['SettingsPropertiesArgs']]:
        """
        The property identifies the exact type of settings for the data provider.
        """
        return pulumi.get(self, "settings")

    @settings.setter
    def settings(self, value: Optional[pulumi.Input['SettingsPropertiesArgs']]):
        pulumi.set(self, "settings", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("aws-native:dms:DataProvider")
class DataProvider(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 data_provider_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 data_provider_name: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 engine: Optional[pulumi.Input['DataProviderEngine']] = None,
                 exact_settings: Optional[pulumi.Input[builtins.bool]] = None,
                 settings: Optional[pulumi.Input[Union['SettingsPropertiesArgs', 'SettingsPropertiesArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        """
        Resource schema for AWS::DMS::DataProvider

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] data_provider_identifier: The property describes an identifier for the data provider. It is used for describing/deleting/modifying can be name/arn
        :param pulumi.Input[builtins.str] data_provider_name: The property describes a name to identify the data provider.
        :param pulumi.Input[builtins.str] description: The optional description of the data provider.
        :param pulumi.Input['DataProviderEngine'] engine: The property describes a data engine for the data provider.
        :param pulumi.Input[builtins.bool] exact_settings: The property describes the exact settings which can be modified
        :param pulumi.Input[Union['SettingsPropertiesArgs', 'SettingsPropertiesArgsDict']] settings: The property identifies the exact type of settings for the data provider.
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: An array of key-value pairs to apply to this resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DataProviderArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource schema for AWS::DMS::DataProvider

        :param str resource_name: The name of the resource.
        :param DataProviderArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DataProviderArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 data_provider_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 data_provider_name: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 engine: Optional[pulumi.Input['DataProviderEngine']] = None,
                 exact_settings: Optional[pulumi.Input[builtins.bool]] = None,
                 settings: Optional[pulumi.Input[Union['SettingsPropertiesArgs', 'SettingsPropertiesArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DataProviderArgs.__new__(DataProviderArgs)

            __props__.__dict__["data_provider_identifier"] = data_provider_identifier
            __props__.__dict__["data_provider_name"] = data_provider_name
            __props__.__dict__["description"] = description
            if engine is None and not opts.urn:
                raise TypeError("Missing required property 'engine'")
            __props__.__dict__["engine"] = engine
            __props__.__dict__["exact_settings"] = exact_settings
            __props__.__dict__["settings"] = settings
            __props__.__dict__["tags"] = tags
            __props__.__dict__["data_provider_arn"] = None
            __props__.__dict__["data_provider_creation_time"] = None
        super(DataProvider, __self__).__init__(
            'aws-native:dms:DataProvider',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'DataProvider':
        """
        Get an existing DataProvider resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = DataProviderArgs.__new__(DataProviderArgs)

        __props__.__dict__["data_provider_arn"] = None
        __props__.__dict__["data_provider_creation_time"] = None
        __props__.__dict__["data_provider_identifier"] = None
        __props__.__dict__["data_provider_name"] = None
        __props__.__dict__["description"] = None
        __props__.__dict__["engine"] = None
        __props__.__dict__["exact_settings"] = None
        __props__.__dict__["settings"] = None
        __props__.__dict__["tags"] = None
        return DataProvider(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="dataProviderArn")
    def data_provider_arn(self) -> pulumi.Output[builtins.str]:
        """
        The data provider ARN.
        """
        return pulumi.get(self, "data_provider_arn")

    @property
    @pulumi.getter(name="dataProviderCreationTime")
    def data_provider_creation_time(self) -> pulumi.Output[builtins.str]:
        """
        The data provider creation time.
        """
        return pulumi.get(self, "data_provider_creation_time")

    @property
    @pulumi.getter(name="dataProviderIdentifier")
    def data_provider_identifier(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The property describes an identifier for the data provider. It is used for describing/deleting/modifying can be name/arn
        """
        return pulumi.get(self, "data_provider_identifier")

    @property
    @pulumi.getter(name="dataProviderName")
    def data_provider_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The property describes a name to identify the data provider.
        """
        return pulumi.get(self, "data_provider_name")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The optional description of the data provider.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def engine(self) -> pulumi.Output['DataProviderEngine']:
        """
        The property describes a data engine for the data provider.
        """
        return pulumi.get(self, "engine")

    @property
    @pulumi.getter(name="exactSettings")
    def exact_settings(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        The property describes the exact settings which can be modified
        """
        return pulumi.get(self, "exact_settings")

    @property
    @pulumi.getter
    def settings(self) -> pulumi.Output[Optional['outputs.SettingsProperties']]:
        """
        The property identifies the exact type of settings for the data provider.
        """
        return pulumi.get(self, "settings")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")

