# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._enums import *
from ._inputs import *

__all__ = ['DataMigrationArgs', 'DataMigration']

@pulumi.input_type
class DataMigrationArgs:
    def __init__(__self__, *,
                 data_migration_type: pulumi.Input['DataMigrationType'],
                 migration_project_identifier: pulumi.Input[builtins.str],
                 service_access_role_arn: pulumi.Input[builtins.str],
                 data_migration_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 data_migration_name: Optional[pulumi.Input[builtins.str]] = None,
                 data_migration_settings: Optional[pulumi.Input['DataMigrationSettingsArgs']] = None,
                 source_data_settings: Optional[pulumi.Input[Sequence[pulumi.Input['DataMigrationSourceDataSettingsArgs']]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None):
        """
        The set of arguments for constructing a DataMigration resource.
        :param pulumi.Input['DataMigrationType'] data_migration_type: The property describes the type of migration.
        :param pulumi.Input[builtins.str] migration_project_identifier: The property describes an identifier for the migration project. It is used for describing/deleting/modifying can be name/arn
        :param pulumi.Input[builtins.str] service_access_role_arn: The property describes Amazon Resource Name (ARN) of the service access role.
        :param pulumi.Input[builtins.str] data_migration_identifier: The property describes an ARN of the data migration.
        :param pulumi.Input[builtins.str] data_migration_name: The property describes a name to identify the data migration.
        :param pulumi.Input['DataMigrationSettingsArgs'] data_migration_settings: The property describes the settings for the data migration.
        :param pulumi.Input[Sequence[pulumi.Input['DataMigrationSourceDataSettingsArgs']]] source_data_settings: The property describes the settings for the data migration.
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: An array of key-value pairs to apply to this resource.
        """
        pulumi.set(__self__, "data_migration_type", data_migration_type)
        pulumi.set(__self__, "migration_project_identifier", migration_project_identifier)
        pulumi.set(__self__, "service_access_role_arn", service_access_role_arn)
        if data_migration_identifier is not None:
            pulumi.set(__self__, "data_migration_identifier", data_migration_identifier)
        if data_migration_name is not None:
            pulumi.set(__self__, "data_migration_name", data_migration_name)
        if data_migration_settings is not None:
            pulumi.set(__self__, "data_migration_settings", data_migration_settings)
        if source_data_settings is not None:
            pulumi.set(__self__, "source_data_settings", source_data_settings)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="dataMigrationType")
    def data_migration_type(self) -> pulumi.Input['DataMigrationType']:
        """
        The property describes the type of migration.
        """
        return pulumi.get(self, "data_migration_type")

    @data_migration_type.setter
    def data_migration_type(self, value: pulumi.Input['DataMigrationType']):
        pulumi.set(self, "data_migration_type", value)

    @property
    @pulumi.getter(name="migrationProjectIdentifier")
    def migration_project_identifier(self) -> pulumi.Input[builtins.str]:
        """
        The property describes an identifier for the migration project. It is used for describing/deleting/modifying can be name/arn
        """
        return pulumi.get(self, "migration_project_identifier")

    @migration_project_identifier.setter
    def migration_project_identifier(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "migration_project_identifier", value)

    @property
    @pulumi.getter(name="serviceAccessRoleArn")
    def service_access_role_arn(self) -> pulumi.Input[builtins.str]:
        """
        The property describes Amazon Resource Name (ARN) of the service access role.
        """
        return pulumi.get(self, "service_access_role_arn")

    @service_access_role_arn.setter
    def service_access_role_arn(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "service_access_role_arn", value)

    @property
    @pulumi.getter(name="dataMigrationIdentifier")
    def data_migration_identifier(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The property describes an ARN of the data migration.
        """
        return pulumi.get(self, "data_migration_identifier")

    @data_migration_identifier.setter
    def data_migration_identifier(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "data_migration_identifier", value)

    @property
    @pulumi.getter(name="dataMigrationName")
    def data_migration_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The property describes a name to identify the data migration.
        """
        return pulumi.get(self, "data_migration_name")

    @data_migration_name.setter
    def data_migration_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "data_migration_name", value)

    @property
    @pulumi.getter(name="dataMigrationSettings")
    def data_migration_settings(self) -> Optional[pulumi.Input['DataMigrationSettingsArgs']]:
        """
        The property describes the settings for the data migration.
        """
        return pulumi.get(self, "data_migration_settings")

    @data_migration_settings.setter
    def data_migration_settings(self, value: Optional[pulumi.Input['DataMigrationSettingsArgs']]):
        pulumi.set(self, "data_migration_settings", value)

    @property
    @pulumi.getter(name="sourceDataSettings")
    def source_data_settings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DataMigrationSourceDataSettingsArgs']]]]:
        """
        The property describes the settings for the data migration.
        """
        return pulumi.get(self, "source_data_settings")

    @source_data_settings.setter
    def source_data_settings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DataMigrationSourceDataSettingsArgs']]]]):
        pulumi.set(self, "source_data_settings", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("aws-native:dms:DataMigration")
class DataMigration(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 data_migration_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 data_migration_name: Optional[pulumi.Input[builtins.str]] = None,
                 data_migration_settings: Optional[pulumi.Input[Union['DataMigrationSettingsArgs', 'DataMigrationSettingsArgsDict']]] = None,
                 data_migration_type: Optional[pulumi.Input['DataMigrationType']] = None,
                 migration_project_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 service_access_role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 source_data_settings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DataMigrationSourceDataSettingsArgs', 'DataMigrationSourceDataSettingsArgsDict']]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        """
        Resource schema for AWS::DMS::DataMigration.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] data_migration_identifier: The property describes an ARN of the data migration.
        :param pulumi.Input[builtins.str] data_migration_name: The property describes a name to identify the data migration.
        :param pulumi.Input[Union['DataMigrationSettingsArgs', 'DataMigrationSettingsArgsDict']] data_migration_settings: The property describes the settings for the data migration.
        :param pulumi.Input['DataMigrationType'] data_migration_type: The property describes the type of migration.
        :param pulumi.Input[builtins.str] migration_project_identifier: The property describes an identifier for the migration project. It is used for describing/deleting/modifying can be name/arn
        :param pulumi.Input[builtins.str] service_access_role_arn: The property describes Amazon Resource Name (ARN) of the service access role.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DataMigrationSourceDataSettingsArgs', 'DataMigrationSourceDataSettingsArgsDict']]]] source_data_settings: The property describes the settings for the data migration.
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: An array of key-value pairs to apply to this resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DataMigrationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource schema for AWS::DMS::DataMigration.

        :param str resource_name: The name of the resource.
        :param DataMigrationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DataMigrationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 data_migration_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 data_migration_name: Optional[pulumi.Input[builtins.str]] = None,
                 data_migration_settings: Optional[pulumi.Input[Union['DataMigrationSettingsArgs', 'DataMigrationSettingsArgsDict']]] = None,
                 data_migration_type: Optional[pulumi.Input['DataMigrationType']] = None,
                 migration_project_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 service_access_role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 source_data_settings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DataMigrationSourceDataSettingsArgs', 'DataMigrationSourceDataSettingsArgsDict']]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DataMigrationArgs.__new__(DataMigrationArgs)

            __props__.__dict__["data_migration_identifier"] = data_migration_identifier
            __props__.__dict__["data_migration_name"] = data_migration_name
            __props__.__dict__["data_migration_settings"] = data_migration_settings
            if data_migration_type is None and not opts.urn:
                raise TypeError("Missing required property 'data_migration_type'")
            __props__.__dict__["data_migration_type"] = data_migration_type
            if migration_project_identifier is None and not opts.urn:
                raise TypeError("Missing required property 'migration_project_identifier'")
            __props__.__dict__["migration_project_identifier"] = migration_project_identifier
            if service_access_role_arn is None and not opts.urn:
                raise TypeError("Missing required property 'service_access_role_arn'")
            __props__.__dict__["service_access_role_arn"] = service_access_role_arn
            __props__.__dict__["source_data_settings"] = source_data_settings
            __props__.__dict__["tags"] = tags
            __props__.__dict__["data_migration_arn"] = None
            __props__.__dict__["data_migration_create_time"] = None
        super(DataMigration, __self__).__init__(
            'aws-native:dms:DataMigration',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'DataMigration':
        """
        Get an existing DataMigration resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = DataMigrationArgs.__new__(DataMigrationArgs)

        __props__.__dict__["data_migration_arn"] = None
        __props__.__dict__["data_migration_create_time"] = None
        __props__.__dict__["data_migration_identifier"] = None
        __props__.__dict__["data_migration_name"] = None
        __props__.__dict__["data_migration_settings"] = None
        __props__.__dict__["data_migration_type"] = None
        __props__.__dict__["migration_project_identifier"] = None
        __props__.__dict__["service_access_role_arn"] = None
        __props__.__dict__["source_data_settings"] = None
        __props__.__dict__["tags"] = None
        return DataMigration(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="dataMigrationArn")
    def data_migration_arn(self) -> pulumi.Output[builtins.str]:
        """
        The property describes an ARN of the data migration.
        """
        return pulumi.get(self, "data_migration_arn")

    @property
    @pulumi.getter(name="dataMigrationCreateTime")
    def data_migration_create_time(self) -> pulumi.Output[builtins.str]:
        """
        The property describes the create time of the data migration.
        """
        return pulumi.get(self, "data_migration_create_time")

    @property
    @pulumi.getter(name="dataMigrationIdentifier")
    def data_migration_identifier(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The property describes an ARN of the data migration.
        """
        return pulumi.get(self, "data_migration_identifier")

    @property
    @pulumi.getter(name="dataMigrationName")
    def data_migration_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The property describes a name to identify the data migration.
        """
        return pulumi.get(self, "data_migration_name")

    @property
    @pulumi.getter(name="dataMigrationSettings")
    def data_migration_settings(self) -> pulumi.Output[Optional['outputs.DataMigrationSettings']]:
        """
        The property describes the settings for the data migration.
        """
        return pulumi.get(self, "data_migration_settings")

    @property
    @pulumi.getter(name="dataMigrationType")
    def data_migration_type(self) -> pulumi.Output['DataMigrationType']:
        """
        The property describes the type of migration.
        """
        return pulumi.get(self, "data_migration_type")

    @property
    @pulumi.getter(name="migrationProjectIdentifier")
    def migration_project_identifier(self) -> pulumi.Output[builtins.str]:
        """
        The property describes an identifier for the migration project. It is used for describing/deleting/modifying can be name/arn
        """
        return pulumi.get(self, "migration_project_identifier")

    @property
    @pulumi.getter(name="serviceAccessRoleArn")
    def service_access_role_arn(self) -> pulumi.Output[builtins.str]:
        """
        The property describes Amazon Resource Name (ARN) of the service access role.
        """
        return pulumi.get(self, "service_access_role_arn")

    @property
    @pulumi.getter(name="sourceDataSettings")
    def source_data_settings(self) -> pulumi.Output[Optional[Sequence['outputs.DataMigrationSourceDataSettings']]]:
        """
        The property describes the settings for the data migration.
        """
        return pulumi.get(self, "source_data_settings")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")

