# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'GetResourceCollectionResult',
    'AwaitableGetResourceCollectionResult',
    'get_resource_collection',
    'get_resource_collection_output',
]

@pulumi.output_type
class GetResourceCollectionResult:
    def __init__(__self__, resource_collection_filter=None, resource_collection_type=None):
        if resource_collection_filter and not isinstance(resource_collection_filter, dict):
            raise TypeError("Expected argument 'resource_collection_filter' to be a dict")
        pulumi.set(__self__, "resource_collection_filter", resource_collection_filter)
        if resource_collection_type and not isinstance(resource_collection_type, str):
            raise TypeError("Expected argument 'resource_collection_type' to be a str")
        pulumi.set(__self__, "resource_collection_type", resource_collection_type)

    @property
    @pulumi.getter(name="resourceCollectionFilter")
    def resource_collection_filter(self) -> Optional['outputs.ResourceCollectionFilter']:
        """
        Information about a filter used to specify which AWS resources are analyzed for anomalous behavior by DevOps Guru.
        """
        return pulumi.get(self, "resource_collection_filter")

    @property
    @pulumi.getter(name="resourceCollectionType")
    def resource_collection_type(self) -> Optional['ResourceCollectionType']:
        """
        The type of ResourceCollection
        """
        return pulumi.get(self, "resource_collection_type")


class AwaitableGetResourceCollectionResult(GetResourceCollectionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetResourceCollectionResult(
            resource_collection_filter=self.resource_collection_filter,
            resource_collection_type=self.resource_collection_type)


def get_resource_collection(resource_collection_type: Optional['ResourceCollectionType'] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetResourceCollectionResult:
    """
    This resource schema represents the ResourceCollection resource in the Amazon DevOps Guru.


    :param 'ResourceCollectionType' resource_collection_type: The type of ResourceCollection
    """
    __args__ = dict()
    __args__['resourceCollectionType'] = resource_collection_type
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:devopsguru:getResourceCollection', __args__, opts=opts, typ=GetResourceCollectionResult).value

    return AwaitableGetResourceCollectionResult(
        resource_collection_filter=pulumi.get(__ret__, 'resource_collection_filter'),
        resource_collection_type=pulumi.get(__ret__, 'resource_collection_type'))
def get_resource_collection_output(resource_collection_type: Optional[pulumi.Input['ResourceCollectionType']] = None,
                                   opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetResourceCollectionResult]:
    """
    This resource schema represents the ResourceCollection resource in the Amazon DevOps Guru.


    :param 'ResourceCollectionType' resource_collection_type: The type of ResourceCollection
    """
    __args__ = dict()
    __args__['resourceCollectionType'] = resource_collection_type
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:devopsguru:getResourceCollection', __args__, opts=opts, typ=GetResourceCollectionResult)
    return __ret__.apply(lambda __response__: GetResourceCollectionResult(
        resource_collection_filter=pulumi.get(__response__, 'resource_collection_filter'),
        resource_collection_type=pulumi.get(__response__, 'resource_collection_type')))
