# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs

__all__ = ['GraphArgs', 'Graph']

@pulumi.input_type
class GraphArgs:
    def __init__(__self__, *,
                 auto_enable_members: Optional[pulumi.Input[builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None):
        """
        The set of arguments for constructing a Graph resource.
        :param pulumi.Input[builtins.bool] auto_enable_members: Indicates whether to automatically enable new organization accounts as member accounts in the organization behavior graph.
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: The tag values to assign to the new behavior graph.
        """
        if auto_enable_members is not None:
            pulumi.set(__self__, "auto_enable_members", auto_enable_members)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="autoEnableMembers")
    def auto_enable_members(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Indicates whether to automatically enable new organization accounts as member accounts in the organization behavior graph.
        """
        return pulumi.get(self, "auto_enable_members")

    @auto_enable_members.setter
    def auto_enable_members(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "auto_enable_members", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        The tag values to assign to the new behavior graph.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("aws-native:detective:Graph")
class Graph(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_enable_members: Optional[pulumi.Input[builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        """
        Resource schema for AWS::Detective::Graph

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] auto_enable_members: Indicates whether to automatically enable new organization accounts as member accounts in the organization behavior graph.
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: The tag values to assign to the new behavior graph.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[GraphArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource schema for AWS::Detective::Graph

        :param str resource_name: The name of the resource.
        :param GraphArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GraphArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_enable_members: Optional[pulumi.Input[builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GraphArgs.__new__(GraphArgs)

            __props__.__dict__["auto_enable_members"] = auto_enable_members
            __props__.__dict__["tags"] = tags
            __props__.__dict__["arn"] = None
        super(Graph, __self__).__init__(
            'aws-native:detective:Graph',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Graph':
        """
        Get an existing Graph resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = GraphArgs.__new__(GraphArgs)

        __props__.__dict__["arn"] = None
        __props__.__dict__["auto_enable_members"] = None
        __props__.__dict__["tags"] = None
        return Graph(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[builtins.str]:
        """
        The Detective graph ARN
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="autoEnableMembers")
    def auto_enable_members(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Indicates whether to automatically enable new organization accounts as member accounts in the organization behavior graph.
        """
        return pulumi.get(self, "auto_enable_members")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        The tag values to assign to the new behavior graph.
        """
        return pulumi.get(self, "tags")

