# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from .. import outputs as _root_outputs

__all__ = [
    'GetGraphResult',
    'AwaitableGetGraphResult',
    'get_graph',
    'get_graph_output',
]

@pulumi.output_type
class GetGraphResult:
    def __init__(__self__, arn=None, auto_enable_members=None, tags=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if auto_enable_members and not isinstance(auto_enable_members, bool):
            raise TypeError("Expected argument 'auto_enable_members' to be a bool")
        pulumi.set(__self__, "auto_enable_members", auto_enable_members)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def arn(self) -> Optional[builtins.str]:
        """
        The Detective graph ARN
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="autoEnableMembers")
    def auto_enable_members(self) -> Optional[builtins.bool]:
        """
        Indicates whether to automatically enable new organization accounts as member accounts in the organization behavior graph.
        """
        return pulumi.get(self, "auto_enable_members")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        The tag values to assign to the new behavior graph.
        """
        return pulumi.get(self, "tags")


class AwaitableGetGraphResult(GetGraphResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetGraphResult(
            arn=self.arn,
            auto_enable_members=self.auto_enable_members,
            tags=self.tags)


def get_graph(arn: Optional[builtins.str] = None,
              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetGraphResult:
    """
    Resource schema for AWS::Detective::Graph


    :param builtins.str arn: The Detective graph ARN
    """
    __args__ = dict()
    __args__['arn'] = arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:detective:getGraph', __args__, opts=opts, typ=GetGraphResult).value

    return AwaitableGetGraphResult(
        arn=pulumi.get(__ret__, 'arn'),
        auto_enable_members=pulumi.get(__ret__, 'auto_enable_members'),
        tags=pulumi.get(__ret__, 'tags'))
def get_graph_output(arn: Optional[pulumi.Input[builtins.str]] = None,
                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetGraphResult]:
    """
    Resource schema for AWS::Detective::Graph


    :param builtins.str arn: The Detective graph ARN
    """
    __args__ = dict()
    __args__['arn'] = arn
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:detective:getGraph', __args__, opts=opts, typ=GetGraphResult)
    return __ret__.apply(lambda __response__: GetGraphResult(
        arn=pulumi.get(__response__, 'arn'),
        auto_enable_members=pulumi.get(__response__, 'auto_enable_members'),
        tags=pulumi.get(__response__, 'tags')))
