# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['MonitorArgs', 'Monitor']

@pulumi.input_type
class MonitorArgs:
    def __init__(__self__, *,
                 display_name: pulumi.Input[builtins.str],
                 identity_center_instance_arn: pulumi.Input[builtins.str],
                 role_arn: pulumi.Input[builtins.str],
                 subdomain: pulumi.Input[builtins.str]):
        """
        The set of arguments for constructing a Monitor resource.
        :param pulumi.Input[builtins.str] display_name: The name of the monitor that displays on the Deadline Cloud console.
               
               > This field can store any content. Escape or encode this content before displaying it on a webpage or any other system that might interpret the content of this field.
        :param pulumi.Input[builtins.str] identity_center_instance_arn: The Amazon Resource Name (ARN) of the IAM Identity Center instance responsible for authenticating monitor users.
        :param pulumi.Input[builtins.str] role_arn: The Amazon Resource Name (ARN) of the IAM role for the monitor. Users of the monitor use this role to access Deadline Cloud resources.
        :param pulumi.Input[builtins.str] subdomain: The subdomain used for the monitor URL. The full URL of the monitor is subdomain.Region.deadlinecloud.amazonaws.com.
        """
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "identity_center_instance_arn", identity_center_instance_arn)
        pulumi.set(__self__, "role_arn", role_arn)
        pulumi.set(__self__, "subdomain", subdomain)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the monitor that displays on the Deadline Cloud console.

        > This field can store any content. Escape or encode this content before displaying it on a webpage or any other system that might interpret the content of this field.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="identityCenterInstanceArn")
    def identity_center_instance_arn(self) -> pulumi.Input[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the IAM Identity Center instance responsible for authenticating monitor users.
        """
        return pulumi.get(self, "identity_center_instance_arn")

    @identity_center_instance_arn.setter
    def identity_center_instance_arn(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "identity_center_instance_arn", value)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Input[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the IAM role for the monitor. Users of the monitor use this role to access Deadline Cloud resources.
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "role_arn", value)

    @property
    @pulumi.getter
    def subdomain(self) -> pulumi.Input[builtins.str]:
        """
        The subdomain used for the monitor URL. The full URL of the monitor is subdomain.Region.deadlinecloud.amazonaws.com.
        """
        return pulumi.get(self, "subdomain")

    @subdomain.setter
    def subdomain(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "subdomain", value)


@pulumi.type_token("aws-native:deadline:Monitor")
class Monitor(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 identity_center_instance_arn: Optional[pulumi.Input[builtins.str]] = None,
                 role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 subdomain: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Definition of AWS::Deadline::Monitor Resource Type

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] display_name: The name of the monitor that displays on the Deadline Cloud console.
               
               > This field can store any content. Escape or encode this content before displaying it on a webpage or any other system that might interpret the content of this field.
        :param pulumi.Input[builtins.str] identity_center_instance_arn: The Amazon Resource Name (ARN) of the IAM Identity Center instance responsible for authenticating monitor users.
        :param pulumi.Input[builtins.str] role_arn: The Amazon Resource Name (ARN) of the IAM role for the monitor. Users of the monitor use this role to access Deadline Cloud resources.
        :param pulumi.Input[builtins.str] subdomain: The subdomain used for the monitor URL. The full URL of the monitor is subdomain.Region.deadlinecloud.amazonaws.com.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MonitorArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Definition of AWS::Deadline::Monitor Resource Type

        :param str resource_name: The name of the resource.
        :param MonitorArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MonitorArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 identity_center_instance_arn: Optional[pulumi.Input[builtins.str]] = None,
                 role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 subdomain: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MonitorArgs.__new__(MonitorArgs)

            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            if identity_center_instance_arn is None and not opts.urn:
                raise TypeError("Missing required property 'identity_center_instance_arn'")
            __props__.__dict__["identity_center_instance_arn"] = identity_center_instance_arn
            if role_arn is None and not opts.urn:
                raise TypeError("Missing required property 'role_arn'")
            __props__.__dict__["role_arn"] = role_arn
            if subdomain is None and not opts.urn:
                raise TypeError("Missing required property 'subdomain'")
            __props__.__dict__["subdomain"] = subdomain
            __props__.__dict__["arn"] = None
            __props__.__dict__["identity_center_application_arn"] = None
            __props__.__dict__["monitor_id"] = None
            __props__.__dict__["url"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["identityCenterInstanceArn"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(Monitor, __self__).__init__(
            'aws-native:deadline:Monitor',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Monitor':
        """
        Get an existing Monitor resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = MonitorArgs.__new__(MonitorArgs)

        __props__.__dict__["arn"] = None
        __props__.__dict__["display_name"] = None
        __props__.__dict__["identity_center_application_arn"] = None
        __props__.__dict__["identity_center_instance_arn"] = None
        __props__.__dict__["monitor_id"] = None
        __props__.__dict__["role_arn"] = None
        __props__.__dict__["subdomain"] = None
        __props__.__dict__["url"] = None
        return Monitor(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the monitor.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the monitor that displays on the Deadline Cloud console.

        > This field can store any content. Escape or encode this content before displaying it on a webpage or any other system that might interpret the content of this field.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="identityCenterApplicationArn")
    def identity_center_application_arn(self) -> pulumi.Output[builtins.str]:
        """
        The Amazon Resource Name (ARN) that the IAM Identity Center assigned to the monitor when it was created.
        """
        return pulumi.get(self, "identity_center_application_arn")

    @property
    @pulumi.getter(name="identityCenterInstanceArn")
    def identity_center_instance_arn(self) -> pulumi.Output[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the IAM Identity Center instance responsible for authenticating monitor users.
        """
        return pulumi.get(self, "identity_center_instance_arn")

    @property
    @pulumi.getter(name="monitorId")
    def monitor_id(self) -> pulumi.Output[builtins.str]:
        """
        The unique identifier for the monitor.
        """
        return pulumi.get(self, "monitor_id")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Output[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the IAM role for the monitor. Users of the monitor use this role to access Deadline Cloud resources.
        """
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter
    def subdomain(self) -> pulumi.Output[builtins.str]:
        """
        The subdomain used for the monitor URL. The full URL of the monitor is subdomain.Region.deadlinecloud.amazonaws.com.
        """
        return pulumi.get(self, "subdomain")

    @property
    @pulumi.getter
    def url(self) -> pulumi.Output[builtins.str]:
        """
        The complete URL of the monitor. The full URL of the monitor is subdomain.Region.deadlinecloud.amazonaws.com.
        """
        return pulumi.get(self, "url")

