# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['MeteredProductArgs', 'MeteredProduct']

@pulumi.input_type
class MeteredProductArgs:
    def __init__(__self__, *,
                 license_endpoint_id: Optional[pulumi.Input[builtins.str]] = None,
                 product_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a MeteredProduct resource.
        :param pulumi.Input[builtins.str] license_endpoint_id: The Amazon EC2 identifier of the license endpoint.
        :param pulumi.Input[builtins.str] product_id: The product ID.
        """
        if license_endpoint_id is not None:
            pulumi.set(__self__, "license_endpoint_id", license_endpoint_id)
        if product_id is not None:
            pulumi.set(__self__, "product_id", product_id)

    @property
    @pulumi.getter(name="licenseEndpointId")
    def license_endpoint_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Amazon EC2 identifier of the license endpoint.
        """
        return pulumi.get(self, "license_endpoint_id")

    @license_endpoint_id.setter
    def license_endpoint_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "license_endpoint_id", value)

    @property
    @pulumi.getter(name="productId")
    def product_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The product ID.
        """
        return pulumi.get(self, "product_id")

    @product_id.setter
    def product_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "product_id", value)


@pulumi.type_token("aws-native:deadline:MeteredProduct")
class MeteredProduct(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 license_endpoint_id: Optional[pulumi.Input[builtins.str]] = None,
                 product_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Definition of AWS::Deadline::MeteredProduct Resource Type

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] license_endpoint_id: The Amazon EC2 identifier of the license endpoint.
        :param pulumi.Input[builtins.str] product_id: The product ID.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[MeteredProductArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Definition of AWS::Deadline::MeteredProduct Resource Type

        :param str resource_name: The name of the resource.
        :param MeteredProductArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MeteredProductArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 license_endpoint_id: Optional[pulumi.Input[builtins.str]] = None,
                 product_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MeteredProductArgs.__new__(MeteredProductArgs)

            __props__.__dict__["license_endpoint_id"] = license_endpoint_id
            __props__.__dict__["product_id"] = product_id
            __props__.__dict__["arn"] = None
            __props__.__dict__["family"] = None
            __props__.__dict__["port"] = None
            __props__.__dict__["vendor"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["licenseEndpointId", "productId"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(MeteredProduct, __self__).__init__(
            'aws-native:deadline:MeteredProduct',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'MeteredProduct':
        """
        Get an existing MeteredProduct resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = MeteredProductArgs.__new__(MeteredProductArgs)

        __props__.__dict__["arn"] = None
        __props__.__dict__["family"] = None
        __props__.__dict__["license_endpoint_id"] = None
        __props__.__dict__["port"] = None
        __props__.__dict__["product_id"] = None
        __props__.__dict__["vendor"] = None
        return MeteredProduct(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the metered product.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def family(self) -> pulumi.Output[builtins.str]:
        """
        The family to which the metered product belongs.
        """
        return pulumi.get(self, "family")

    @property
    @pulumi.getter(name="licenseEndpointId")
    def license_endpoint_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The Amazon EC2 identifier of the license endpoint.
        """
        return pulumi.get(self, "license_endpoint_id")

    @property
    @pulumi.getter
    def port(self) -> pulumi.Output[builtins.int]:
        """
        The port on which the metered product should run.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="productId")
    def product_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The product ID.
        """
        return pulumi.get(self, "product_id")

    @property
    @pulumi.getter
    def vendor(self) -> pulumi.Output[builtins.str]:
        """
        The vendor.
        """
        return pulumi.get(self, "vendor")

