# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['LimitArgs', 'Limit']

@pulumi.input_type
class LimitArgs:
    def __init__(__self__, *,
                 amount_requirement_name: pulumi.Input[builtins.str],
                 display_name: pulumi.Input[builtins.str],
                 farm_id: pulumi.Input[builtins.str],
                 max_count: pulumi.Input[builtins.int],
                 description: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Limit resource.
        :param pulumi.Input[builtins.str] amount_requirement_name: The value that you specify as the `name` in the `amounts` field of the `hostRequirements` in a step of a job template to declare the limit requirement.
        :param pulumi.Input[builtins.str] display_name: The name of the limit used in lists to identify the limit.
               
               > This field can store any content. Escape or encode this content before displaying it on a webpage or any other system that might interpret the content of this field.
        :param pulumi.Input[builtins.str] farm_id: The unique identifier of the farm that contains the limit.
        :param pulumi.Input[builtins.int] max_count: The maximum number of resources constrained by this limit. When all of the resources are in use, steps that require the limit won't be scheduled until the resource is available.
               
               The `maxValue` must not be 0. If the value is -1, there is no restriction on the number of resources that can be acquired for this limit.
        :param pulumi.Input[builtins.str] description: A description of the limit. A clear description helps you identify the purpose of the limit.
               
               > This field can store any content. Escape or encode this content before displaying it on a webpage or any other system that might interpret the content of this field.
        """
        pulumi.set(__self__, "amount_requirement_name", amount_requirement_name)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "farm_id", farm_id)
        pulumi.set(__self__, "max_count", max_count)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter(name="amountRequirementName")
    def amount_requirement_name(self) -> pulumi.Input[builtins.str]:
        """
        The value that you specify as the `name` in the `amounts` field of the `hostRequirements` in a step of a job template to declare the limit requirement.
        """
        return pulumi.get(self, "amount_requirement_name")

    @amount_requirement_name.setter
    def amount_requirement_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "amount_requirement_name", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the limit used in lists to identify the limit.

        > This field can store any content. Escape or encode this content before displaying it on a webpage or any other system that might interpret the content of this field.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="farmId")
    def farm_id(self) -> pulumi.Input[builtins.str]:
        """
        The unique identifier of the farm that contains the limit.
        """
        return pulumi.get(self, "farm_id")

    @farm_id.setter
    def farm_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "farm_id", value)

    @property
    @pulumi.getter(name="maxCount")
    def max_count(self) -> pulumi.Input[builtins.int]:
        """
        The maximum number of resources constrained by this limit. When all of the resources are in use, steps that require the limit won't be scheduled until the resource is available.

        The `maxValue` must not be 0. If the value is -1, there is no restriction on the number of resources that can be acquired for this limit.
        """
        return pulumi.get(self, "max_count")

    @max_count.setter
    def max_count(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "max_count", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A description of the limit. A clear description helps you identify the purpose of the limit.

        > This field can store any content. Escape or encode this content before displaying it on a webpage or any other system that might interpret the content of this field.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)


@pulumi.type_token("aws-native:deadline:Limit")
class Limit(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 amount_requirement_name: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 farm_id: Optional[pulumi.Input[builtins.str]] = None,
                 max_count: Optional[pulumi.Input[builtins.int]] = None,
                 __props__=None):
        """
        Definition of AWS::Deadline::Limit Resource Type

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] amount_requirement_name: The value that you specify as the `name` in the `amounts` field of the `hostRequirements` in a step of a job template to declare the limit requirement.
        :param pulumi.Input[builtins.str] description: A description of the limit. A clear description helps you identify the purpose of the limit.
               
               > This field can store any content. Escape or encode this content before displaying it on a webpage or any other system that might interpret the content of this field.
        :param pulumi.Input[builtins.str] display_name: The name of the limit used in lists to identify the limit.
               
               > This field can store any content. Escape or encode this content before displaying it on a webpage or any other system that might interpret the content of this field.
        :param pulumi.Input[builtins.str] farm_id: The unique identifier of the farm that contains the limit.
        :param pulumi.Input[builtins.int] max_count: The maximum number of resources constrained by this limit. When all of the resources are in use, steps that require the limit won't be scheduled until the resource is available.
               
               The `maxValue` must not be 0. If the value is -1, there is no restriction on the number of resources that can be acquired for this limit.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LimitArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Definition of AWS::Deadline::Limit Resource Type

        :param str resource_name: The name of the resource.
        :param LimitArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LimitArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 amount_requirement_name: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 farm_id: Optional[pulumi.Input[builtins.str]] = None,
                 max_count: Optional[pulumi.Input[builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LimitArgs.__new__(LimitArgs)

            if amount_requirement_name is None and not opts.urn:
                raise TypeError("Missing required property 'amount_requirement_name'")
            __props__.__dict__["amount_requirement_name"] = amount_requirement_name
            __props__.__dict__["description"] = description
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            if farm_id is None and not opts.urn:
                raise TypeError("Missing required property 'farm_id'")
            __props__.__dict__["farm_id"] = farm_id
            if max_count is None and not opts.urn:
                raise TypeError("Missing required property 'max_count'")
            __props__.__dict__["max_count"] = max_count
            __props__.__dict__["current_count"] = None
            __props__.__dict__["limit_id"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["amountRequirementName", "farmId"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(Limit, __self__).__init__(
            'aws-native:deadline:Limit',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Limit':
        """
        Get an existing Limit resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = LimitArgs.__new__(LimitArgs)

        __props__.__dict__["amount_requirement_name"] = None
        __props__.__dict__["current_count"] = None
        __props__.__dict__["description"] = None
        __props__.__dict__["display_name"] = None
        __props__.__dict__["farm_id"] = None
        __props__.__dict__["limit_id"] = None
        __props__.__dict__["max_count"] = None
        return Limit(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="amountRequirementName")
    def amount_requirement_name(self) -> pulumi.Output[builtins.str]:
        """
        The value that you specify as the `name` in the `amounts` field of the `hostRequirements` in a step of a job template to declare the limit requirement.
        """
        return pulumi.get(self, "amount_requirement_name")

    @property
    @pulumi.getter(name="currentCount")
    def current_count(self) -> pulumi.Output[builtins.int]:
        """
        The number of resources from the limit that are being used by jobs. The result is delayed and may not be the count at the time that you called the operation.
        """
        return pulumi.get(self, "current_count")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        A description of the limit. A clear description helps you identify the purpose of the limit.

        > This field can store any content. Escape or encode this content before displaying it on a webpage or any other system that might interpret the content of this field.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the limit used in lists to identify the limit.

        > This field can store any content. Escape or encode this content before displaying it on a webpage or any other system that might interpret the content of this field.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="farmId")
    def farm_id(self) -> pulumi.Output[builtins.str]:
        """
        The unique identifier of the farm that contains the limit.
        """
        return pulumi.get(self, "farm_id")

    @property
    @pulumi.getter(name="limitId")
    def limit_id(self) -> pulumi.Output[builtins.str]:
        """
        The unique identifier of the limit.
        """
        return pulumi.get(self, "limit_id")

    @property
    @pulumi.getter(name="maxCount")
    def max_count(self) -> pulumi.Output[builtins.int]:
        """
        The maximum number of resources constrained by this limit. When all of the resources are in use, steps that require the limit won't be scheduled until the resource is available.

        The `maxValue` must not be 0. If the value is -1, there is no restriction on the number of resources that can be acquired for this limit.
        """
        return pulumi.get(self, "max_count")

