# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetLimitResult',
    'AwaitableGetLimitResult',
    'get_limit',
    'get_limit_output',
]

@pulumi.output_type
class GetLimitResult:
    def __init__(__self__, current_count=None, description=None, display_name=None, limit_id=None, max_count=None):
        if current_count and not isinstance(current_count, int):
            raise TypeError("Expected argument 'current_count' to be a int")
        pulumi.set(__self__, "current_count", current_count)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if limit_id and not isinstance(limit_id, str):
            raise TypeError("Expected argument 'limit_id' to be a str")
        pulumi.set(__self__, "limit_id", limit_id)
        if max_count and not isinstance(max_count, int):
            raise TypeError("Expected argument 'max_count' to be a int")
        pulumi.set(__self__, "max_count", max_count)

    @property
    @pulumi.getter(name="currentCount")
    def current_count(self) -> Optional[builtins.int]:
        """
        The number of resources from the limit that are being used by jobs. The result is delayed and may not be the count at the time that you called the operation.
        """
        return pulumi.get(self, "current_count")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        A description of the limit. A clear description helps you identify the purpose of the limit.

        > This field can store any content. Escape or encode this content before displaying it on a webpage or any other system that might interpret the content of this field.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[builtins.str]:
        """
        The name of the limit used in lists to identify the limit.

        > This field can store any content. Escape or encode this content before displaying it on a webpage or any other system that might interpret the content of this field.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="limitId")
    def limit_id(self) -> Optional[builtins.str]:
        """
        The unique identifier of the limit.
        """
        return pulumi.get(self, "limit_id")

    @property
    @pulumi.getter(name="maxCount")
    def max_count(self) -> Optional[builtins.int]:
        """
        The maximum number of resources constrained by this limit. When all of the resources are in use, steps that require the limit won't be scheduled until the resource is available.

        The `maxValue` must not be 0. If the value is -1, there is no restriction on the number of resources that can be acquired for this limit.
        """
        return pulumi.get(self, "max_count")


class AwaitableGetLimitResult(GetLimitResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetLimitResult(
            current_count=self.current_count,
            description=self.description,
            display_name=self.display_name,
            limit_id=self.limit_id,
            max_count=self.max_count)


def get_limit(farm_id: Optional[builtins.str] = None,
              limit_id: Optional[builtins.str] = None,
              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetLimitResult:
    """
    Definition of AWS::Deadline::Limit Resource Type


    :param builtins.str farm_id: The unique identifier of the farm that contains the limit.
    :param builtins.str limit_id: The unique identifier of the limit.
    """
    __args__ = dict()
    __args__['farmId'] = farm_id
    __args__['limitId'] = limit_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:deadline:getLimit', __args__, opts=opts, typ=GetLimitResult).value

    return AwaitableGetLimitResult(
        current_count=pulumi.get(__ret__, 'current_count'),
        description=pulumi.get(__ret__, 'description'),
        display_name=pulumi.get(__ret__, 'display_name'),
        limit_id=pulumi.get(__ret__, 'limit_id'),
        max_count=pulumi.get(__ret__, 'max_count'))
def get_limit_output(farm_id: Optional[pulumi.Input[builtins.str]] = None,
                     limit_id: Optional[pulumi.Input[builtins.str]] = None,
                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetLimitResult]:
    """
    Definition of AWS::Deadline::Limit Resource Type


    :param builtins.str farm_id: The unique identifier of the farm that contains the limit.
    :param builtins.str limit_id: The unique identifier of the limit.
    """
    __args__ = dict()
    __args__['farmId'] = farm_id
    __args__['limitId'] = limit_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:deadline:getLimit', __args__, opts=opts, typ=GetLimitResult)
    return __ret__.apply(lambda __response__: GetLimitResult(
        current_count=pulumi.get(__response__, 'current_count'),
        description=pulumi.get(__response__, 'description'),
        display_name=pulumi.get(__response__, 'display_name'),
        limit_id=pulumi.get(__response__, 'limit_id'),
        max_count=pulumi.get(__response__, 'max_count')))
