# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._enums import *
from ._inputs import *

__all__ = ['FleetArgs', 'Fleet']

@pulumi.input_type
class FleetArgs:
    def __init__(__self__, *,
                 configuration: pulumi.Input[Union['FleetConfiguration0PropertiesArgs', 'FleetConfiguration1PropertiesArgs']],
                 display_name: pulumi.Input[builtins.str],
                 farm_id: pulumi.Input[builtins.str],
                 max_worker_count: pulumi.Input[builtins.int],
                 role_arn: pulumi.Input[builtins.str],
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 host_configuration: Optional[pulumi.Input['FleetHostConfigurationArgs']] = None,
                 min_worker_count: Optional[pulumi.Input[builtins.int]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None):
        """
        The set of arguments for constructing a Fleet resource.
        :param pulumi.Input[Union['FleetConfiguration0PropertiesArgs', 'FleetConfiguration1PropertiesArgs']] configuration: The configuration details for the fleet.
        :param pulumi.Input[builtins.str] display_name: The display name of the fleet summary to update.
               
               > This field can store any content. Escape or encode this content before displaying it on a webpage or any other system that might interpret the content of this field.
        :param pulumi.Input[builtins.str] farm_id: The farm ID.
        :param pulumi.Input[builtins.int] max_worker_count: The maximum number of workers specified in the fleet.
        :param pulumi.Input[builtins.str] role_arn: The IAM role that workers in the fleet use when processing jobs.
        :param pulumi.Input[builtins.str] description: A description that helps identify what the fleet is used for.
               
               > This field can store any content. Escape or encode this content before displaying it on a webpage or any other system that might interpret the content of this field.
        :param pulumi.Input['FleetHostConfigurationArgs'] host_configuration: Provides a script that runs as a worker is starting up that you can use to provide additional configuration for workers in your fleet.
               
               To remove a script from a fleet, use the [UpdateFleet](https://docs.aws.amazon.com/deadline-cloud/latest/APIReference/API_UpdateFleet.html) operation with the `hostConfiguration` `scriptBody` parameter set to an empty string ("").
        :param pulumi.Input[builtins.int] min_worker_count: The minimum number of workers in the fleet.
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: An array of key-value pairs to apply to this resource.
        """
        pulumi.set(__self__, "configuration", configuration)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "farm_id", farm_id)
        pulumi.set(__self__, "max_worker_count", max_worker_count)
        pulumi.set(__self__, "role_arn", role_arn)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if host_configuration is not None:
            pulumi.set(__self__, "host_configuration", host_configuration)
        if min_worker_count is not None:
            pulumi.set(__self__, "min_worker_count", min_worker_count)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def configuration(self) -> pulumi.Input[Union['FleetConfiguration0PropertiesArgs', 'FleetConfiguration1PropertiesArgs']]:
        """
        The configuration details for the fleet.
        """
        return pulumi.get(self, "configuration")

    @configuration.setter
    def configuration(self, value: pulumi.Input[Union['FleetConfiguration0PropertiesArgs', 'FleetConfiguration1PropertiesArgs']]):
        pulumi.set(self, "configuration", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[builtins.str]:
        """
        The display name of the fleet summary to update.

        > This field can store any content. Escape or encode this content before displaying it on a webpage or any other system that might interpret the content of this field.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="farmId")
    def farm_id(self) -> pulumi.Input[builtins.str]:
        """
        The farm ID.
        """
        return pulumi.get(self, "farm_id")

    @farm_id.setter
    def farm_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "farm_id", value)

    @property
    @pulumi.getter(name="maxWorkerCount")
    def max_worker_count(self) -> pulumi.Input[builtins.int]:
        """
        The maximum number of workers specified in the fleet.
        """
        return pulumi.get(self, "max_worker_count")

    @max_worker_count.setter
    def max_worker_count(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "max_worker_count", value)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Input[builtins.str]:
        """
        The IAM role that workers in the fleet use when processing jobs.
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "role_arn", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A description that helps identify what the fleet is used for.

        > This field can store any content. Escape or encode this content before displaying it on a webpage or any other system that might interpret the content of this field.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="hostConfiguration")
    def host_configuration(self) -> Optional[pulumi.Input['FleetHostConfigurationArgs']]:
        """
        Provides a script that runs as a worker is starting up that you can use to provide additional configuration for workers in your fleet.

        To remove a script from a fleet, use the [UpdateFleet](https://docs.aws.amazon.com/deadline-cloud/latest/APIReference/API_UpdateFleet.html) operation with the `hostConfiguration` `scriptBody` parameter set to an empty string ("").
        """
        return pulumi.get(self, "host_configuration")

    @host_configuration.setter
    def host_configuration(self, value: Optional[pulumi.Input['FleetHostConfigurationArgs']]):
        pulumi.set(self, "host_configuration", value)

    @property
    @pulumi.getter(name="minWorkerCount")
    def min_worker_count(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The minimum number of workers in the fleet.
        """
        return pulumi.get(self, "min_worker_count")

    @min_worker_count.setter
    def min_worker_count(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "min_worker_count", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("aws-native:deadline:Fleet")
class Fleet(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 configuration: Optional[pulumi.Input[Union[Union['FleetConfiguration0PropertiesArgs', 'FleetConfiguration0PropertiesArgsDict'], Union['FleetConfiguration1PropertiesArgs', 'FleetConfiguration1PropertiesArgsDict']]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 farm_id: Optional[pulumi.Input[builtins.str]] = None,
                 host_configuration: Optional[pulumi.Input[Union['FleetHostConfigurationArgs', 'FleetHostConfigurationArgsDict']]] = None,
                 max_worker_count: Optional[pulumi.Input[builtins.int]] = None,
                 min_worker_count: Optional[pulumi.Input[builtins.int]] = None,
                 role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        """
        Definition of AWS::Deadline::Fleet Resource Type

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union[Union['FleetConfiguration0PropertiesArgs', 'FleetConfiguration0PropertiesArgsDict'], Union['FleetConfiguration1PropertiesArgs', 'FleetConfiguration1PropertiesArgsDict']]] configuration: The configuration details for the fleet.
        :param pulumi.Input[builtins.str] description: A description that helps identify what the fleet is used for.
               
               > This field can store any content. Escape or encode this content before displaying it on a webpage or any other system that might interpret the content of this field.
        :param pulumi.Input[builtins.str] display_name: The display name of the fleet summary to update.
               
               > This field can store any content. Escape or encode this content before displaying it on a webpage or any other system that might interpret the content of this field.
        :param pulumi.Input[builtins.str] farm_id: The farm ID.
        :param pulumi.Input[Union['FleetHostConfigurationArgs', 'FleetHostConfigurationArgsDict']] host_configuration: Provides a script that runs as a worker is starting up that you can use to provide additional configuration for workers in your fleet.
               
               To remove a script from a fleet, use the [UpdateFleet](https://docs.aws.amazon.com/deadline-cloud/latest/APIReference/API_UpdateFleet.html) operation with the `hostConfiguration` `scriptBody` parameter set to an empty string ("").
        :param pulumi.Input[builtins.int] max_worker_count: The maximum number of workers specified in the fleet.
        :param pulumi.Input[builtins.int] min_worker_count: The minimum number of workers in the fleet.
        :param pulumi.Input[builtins.str] role_arn: The IAM role that workers in the fleet use when processing jobs.
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: An array of key-value pairs to apply to this resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FleetArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Definition of AWS::Deadline::Fleet Resource Type

        :param str resource_name: The name of the resource.
        :param FleetArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FleetArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 configuration: Optional[pulumi.Input[Union[Union['FleetConfiguration0PropertiesArgs', 'FleetConfiguration0PropertiesArgsDict'], Union['FleetConfiguration1PropertiesArgs', 'FleetConfiguration1PropertiesArgsDict']]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 farm_id: Optional[pulumi.Input[builtins.str]] = None,
                 host_configuration: Optional[pulumi.Input[Union['FleetHostConfigurationArgs', 'FleetHostConfigurationArgsDict']]] = None,
                 max_worker_count: Optional[pulumi.Input[builtins.int]] = None,
                 min_worker_count: Optional[pulumi.Input[builtins.int]] = None,
                 role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FleetArgs.__new__(FleetArgs)

            if configuration is None and not opts.urn:
                raise TypeError("Missing required property 'configuration'")
            __props__.__dict__["configuration"] = configuration
            __props__.__dict__["description"] = description
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            if farm_id is None and not opts.urn:
                raise TypeError("Missing required property 'farm_id'")
            __props__.__dict__["farm_id"] = farm_id
            __props__.__dict__["host_configuration"] = host_configuration
            if max_worker_count is None and not opts.urn:
                raise TypeError("Missing required property 'max_worker_count'")
            __props__.__dict__["max_worker_count"] = max_worker_count
            __props__.__dict__["min_worker_count"] = min_worker_count
            if role_arn is None and not opts.urn:
                raise TypeError("Missing required property 'role_arn'")
            __props__.__dict__["role_arn"] = role_arn
            __props__.__dict__["tags"] = tags
            __props__.__dict__["arn"] = None
            __props__.__dict__["capabilities"] = None
            __props__.__dict__["fleet_id"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["worker_count"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["farmId"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(Fleet, __self__).__init__(
            'aws-native:deadline:Fleet',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Fleet':
        """
        Get an existing Fleet resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = FleetArgs.__new__(FleetArgs)

        __props__.__dict__["arn"] = None
        __props__.__dict__["capabilities"] = None
        __props__.__dict__["configuration"] = None
        __props__.__dict__["description"] = None
        __props__.__dict__["display_name"] = None
        __props__.__dict__["farm_id"] = None
        __props__.__dict__["fleet_id"] = None
        __props__.__dict__["host_configuration"] = None
        __props__.__dict__["max_worker_count"] = None
        __props__.__dict__["min_worker_count"] = None
        __props__.__dict__["role_arn"] = None
        __props__.__dict__["status"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["worker_count"] = None
        return Fleet(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[builtins.str]:
        """
        The Amazon Resource Name (ARN) assigned to the fleet.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def capabilities(self) -> pulumi.Output['outputs.FleetCapabilities']:
        return pulumi.get(self, "capabilities")

    @property
    @pulumi.getter
    def configuration(self) -> pulumi.Output[Any]:
        """
        The configuration details for the fleet.
        """
        return pulumi.get(self, "configuration")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        A description that helps identify what the fleet is used for.

        > This field can store any content. Escape or encode this content before displaying it on a webpage or any other system that might interpret the content of this field.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[builtins.str]:
        """
        The display name of the fleet summary to update.

        > This field can store any content. Escape or encode this content before displaying it on a webpage or any other system that might interpret the content of this field.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="farmId")
    def farm_id(self) -> pulumi.Output[builtins.str]:
        """
        The farm ID.
        """
        return pulumi.get(self, "farm_id")

    @property
    @pulumi.getter(name="fleetId")
    def fleet_id(self) -> pulumi.Output[builtins.str]:
        """
        The fleet ID.
        """
        return pulumi.get(self, "fleet_id")

    @property
    @pulumi.getter(name="hostConfiguration")
    def host_configuration(self) -> pulumi.Output[Optional['outputs.FleetHostConfiguration']]:
        """
        Provides a script that runs as a worker is starting up that you can use to provide additional configuration for workers in your fleet.

        To remove a script from a fleet, use the [UpdateFleet](https://docs.aws.amazon.com/deadline-cloud/latest/APIReference/API_UpdateFleet.html) operation with the `hostConfiguration` `scriptBody` parameter set to an empty string ("").
        """
        return pulumi.get(self, "host_configuration")

    @property
    @pulumi.getter(name="maxWorkerCount")
    def max_worker_count(self) -> pulumi.Output[builtins.int]:
        """
        The maximum number of workers specified in the fleet.
        """
        return pulumi.get(self, "max_worker_count")

    @property
    @pulumi.getter(name="minWorkerCount")
    def min_worker_count(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The minimum number of workers in the fleet.
        """
        return pulumi.get(self, "min_worker_count")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Output[builtins.str]:
        """
        The IAM role that workers in the fleet use when processing jobs.
        """
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output['FleetStatus']:
        """
        The status of the fleet.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="workerCount")
    def worker_count(self) -> pulumi.Output[builtins.int]:
        """
        The number of workers in the fleet summary.
        """
        return pulumi.get(self, "worker_count")

