# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = ['UserProfileArgs', 'UserProfile']

@pulumi.input_type
class UserProfileArgs:
    def __init__(__self__, *,
                 domain_identifier: pulumi.Input[builtins.str],
                 user_identifier: pulumi.Input[builtins.str],
                 status: Optional[pulumi.Input['UserProfileStatus']] = None,
                 user_type: Optional[pulumi.Input['UserProfileUserType']] = None):
        """
        The set of arguments for constructing a UserProfile resource.
        :param pulumi.Input[builtins.str] domain_identifier: The identifier of the Amazon DataZone domain in which the user profile would be created.
        :param pulumi.Input[builtins.str] user_identifier: The ID of the user.
        :param pulumi.Input['UserProfileStatus'] status: The status of the user profile.
        :param pulumi.Input['UserProfileUserType'] user_type: The user type of the user for which the user profile is created.
        """
        pulumi.set(__self__, "domain_identifier", domain_identifier)
        pulumi.set(__self__, "user_identifier", user_identifier)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if user_type is not None:
            pulumi.set(__self__, "user_type", user_type)

    @property
    @pulumi.getter(name="domainIdentifier")
    def domain_identifier(self) -> pulumi.Input[builtins.str]:
        """
        The identifier of the Amazon DataZone domain in which the user profile would be created.
        """
        return pulumi.get(self, "domain_identifier")

    @domain_identifier.setter
    def domain_identifier(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "domain_identifier", value)

    @property
    @pulumi.getter(name="userIdentifier")
    def user_identifier(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the user.
        """
        return pulumi.get(self, "user_identifier")

    @user_identifier.setter
    def user_identifier(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "user_identifier", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input['UserProfileStatus']]:
        """
        The status of the user profile.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input['UserProfileStatus']]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="userType")
    def user_type(self) -> Optional[pulumi.Input['UserProfileUserType']]:
        """
        The user type of the user for which the user profile is created.
        """
        return pulumi.get(self, "user_type")

    @user_type.setter
    def user_type(self, value: Optional[pulumi.Input['UserProfileUserType']]):
        pulumi.set(self, "user_type", value)


@pulumi.type_token("aws-native:datazone:UserProfile")
class UserProfile(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 domain_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 status: Optional[pulumi.Input['UserProfileStatus']] = None,
                 user_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 user_type: Optional[pulumi.Input['UserProfileUserType']] = None,
                 __props__=None):
        """
        A user profile represents Amazon DataZone users. Amazon DataZone supports both IAM roles and SSO identities to interact with the Amazon DataZone Management Console and the data portal for different purposes. Domain administrators use IAM roles to perform the initial administrative domain-related work in the Amazon DataZone Management Console, including creating new Amazon DataZone domains, configuring metadata form types, and implementing policies. Data workers use their SSO corporate identities via Identity Center to log into the Amazon DataZone Data Portal and access projects where they have memberships.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] domain_identifier: The identifier of the Amazon DataZone domain in which the user profile would be created.
        :param pulumi.Input['UserProfileStatus'] status: The status of the user profile.
        :param pulumi.Input[builtins.str] user_identifier: The ID of the user.
        :param pulumi.Input['UserProfileUserType'] user_type: The user type of the user for which the user profile is created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: UserProfileArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A user profile represents Amazon DataZone users. Amazon DataZone supports both IAM roles and SSO identities to interact with the Amazon DataZone Management Console and the data portal for different purposes. Domain administrators use IAM roles to perform the initial administrative domain-related work in the Amazon DataZone Management Console, including creating new Amazon DataZone domains, configuring metadata form types, and implementing policies. Data workers use their SSO corporate identities via Identity Center to log into the Amazon DataZone Data Portal and access projects where they have memberships.

        :param str resource_name: The name of the resource.
        :param UserProfileArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(UserProfileArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 domain_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 status: Optional[pulumi.Input['UserProfileStatus']] = None,
                 user_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 user_type: Optional[pulumi.Input['UserProfileUserType']] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = UserProfileArgs.__new__(UserProfileArgs)

            if domain_identifier is None and not opts.urn:
                raise TypeError("Missing required property 'domain_identifier'")
            __props__.__dict__["domain_identifier"] = domain_identifier
            __props__.__dict__["status"] = status
            if user_identifier is None and not opts.urn:
                raise TypeError("Missing required property 'user_identifier'")
            __props__.__dict__["user_identifier"] = user_identifier
            __props__.__dict__["user_type"] = user_type
            __props__.__dict__["aws_id"] = None
            __props__.__dict__["details"] = None
            __props__.__dict__["domain_id"] = None
            __props__.__dict__["type"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["domainIdentifier", "userIdentifier", "userType"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(UserProfile, __self__).__init__(
            'aws-native:datazone:UserProfile',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'UserProfile':
        """
        Get an existing UserProfile resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = UserProfileArgs.__new__(UserProfileArgs)

        __props__.__dict__["aws_id"] = None
        __props__.__dict__["details"] = None
        __props__.__dict__["domain_id"] = None
        __props__.__dict__["domain_identifier"] = None
        __props__.__dict__["status"] = None
        __props__.__dict__["type"] = None
        __props__.__dict__["user_identifier"] = None
        __props__.__dict__["user_type"] = None
        return UserProfile(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="awsId")
    def aws_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the Amazon DataZone user profile.
        """
        return pulumi.get(self, "aws_id")

    @property
    @pulumi.getter
    def details(self) -> pulumi.Output[Any]:
        return pulumi.get(self, "details")

    @property
    @pulumi.getter(name="domainId")
    def domain_id(self) -> pulumi.Output[builtins.str]:
        """
        The identifier of the Amazon DataZone domain in which the user profile is created.
        """
        return pulumi.get(self, "domain_id")

    @property
    @pulumi.getter(name="domainIdentifier")
    def domain_identifier(self) -> pulumi.Output[builtins.str]:
        """
        The identifier of the Amazon DataZone domain in which the user profile would be created.
        """
        return pulumi.get(self, "domain_identifier")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[Optional['UserProfileStatus']]:
        """
        The status of the user profile.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output['UserProfileType']:
        """
        The type of the user profile.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="userIdentifier")
    def user_identifier(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the user.
        """
        return pulumi.get(self, "user_identifier")

    @property
    @pulumi.getter(name="userType")
    def user_type(self) -> pulumi.Output[Optional['UserProfileUserType']]:
        """
        The user type of the user for which the user profile is created.
        """
        return pulumi.get(self, "user_type")

