# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *
from ._inputs import *

__all__ = ['ProjectMembershipArgs', 'ProjectMembership']

@pulumi.input_type
class ProjectMembershipArgs:
    def __init__(__self__, *,
                 designation: pulumi.Input['ProjectMembershipUserDesignation'],
                 domain_identifier: pulumi.Input[builtins.str],
                 member: pulumi.Input[Union['ProjectMembershipMember0PropertiesArgs', 'ProjectMembershipMember1PropertiesArgs']],
                 project_identifier: pulumi.Input[builtins.str]):
        """
        The set of arguments for constructing a ProjectMembership resource.
        :param pulumi.Input['ProjectMembershipUserDesignation'] designation: The designated role of a project member.
        :param pulumi.Input[builtins.str] domain_identifier: The ID of the Amazon DataZone domain in which project membership is created.
        :param pulumi.Input[Union['ProjectMembershipMember0PropertiesArgs', 'ProjectMembershipMember1PropertiesArgs']] member: The details about a project member.
        :param pulumi.Input[builtins.str] project_identifier: The ID of the project for which this project membership was created.
        """
        pulumi.set(__self__, "designation", designation)
        pulumi.set(__self__, "domain_identifier", domain_identifier)
        pulumi.set(__self__, "member", member)
        pulumi.set(__self__, "project_identifier", project_identifier)

    @property
    @pulumi.getter
    def designation(self) -> pulumi.Input['ProjectMembershipUserDesignation']:
        """
        The designated role of a project member.
        """
        return pulumi.get(self, "designation")

    @designation.setter
    def designation(self, value: pulumi.Input['ProjectMembershipUserDesignation']):
        pulumi.set(self, "designation", value)

    @property
    @pulumi.getter(name="domainIdentifier")
    def domain_identifier(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the Amazon DataZone domain in which project membership is created.
        """
        return pulumi.get(self, "domain_identifier")

    @domain_identifier.setter
    def domain_identifier(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "domain_identifier", value)

    @property
    @pulumi.getter
    def member(self) -> pulumi.Input[Union['ProjectMembershipMember0PropertiesArgs', 'ProjectMembershipMember1PropertiesArgs']]:
        """
        The details about a project member.
        """
        return pulumi.get(self, "member")

    @member.setter
    def member(self, value: pulumi.Input[Union['ProjectMembershipMember0PropertiesArgs', 'ProjectMembershipMember1PropertiesArgs']]):
        pulumi.set(self, "member", value)

    @property
    @pulumi.getter(name="projectIdentifier")
    def project_identifier(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the project for which this project membership was created.
        """
        return pulumi.get(self, "project_identifier")

    @project_identifier.setter
    def project_identifier(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "project_identifier", value)


@pulumi.type_token("aws-native:datazone:ProjectMembership")
class ProjectMembership(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 designation: Optional[pulumi.Input['ProjectMembershipUserDesignation']] = None,
                 domain_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 member: Optional[pulumi.Input[Union[Union['ProjectMembershipMember0PropertiesArgs', 'ProjectMembershipMember0PropertiesArgsDict'], Union['ProjectMembershipMember1PropertiesArgs', 'ProjectMembershipMember1PropertiesArgsDict']]]] = None,
                 project_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Definition of AWS::DataZone::ProjectMembership Resource Type

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input['ProjectMembershipUserDesignation'] designation: The designated role of a project member.
        :param pulumi.Input[builtins.str] domain_identifier: The ID of the Amazon DataZone domain in which project membership is created.
        :param pulumi.Input[Union[Union['ProjectMembershipMember0PropertiesArgs', 'ProjectMembershipMember0PropertiesArgsDict'], Union['ProjectMembershipMember1PropertiesArgs', 'ProjectMembershipMember1PropertiesArgsDict']]] member: The details about a project member.
        :param pulumi.Input[builtins.str] project_identifier: The ID of the project for which this project membership was created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ProjectMembershipArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Definition of AWS::DataZone::ProjectMembership Resource Type

        :param str resource_name: The name of the resource.
        :param ProjectMembershipArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProjectMembershipArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 designation: Optional[pulumi.Input['ProjectMembershipUserDesignation']] = None,
                 domain_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 member: Optional[pulumi.Input[Union[Union['ProjectMembershipMember0PropertiesArgs', 'ProjectMembershipMember0PropertiesArgsDict'], Union['ProjectMembershipMember1PropertiesArgs', 'ProjectMembershipMember1PropertiesArgsDict']]]] = None,
                 project_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProjectMembershipArgs.__new__(ProjectMembershipArgs)

            if designation is None and not opts.urn:
                raise TypeError("Missing required property 'designation'")
            __props__.__dict__["designation"] = designation
            if domain_identifier is None and not opts.urn:
                raise TypeError("Missing required property 'domain_identifier'")
            __props__.__dict__["domain_identifier"] = domain_identifier
            if member is None and not opts.urn:
                raise TypeError("Missing required property 'member'")
            __props__.__dict__["member"] = member
            if project_identifier is None and not opts.urn:
                raise TypeError("Missing required property 'project_identifier'")
            __props__.__dict__["project_identifier"] = project_identifier
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["domainIdentifier", "member", "projectIdentifier"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(ProjectMembership, __self__).__init__(
            'aws-native:datazone:ProjectMembership',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'ProjectMembership':
        """
        Get an existing ProjectMembership resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = ProjectMembershipArgs.__new__(ProjectMembershipArgs)

        __props__.__dict__["designation"] = None
        __props__.__dict__["domain_identifier"] = None
        __props__.__dict__["member"] = None
        __props__.__dict__["project_identifier"] = None
        return ProjectMembership(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def designation(self) -> pulumi.Output['ProjectMembershipUserDesignation']:
        """
        The designated role of a project member.
        """
        return pulumi.get(self, "designation")

    @property
    @pulumi.getter(name="domainIdentifier")
    def domain_identifier(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the Amazon DataZone domain in which project membership is created.
        """
        return pulumi.get(self, "domain_identifier")

    @property
    @pulumi.getter
    def member(self) -> pulumi.Output[Any]:
        """
        The details about a project member.
        """
        return pulumi.get(self, "member")

    @property
    @pulumi.getter(name="projectIdentifier")
    def project_identifier(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the project for which this project membership was created.
        """
        return pulumi.get(self, "project_identifier")

