# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *
from ._inputs import *

__all__ = ['ProjectArgs', 'Project']

@pulumi.input_type
class ProjectArgs:
    def __init__(__self__, *,
                 domain_identifier: pulumi.Input[builtins.str],
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 domain_unit_id: Optional[pulumi.Input[builtins.str]] = None,
                 glossary_terms: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project_profile_id: Optional[pulumi.Input[builtins.str]] = None,
                 project_profile_version: Optional[pulumi.Input[builtins.str]] = None,
                 user_parameters: Optional[pulumi.Input[Sequence[pulumi.Input['ProjectEnvironmentConfigurationUserParameterArgs']]]] = None):
        """
        The set of arguments for constructing a Project resource.
        :param pulumi.Input[builtins.str] domain_identifier: The ID of the Amazon DataZone domain in which this project is created.
        :param pulumi.Input[builtins.str] description: The description of the Amazon DataZone project.
        :param pulumi.Input[builtins.str] domain_unit_id: The ID of the domain unit.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] glossary_terms: The glossary terms that can be used in this Amazon DataZone project.
        :param pulumi.Input[builtins.str] name: The name of the Amazon DataZone project.
        :param pulumi.Input[builtins.str] project_profile_id: The project profile ID.
        :param pulumi.Input[builtins.str] project_profile_version: The project profile version to which the project should be updated. You can only specify the following string for this parameter: latest.
        :param pulumi.Input[Sequence[pulumi.Input['ProjectEnvironmentConfigurationUserParameterArgs']]] user_parameters: The user parameters of the project.
        """
        pulumi.set(__self__, "domain_identifier", domain_identifier)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if domain_unit_id is not None:
            pulumi.set(__self__, "domain_unit_id", domain_unit_id)
        if glossary_terms is not None:
            pulumi.set(__self__, "glossary_terms", glossary_terms)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project_profile_id is not None:
            pulumi.set(__self__, "project_profile_id", project_profile_id)
        if project_profile_version is not None:
            pulumi.set(__self__, "project_profile_version", project_profile_version)
        if user_parameters is not None:
            pulumi.set(__self__, "user_parameters", user_parameters)

    @property
    @pulumi.getter(name="domainIdentifier")
    def domain_identifier(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the Amazon DataZone domain in which this project is created.
        """
        return pulumi.get(self, "domain_identifier")

    @domain_identifier.setter
    def domain_identifier(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "domain_identifier", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description of the Amazon DataZone project.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="domainUnitId")
    def domain_unit_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the domain unit.
        """
        return pulumi.get(self, "domain_unit_id")

    @domain_unit_id.setter
    def domain_unit_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "domain_unit_id", value)

    @property
    @pulumi.getter(name="glossaryTerms")
    def glossary_terms(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The glossary terms that can be used in this Amazon DataZone project.
        """
        return pulumi.get(self, "glossary_terms")

    @glossary_terms.setter
    def glossary_terms(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "glossary_terms", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Amazon DataZone project.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="projectProfileId")
    def project_profile_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The project profile ID.
        """
        return pulumi.get(self, "project_profile_id")

    @project_profile_id.setter
    def project_profile_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project_profile_id", value)

    @property
    @pulumi.getter(name="projectProfileVersion")
    def project_profile_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The project profile version to which the project should be updated. You can only specify the following string for this parameter: latest.
        """
        return pulumi.get(self, "project_profile_version")

    @project_profile_version.setter
    def project_profile_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project_profile_version", value)

    @property
    @pulumi.getter(name="userParameters")
    def user_parameters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ProjectEnvironmentConfigurationUserParameterArgs']]]]:
        """
        The user parameters of the project.
        """
        return pulumi.get(self, "user_parameters")

    @user_parameters.setter
    def user_parameters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ProjectEnvironmentConfigurationUserParameterArgs']]]]):
        pulumi.set(self, "user_parameters", value)


@pulumi.type_token("aws-native:datazone:Project")
class Project(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 domain_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 domain_unit_id: Optional[pulumi.Input[builtins.str]] = None,
                 glossary_terms: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project_profile_id: Optional[pulumi.Input[builtins.str]] = None,
                 project_profile_version: Optional[pulumi.Input[builtins.str]] = None,
                 user_parameters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProjectEnvironmentConfigurationUserParameterArgs', 'ProjectEnvironmentConfigurationUserParameterArgsDict']]]]] = None,
                 __props__=None):
        """
        Amazon DataZone projects are business use case–based groupings of people, assets (data), and tools used to simplify access to the AWS analytics.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] description: The description of the Amazon DataZone project.
        :param pulumi.Input[builtins.str] domain_identifier: The ID of the Amazon DataZone domain in which this project is created.
        :param pulumi.Input[builtins.str] domain_unit_id: The ID of the domain unit.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] glossary_terms: The glossary terms that can be used in this Amazon DataZone project.
        :param pulumi.Input[builtins.str] name: The name of the Amazon DataZone project.
        :param pulumi.Input[builtins.str] project_profile_id: The project profile ID.
        :param pulumi.Input[builtins.str] project_profile_version: The project profile version to which the project should be updated. You can only specify the following string for this parameter: latest.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ProjectEnvironmentConfigurationUserParameterArgs', 'ProjectEnvironmentConfigurationUserParameterArgsDict']]]] user_parameters: The user parameters of the project.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ProjectArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Amazon DataZone projects are business use case–based groupings of people, assets (data), and tools used to simplify access to the AWS analytics.

        :param str resource_name: The name of the resource.
        :param ProjectArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProjectArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 domain_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 domain_unit_id: Optional[pulumi.Input[builtins.str]] = None,
                 glossary_terms: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project_profile_id: Optional[pulumi.Input[builtins.str]] = None,
                 project_profile_version: Optional[pulumi.Input[builtins.str]] = None,
                 user_parameters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProjectEnvironmentConfigurationUserParameterArgs', 'ProjectEnvironmentConfigurationUserParameterArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProjectArgs.__new__(ProjectArgs)

            __props__.__dict__["description"] = description
            if domain_identifier is None and not opts.urn:
                raise TypeError("Missing required property 'domain_identifier'")
            __props__.__dict__["domain_identifier"] = domain_identifier
            __props__.__dict__["domain_unit_id"] = domain_unit_id
            __props__.__dict__["glossary_terms"] = glossary_terms
            __props__.__dict__["name"] = name
            __props__.__dict__["project_profile_id"] = project_profile_id
            __props__.__dict__["project_profile_version"] = project_profile_version
            __props__.__dict__["user_parameters"] = user_parameters
            __props__.__dict__["aws_id"] = None
            __props__.__dict__["created_at"] = None
            __props__.__dict__["created_by"] = None
            __props__.__dict__["domain_id"] = None
            __props__.__dict__["last_updated_at"] = None
            __props__.__dict__["project_status"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["domainIdentifier", "domainUnitId", "projectProfileId"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(Project, __self__).__init__(
            'aws-native:datazone:Project',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Project':
        """
        Get an existing Project resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = ProjectArgs.__new__(ProjectArgs)

        __props__.__dict__["aws_id"] = None
        __props__.__dict__["created_at"] = None
        __props__.__dict__["created_by"] = None
        __props__.__dict__["description"] = None
        __props__.__dict__["domain_id"] = None
        __props__.__dict__["domain_identifier"] = None
        __props__.__dict__["domain_unit_id"] = None
        __props__.__dict__["glossary_terms"] = None
        __props__.__dict__["last_updated_at"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["project_profile_id"] = None
        __props__.__dict__["project_profile_version"] = None
        __props__.__dict__["project_status"] = None
        __props__.__dict__["user_parameters"] = None
        return Project(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="awsId")
    def aws_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the Amazon DataZone project.
        """
        return pulumi.get(self, "aws_id")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[builtins.str]:
        """
        The timestamp of when the project was created.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> pulumi.Output[builtins.str]:
        """
        The Amazon DataZone user who created the project.
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The description of the Amazon DataZone project.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="domainId")
    def domain_id(self) -> pulumi.Output[builtins.str]:
        """
        The identifier of the Amazon DataZone domain in which the project was created.
        """
        return pulumi.get(self, "domain_id")

    @property
    @pulumi.getter(name="domainIdentifier")
    def domain_identifier(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the Amazon DataZone domain in which this project is created.
        """
        return pulumi.get(self, "domain_identifier")

    @property
    @pulumi.getter(name="domainUnitId")
    def domain_unit_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The ID of the domain unit.
        """
        return pulumi.get(self, "domain_unit_id")

    @property
    @pulumi.getter(name="glossaryTerms")
    def glossary_terms(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        The glossary terms that can be used in this Amazon DataZone project.
        """
        return pulumi.get(self, "glossary_terms")

    @property
    @pulumi.getter(name="lastUpdatedAt")
    def last_updated_at(self) -> pulumi.Output[builtins.str]:
        """
        The timestamp of when the project was last updated.
        """
        return pulumi.get(self, "last_updated_at")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the Amazon DataZone project.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="projectProfileId")
    def project_profile_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The project profile ID.
        """
        return pulumi.get(self, "project_profile_id")

    @property
    @pulumi.getter(name="projectProfileVersion")
    def project_profile_version(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The project profile version to which the project should be updated. You can only specify the following string for this parameter: latest.
        """
        return pulumi.get(self, "project_profile_version")

    @property
    @pulumi.getter(name="projectStatus")
    def project_status(self) -> pulumi.Output['ProjectStatus']:
        """
        The status of the project.
        """
        return pulumi.get(self, "project_status")

    @property
    @pulumi.getter(name="userParameters")
    def user_parameters(self) -> pulumi.Output[Optional[Sequence['outputs.ProjectEnvironmentConfigurationUserParameter']]]:
        """
        The user parameters of the project.
        """
        return pulumi.get(self, "user_parameters")

