# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from ._enums import *

__all__ = ['GroupProfileArgs', 'GroupProfile']

@pulumi.input_type
class GroupProfileArgs:
    def __init__(__self__, *,
                 domain_identifier: pulumi.Input[builtins.str],
                 group_identifier: pulumi.Input[builtins.str],
                 status: Optional[pulumi.Input['GroupProfileStatus']] = None):
        """
        The set of arguments for constructing a GroupProfile resource.
        :param pulumi.Input[builtins.str] domain_identifier: The identifier of the Amazon DataZone domain in which the group profile would be created.
        :param pulumi.Input[builtins.str] group_identifier: The ID of the group.
        :param pulumi.Input['GroupProfileStatus'] status: The status of a group profile.
        """
        pulumi.set(__self__, "domain_identifier", domain_identifier)
        pulumi.set(__self__, "group_identifier", group_identifier)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="domainIdentifier")
    def domain_identifier(self) -> pulumi.Input[builtins.str]:
        """
        The identifier of the Amazon DataZone domain in which the group profile would be created.
        """
        return pulumi.get(self, "domain_identifier")

    @domain_identifier.setter
    def domain_identifier(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "domain_identifier", value)

    @property
    @pulumi.getter(name="groupIdentifier")
    def group_identifier(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the group.
        """
        return pulumi.get(self, "group_identifier")

    @group_identifier.setter
    def group_identifier(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "group_identifier", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input['GroupProfileStatus']]:
        """
        The status of a group profile.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input['GroupProfileStatus']]):
        pulumi.set(self, "status", value)


@pulumi.type_token("aws-native:datazone:GroupProfile")
class GroupProfile(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 domain_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 group_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 status: Optional[pulumi.Input['GroupProfileStatus']] = None,
                 __props__=None):
        """
        Group profiles represent groups of Amazon DataZone users. Groups can be manually created, or mapped to Active Directory groups of enterprise customers. In Amazon DataZone, groups serve two purposes. First, a group can map to a team of users in the organizational chart, and thus reduce the administrative work of a Amazon DataZone project owner when there are new employees joining or leaving a team. Second, corporate administrators use Active Directory groups to manage and update user statuses and so Amazon DataZone domain administrators can use these group memberships to implement Amazon DataZone domain policies.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] domain_identifier: The identifier of the Amazon DataZone domain in which the group profile would be created.
        :param pulumi.Input[builtins.str] group_identifier: The ID of the group.
        :param pulumi.Input['GroupProfileStatus'] status: The status of a group profile.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: GroupProfileArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Group profiles represent groups of Amazon DataZone users. Groups can be manually created, or mapped to Active Directory groups of enterprise customers. In Amazon DataZone, groups serve two purposes. First, a group can map to a team of users in the organizational chart, and thus reduce the administrative work of a Amazon DataZone project owner when there are new employees joining or leaving a team. Second, corporate administrators use Active Directory groups to manage and update user statuses and so Amazon DataZone domain administrators can use these group memberships to implement Amazon DataZone domain policies.

        :param str resource_name: The name of the resource.
        :param GroupProfileArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GroupProfileArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 domain_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 group_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 status: Optional[pulumi.Input['GroupProfileStatus']] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GroupProfileArgs.__new__(GroupProfileArgs)

            if domain_identifier is None and not opts.urn:
                raise TypeError("Missing required property 'domain_identifier'")
            __props__.__dict__["domain_identifier"] = domain_identifier
            if group_identifier is None and not opts.urn:
                raise TypeError("Missing required property 'group_identifier'")
            __props__.__dict__["group_identifier"] = group_identifier
            __props__.__dict__["status"] = status
            __props__.__dict__["aws_id"] = None
            __props__.__dict__["domain_id"] = None
            __props__.__dict__["group_name"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["domainIdentifier", "groupIdentifier"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(GroupProfile, __self__).__init__(
            'aws-native:datazone:GroupProfile',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'GroupProfile':
        """
        Get an existing GroupProfile resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = GroupProfileArgs.__new__(GroupProfileArgs)

        __props__.__dict__["aws_id"] = None
        __props__.__dict__["domain_id"] = None
        __props__.__dict__["domain_identifier"] = None
        __props__.__dict__["group_identifier"] = None
        __props__.__dict__["group_name"] = None
        __props__.__dict__["status"] = None
        return GroupProfile(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="awsId")
    def aws_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the Amazon DataZone group profile.
        """
        return pulumi.get(self, "aws_id")

    @property
    @pulumi.getter(name="domainId")
    def domain_id(self) -> pulumi.Output[builtins.str]:
        """
        The identifier of the Amazon DataZone domain in which the group profile is created.
        """
        return pulumi.get(self, "domain_id")

    @property
    @pulumi.getter(name="domainIdentifier")
    def domain_identifier(self) -> pulumi.Output[builtins.str]:
        """
        The identifier of the Amazon DataZone domain in which the group profile would be created.
        """
        return pulumi.get(self, "domain_identifier")

    @property
    @pulumi.getter(name="groupIdentifier")
    def group_identifier(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the group.
        """
        return pulumi.get(self, "group_identifier")

    @property
    @pulumi.getter(name="groupName")
    def group_name(self) -> pulumi.Output[builtins.str]:
        """
        The group-name of the Group Profile.
        """
        return pulumi.get(self, "group_name")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[Optional['GroupProfileStatus']]:
        """
        The status of a group profile.
        """
        return pulumi.get(self, "status")

