# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'GetUserProfileResult',
    'AwaitableGetUserProfileResult',
    'get_user_profile',
    'get_user_profile_output',
]

@pulumi.output_type
class GetUserProfileResult:
    def __init__(__self__, details=None, domain_id=None, id=None, status=None, type=None):
        if details and not isinstance(details, dict):
            raise TypeError("Expected argument 'details' to be a dict")
        pulumi.set(__self__, "details", details)
        if domain_id and not isinstance(domain_id, str):
            raise TypeError("Expected argument 'domain_id' to be a str")
        pulumi.set(__self__, "domain_id", domain_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def details(self) -> Optional[Any]:
        return pulumi.get(self, "details")

    @property
    @pulumi.getter(name="domainId")
    def domain_id(self) -> Optional[builtins.str]:
        """
        The identifier of the Amazon DataZone domain in which the user profile is created.
        """
        return pulumi.get(self, "domain_id")

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        The ID of the Amazon DataZone user profile.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def status(self) -> Optional['UserProfileStatus']:
        """
        The status of the user profile.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def type(self) -> Optional['UserProfileType']:
        """
        The type of the user profile.
        """
        return pulumi.get(self, "type")


class AwaitableGetUserProfileResult(GetUserProfileResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetUserProfileResult(
            details=self.details,
            domain_id=self.domain_id,
            id=self.id,
            status=self.status,
            type=self.type)


def get_user_profile(domain_id: Optional[builtins.str] = None,
                     id: Optional[builtins.str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetUserProfileResult:
    """
    A user profile represents Amazon DataZone users. Amazon DataZone supports both IAM roles and SSO identities to interact with the Amazon DataZone Management Console and the data portal for different purposes. Domain administrators use IAM roles to perform the initial administrative domain-related work in the Amazon DataZone Management Console, including creating new Amazon DataZone domains, configuring metadata form types, and implementing policies. Data workers use their SSO corporate identities via Identity Center to log into the Amazon DataZone Data Portal and access projects where they have memberships.


    :param builtins.str domain_id: The identifier of the Amazon DataZone domain in which the user profile is created.
    :param builtins.str id: The ID of the Amazon DataZone user profile.
    """
    __args__ = dict()
    __args__['domainId'] = domain_id
    __args__['id'] = id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:datazone:getUserProfile', __args__, opts=opts, typ=GetUserProfileResult).value

    return AwaitableGetUserProfileResult(
        details=pulumi.get(__ret__, 'details'),
        domain_id=pulumi.get(__ret__, 'domain_id'),
        id=pulumi.get(__ret__, 'id'),
        status=pulumi.get(__ret__, 'status'),
        type=pulumi.get(__ret__, 'type'))
def get_user_profile_output(domain_id: Optional[pulumi.Input[builtins.str]] = None,
                            id: Optional[pulumi.Input[builtins.str]] = None,
                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetUserProfileResult]:
    """
    A user profile represents Amazon DataZone users. Amazon DataZone supports both IAM roles and SSO identities to interact with the Amazon DataZone Management Console and the data portal for different purposes. Domain administrators use IAM roles to perform the initial administrative domain-related work in the Amazon DataZone Management Console, including creating new Amazon DataZone domains, configuring metadata form types, and implementing policies. Data workers use their SSO corporate identities via Identity Center to log into the Amazon DataZone Data Portal and access projects where they have memberships.


    :param builtins.str domain_id: The identifier of the Amazon DataZone domain in which the user profile is created.
    :param builtins.str id: The ID of the Amazon DataZone user profile.
    """
    __args__ = dict()
    __args__['domainId'] = domain_id
    __args__['id'] = id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:datazone:getUserProfile', __args__, opts=opts, typ=GetUserProfileResult)
    return __ret__.apply(lambda __response__: GetUserProfileResult(
        details=pulumi.get(__response__, 'details'),
        domain_id=pulumi.get(__response__, 'domain_id'),
        id=pulumi.get(__response__, 'id'),
        status=pulumi.get(__response__, 'status'),
        type=pulumi.get(__response__, 'type')))
