# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from ._enums import *

__all__ = [
    'GetProjectProfileResult',
    'AwaitableGetProjectProfileResult',
    'get_project_profile',
    'get_project_profile_output',
]

@pulumi.output_type
class GetProjectProfileResult:
    def __init__(__self__, created_at=None, created_by=None, description=None, domain_id=None, domain_unit_id=None, id=None, identifier=None, last_updated_at=None, name=None, status=None):
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if created_by and not isinstance(created_by, str):
            raise TypeError("Expected argument 'created_by' to be a str")
        pulumi.set(__self__, "created_by", created_by)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if domain_id and not isinstance(domain_id, str):
            raise TypeError("Expected argument 'domain_id' to be a str")
        pulumi.set(__self__, "domain_id", domain_id)
        if domain_unit_id and not isinstance(domain_unit_id, str):
            raise TypeError("Expected argument 'domain_unit_id' to be a str")
        pulumi.set(__self__, "domain_unit_id", domain_unit_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if identifier and not isinstance(identifier, str):
            raise TypeError("Expected argument 'identifier' to be a str")
        pulumi.set(__self__, "identifier", identifier)
        if last_updated_at and not isinstance(last_updated_at, str):
            raise TypeError("Expected argument 'last_updated_at' to be a str")
        pulumi.set(__self__, "last_updated_at", last_updated_at)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[builtins.str]:
        """
        The timestamp of when the project profile was created.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[builtins.str]:
        """
        The user who created the project profile.
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        The description of the project profile.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="domainId")
    def domain_id(self) -> Optional[builtins.str]:
        """
        The domain ID of the project profile.
        """
        return pulumi.get(self, "domain_id")

    @property
    @pulumi.getter(name="domainUnitId")
    def domain_unit_id(self) -> Optional[builtins.str]:
        """
        The domain unit ID of the project profile.
        """
        return pulumi.get(self, "domain_unit_id")

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        The ID of the project profile.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def identifier(self) -> Optional[builtins.str]:
        return pulumi.get(self, "identifier")

    @property
    @pulumi.getter(name="lastUpdatedAt")
    def last_updated_at(self) -> Optional[builtins.str]:
        """
        The timestamp at which a project profile was last updated.
        """
        return pulumi.get(self, "last_updated_at")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        The name of a project profile.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def status(self) -> Optional['ProjectProfileStatus']:
        """
        The status of a project profile.
        """
        return pulumi.get(self, "status")


class AwaitableGetProjectProfileResult(GetProjectProfileResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetProjectProfileResult(
            created_at=self.created_at,
            created_by=self.created_by,
            description=self.description,
            domain_id=self.domain_id,
            domain_unit_id=self.domain_unit_id,
            id=self.id,
            identifier=self.identifier,
            last_updated_at=self.last_updated_at,
            name=self.name,
            status=self.status)


def get_project_profile(domain_identifier: Optional[builtins.str] = None,
                        identifier: Optional[builtins.str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetProjectProfileResult:
    """
    Definition of AWS::DataZone::ProjectProfile Resource Type
    """
    __args__ = dict()
    __args__['domainIdentifier'] = domain_identifier
    __args__['identifier'] = identifier
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:datazone:getProjectProfile', __args__, opts=opts, typ=GetProjectProfileResult).value

    return AwaitableGetProjectProfileResult(
        created_at=pulumi.get(__ret__, 'created_at'),
        created_by=pulumi.get(__ret__, 'created_by'),
        description=pulumi.get(__ret__, 'description'),
        domain_id=pulumi.get(__ret__, 'domain_id'),
        domain_unit_id=pulumi.get(__ret__, 'domain_unit_id'),
        id=pulumi.get(__ret__, 'id'),
        identifier=pulumi.get(__ret__, 'identifier'),
        last_updated_at=pulumi.get(__ret__, 'last_updated_at'),
        name=pulumi.get(__ret__, 'name'),
        status=pulumi.get(__ret__, 'status'))
def get_project_profile_output(domain_identifier: Optional[pulumi.Input[builtins.str]] = None,
                               identifier: Optional[pulumi.Input[builtins.str]] = None,
                               opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetProjectProfileResult]:
    """
    Definition of AWS::DataZone::ProjectProfile Resource Type
    """
    __args__ = dict()
    __args__['domainIdentifier'] = domain_identifier
    __args__['identifier'] = identifier
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:datazone:getProjectProfile', __args__, opts=opts, typ=GetProjectProfileResult)
    return __ret__.apply(lambda __response__: GetProjectProfileResult(
        created_at=pulumi.get(__response__, 'created_at'),
        created_by=pulumi.get(__response__, 'created_by'),
        description=pulumi.get(__response__, 'description'),
        domain_id=pulumi.get(__response__, 'domain_id'),
        domain_unit_id=pulumi.get(__response__, 'domain_unit_id'),
        id=pulumi.get(__response__, 'id'),
        identifier=pulumi.get(__response__, 'identifier'),
        last_updated_at=pulumi.get(__response__, 'last_updated_at'),
        name=pulumi.get(__response__, 'name'),
        status=pulumi.get(__response__, 'status')))
