# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from ._enums import *

__all__ = [
    'GetEnvironmentResult',
    'AwaitableGetEnvironmentResult',
    'get_environment',
    'get_environment_output',
]

@pulumi.output_type
class GetEnvironmentResult:
    def __init__(__self__, aws_account_id=None, aws_account_region=None, created_at=None, created_by=None, description=None, domain_id=None, environment_blueprint_id=None, environment_profile_id=None, glossary_terms=None, id=None, name=None, project_id=None, provider=None, status=None, updated_at=None):
        if aws_account_id and not isinstance(aws_account_id, str):
            raise TypeError("Expected argument 'aws_account_id' to be a str")
        pulumi.set(__self__, "aws_account_id", aws_account_id)
        if aws_account_region and not isinstance(aws_account_region, str):
            raise TypeError("Expected argument 'aws_account_region' to be a str")
        pulumi.set(__self__, "aws_account_region", aws_account_region)
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if created_by and not isinstance(created_by, str):
            raise TypeError("Expected argument 'created_by' to be a str")
        pulumi.set(__self__, "created_by", created_by)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if domain_id and not isinstance(domain_id, str):
            raise TypeError("Expected argument 'domain_id' to be a str")
        pulumi.set(__self__, "domain_id", domain_id)
        if environment_blueprint_id and not isinstance(environment_blueprint_id, str):
            raise TypeError("Expected argument 'environment_blueprint_id' to be a str")
        pulumi.set(__self__, "environment_blueprint_id", environment_blueprint_id)
        if environment_profile_id and not isinstance(environment_profile_id, str):
            raise TypeError("Expected argument 'environment_profile_id' to be a str")
        pulumi.set(__self__, "environment_profile_id", environment_profile_id)
        if glossary_terms and not isinstance(glossary_terms, list):
            raise TypeError("Expected argument 'glossary_terms' to be a list")
        pulumi.set(__self__, "glossary_terms", glossary_terms)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if provider and not isinstance(provider, str):
            raise TypeError("Expected argument 'provider' to be a str")
        pulumi.set(__self__, "provider", provider)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if updated_at and not isinstance(updated_at, str):
            raise TypeError("Expected argument 'updated_at' to be a str")
        pulumi.set(__self__, "updated_at", updated_at)

    @property
    @pulumi.getter(name="awsAccountId")
    def aws_account_id(self) -> Optional[builtins.str]:
        """
        The AWS account in which the Amazon DataZone environment is created.
        """
        return pulumi.get(self, "aws_account_id")

    @property
    @pulumi.getter(name="awsAccountRegion")
    def aws_account_region(self) -> Optional[builtins.str]:
        """
        The AWS region in which the Amazon DataZone environment is created.
        """
        return pulumi.get(self, "aws_account_region")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[builtins.str]:
        """
        The timestamp of when the environment was created.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[builtins.str]:
        """
        The Amazon DataZone user who created the environment.
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        The description of the Amazon DataZone environment.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="domainId")
    def domain_id(self) -> Optional[builtins.str]:
        """
        The identifier of the Amazon DataZone domain in which the environment is created.
        """
        return pulumi.get(self, "domain_id")

    @property
    @pulumi.getter(name="environmentBlueprintId")
    def environment_blueprint_id(self) -> Optional[builtins.str]:
        """
        The ID of the blueprint with which the Amazon DataZone environment was created.
        """
        return pulumi.get(self, "environment_blueprint_id")

    @property
    @pulumi.getter(name="environmentProfileId")
    def environment_profile_id(self) -> Optional[builtins.str]:
        """
        The ID of the environment profile with which the Amazon DataZone environment was created.
        """
        return pulumi.get(self, "environment_profile_id")

    @property
    @pulumi.getter(name="glossaryTerms")
    def glossary_terms(self) -> Optional[Sequence[builtins.str]]:
        """
        The glossary terms that can be used in the Amazon DataZone environment.
        """
        return pulumi.get(self, "glossary_terms")

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        The ID of the Amazon DataZone environment.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        The name of the environment.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[builtins.str]:
        """
        The ID of the Amazon DataZone project in which the environment is created.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def provider(self) -> Optional[builtins.str]:
        """
        The provider of the Amazon DataZone environment.
        """
        return pulumi.get(self, "provider")

    @property
    @pulumi.getter
    def status(self) -> Optional['EnvironmentStatus']:
        """
        The status of the Amazon DataZone environment.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[builtins.str]:
        """
        The timestamp of when the environment was updated.
        """
        return pulumi.get(self, "updated_at")


class AwaitableGetEnvironmentResult(GetEnvironmentResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetEnvironmentResult(
            aws_account_id=self.aws_account_id,
            aws_account_region=self.aws_account_region,
            created_at=self.created_at,
            created_by=self.created_by,
            description=self.description,
            domain_id=self.domain_id,
            environment_blueprint_id=self.environment_blueprint_id,
            environment_profile_id=self.environment_profile_id,
            glossary_terms=self.glossary_terms,
            id=self.id,
            name=self.name,
            project_id=self.project_id,
            provider=self.provider,
            status=self.status,
            updated_at=self.updated_at)


def get_environment(domain_id: Optional[builtins.str] = None,
                    id: Optional[builtins.str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetEnvironmentResult:
    """
    Definition of AWS::DataZone::Environment Resource Type


    :param builtins.str domain_id: The identifier of the Amazon DataZone domain in which the environment is created.
    :param builtins.str id: The ID of the Amazon DataZone environment.
    """
    __args__ = dict()
    __args__['domainId'] = domain_id
    __args__['id'] = id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:datazone:getEnvironment', __args__, opts=opts, typ=GetEnvironmentResult).value

    return AwaitableGetEnvironmentResult(
        aws_account_id=pulumi.get(__ret__, 'aws_account_id'),
        aws_account_region=pulumi.get(__ret__, 'aws_account_region'),
        created_at=pulumi.get(__ret__, 'created_at'),
        created_by=pulumi.get(__ret__, 'created_by'),
        description=pulumi.get(__ret__, 'description'),
        domain_id=pulumi.get(__ret__, 'domain_id'),
        environment_blueprint_id=pulumi.get(__ret__, 'environment_blueprint_id'),
        environment_profile_id=pulumi.get(__ret__, 'environment_profile_id'),
        glossary_terms=pulumi.get(__ret__, 'glossary_terms'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        project_id=pulumi.get(__ret__, 'project_id'),
        provider=pulumi.get(__ret__, 'provider'),
        status=pulumi.get(__ret__, 'status'),
        updated_at=pulumi.get(__ret__, 'updated_at'))
def get_environment_output(domain_id: Optional[pulumi.Input[builtins.str]] = None,
                           id: Optional[pulumi.Input[builtins.str]] = None,
                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetEnvironmentResult]:
    """
    Definition of AWS::DataZone::Environment Resource Type


    :param builtins.str domain_id: The identifier of the Amazon DataZone domain in which the environment is created.
    :param builtins.str id: The ID of the Amazon DataZone environment.
    """
    __args__ = dict()
    __args__['domainId'] = domain_id
    __args__['id'] = id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:datazone:getEnvironment', __args__, opts=opts, typ=GetEnvironmentResult)
    return __ret__.apply(lambda __response__: GetEnvironmentResult(
        aws_account_id=pulumi.get(__response__, 'aws_account_id'),
        aws_account_region=pulumi.get(__response__, 'aws_account_region'),
        created_at=pulumi.get(__response__, 'created_at'),
        created_by=pulumi.get(__response__, 'created_by'),
        description=pulumi.get(__response__, 'description'),
        domain_id=pulumi.get(__response__, 'domain_id'),
        environment_blueprint_id=pulumi.get(__response__, 'environment_blueprint_id'),
        environment_profile_id=pulumi.get(__response__, 'environment_profile_id'),
        glossary_terms=pulumi.get(__response__, 'glossary_terms'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        project_id=pulumi.get(__response__, 'project_id'),
        provider=pulumi.get(__response__, 'provider'),
        status=pulumi.get(__response__, 'status'),
        updated_at=pulumi.get(__response__, 'updated_at')))
