# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetDomainUnitResult',
    'AwaitableGetDomainUnitResult',
    'get_domain_unit',
    'get_domain_unit_output',
]

@pulumi.output_type
class GetDomainUnitResult:
    def __init__(__self__, created_at=None, description=None, domain_id=None, id=None, identifier=None, last_updated_at=None, name=None, parent_domain_unit_id=None):
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if domain_id and not isinstance(domain_id, str):
            raise TypeError("Expected argument 'domain_id' to be a str")
        pulumi.set(__self__, "domain_id", domain_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if identifier and not isinstance(identifier, str):
            raise TypeError("Expected argument 'identifier' to be a str")
        pulumi.set(__self__, "identifier", identifier)
        if last_updated_at and not isinstance(last_updated_at, str):
            raise TypeError("Expected argument 'last_updated_at' to be a str")
        pulumi.set(__self__, "last_updated_at", last_updated_at)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if parent_domain_unit_id and not isinstance(parent_domain_unit_id, str):
            raise TypeError("Expected argument 'parent_domain_unit_id' to be a str")
        pulumi.set(__self__, "parent_domain_unit_id", parent_domain_unit_id)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[builtins.str]:
        """
        The timestamp at which the domain unit was created.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        The description of the domain unit.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="domainId")
    def domain_id(self) -> Optional[builtins.str]:
        """
        The ID of the domain where the domain unit was created.
        """
        return pulumi.get(self, "domain_id")

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        The ID of the domain unit.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def identifier(self) -> Optional[builtins.str]:
        """
        The identifier of the domain unit that you want to get.
        """
        return pulumi.get(self, "identifier")

    @property
    @pulumi.getter(name="lastUpdatedAt")
    def last_updated_at(self) -> Optional[builtins.str]:
        """
        The timestamp at which the domain unit was last updated.
        """
        return pulumi.get(self, "last_updated_at")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        The name of the domain unit.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="parentDomainUnitId")
    def parent_domain_unit_id(self) -> Optional[builtins.str]:
        """
        The ID of the parent domain unit.
        """
        return pulumi.get(self, "parent_domain_unit_id")


class AwaitableGetDomainUnitResult(GetDomainUnitResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDomainUnitResult(
            created_at=self.created_at,
            description=self.description,
            domain_id=self.domain_id,
            id=self.id,
            identifier=self.identifier,
            last_updated_at=self.last_updated_at,
            name=self.name,
            parent_domain_unit_id=self.parent_domain_unit_id)


def get_domain_unit(domain_id: Optional[builtins.str] = None,
                    id: Optional[builtins.str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDomainUnitResult:
    """
    A domain unit enables you to easily organize your assets and other domain entities under specific business units and teams.


    :param builtins.str domain_id: The ID of the domain where the domain unit was created.
    :param builtins.str id: The ID of the domain unit.
    """
    __args__ = dict()
    __args__['domainId'] = domain_id
    __args__['id'] = id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:datazone:getDomainUnit', __args__, opts=opts, typ=GetDomainUnitResult).value

    return AwaitableGetDomainUnitResult(
        created_at=pulumi.get(__ret__, 'created_at'),
        description=pulumi.get(__ret__, 'description'),
        domain_id=pulumi.get(__ret__, 'domain_id'),
        id=pulumi.get(__ret__, 'id'),
        identifier=pulumi.get(__ret__, 'identifier'),
        last_updated_at=pulumi.get(__ret__, 'last_updated_at'),
        name=pulumi.get(__ret__, 'name'),
        parent_domain_unit_id=pulumi.get(__ret__, 'parent_domain_unit_id'))
def get_domain_unit_output(domain_id: Optional[pulumi.Input[builtins.str]] = None,
                           id: Optional[pulumi.Input[builtins.str]] = None,
                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDomainUnitResult]:
    """
    A domain unit enables you to easily organize your assets and other domain entities under specific business units and teams.


    :param builtins.str domain_id: The ID of the domain where the domain unit was created.
    :param builtins.str id: The ID of the domain unit.
    """
    __args__ = dict()
    __args__['domainId'] = domain_id
    __args__['id'] = id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:datazone:getDomainUnit', __args__, opts=opts, typ=GetDomainUnitResult)
    return __ret__.apply(lambda __response__: GetDomainUnitResult(
        created_at=pulumi.get(__response__, 'created_at'),
        description=pulumi.get(__response__, 'description'),
        domain_id=pulumi.get(__response__, 'domain_id'),
        id=pulumi.get(__response__, 'id'),
        identifier=pulumi.get(__response__, 'identifier'),
        last_updated_at=pulumi.get(__response__, 'last_updated_at'),
        name=pulumi.get(__response__, 'name'),
        parent_domain_unit_id=pulumi.get(__response__, 'parent_domain_unit_id')))
