# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetConnectionResult',
    'AwaitableGetConnectionResult',
    'get_connection',
    'get_connection_output',
]

@pulumi.output_type
class GetConnectionResult:
    def __init__(__self__, connection_id=None, description=None, domain_id=None, domain_unit_id=None, environment_id=None, environment_user_role=None, project_id=None, type=None):
        if connection_id and not isinstance(connection_id, str):
            raise TypeError("Expected argument 'connection_id' to be a str")
        pulumi.set(__self__, "connection_id", connection_id)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if domain_id and not isinstance(domain_id, str):
            raise TypeError("Expected argument 'domain_id' to be a str")
        pulumi.set(__self__, "domain_id", domain_id)
        if domain_unit_id and not isinstance(domain_unit_id, str):
            raise TypeError("Expected argument 'domain_unit_id' to be a str")
        pulumi.set(__self__, "domain_unit_id", domain_unit_id)
        if environment_id and not isinstance(environment_id, str):
            raise TypeError("Expected argument 'environment_id' to be a str")
        pulumi.set(__self__, "environment_id", environment_id)
        if environment_user_role and not isinstance(environment_user_role, str):
            raise TypeError("Expected argument 'environment_user_role' to be a str")
        pulumi.set(__self__, "environment_user_role", environment_user_role)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="connectionId")
    def connection_id(self) -> Optional[builtins.str]:
        """
        The ID of the connection.
        """
        return pulumi.get(self, "connection_id")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        The description of the connection.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="domainId")
    def domain_id(self) -> Optional[builtins.str]:
        """
        The ID of the domain in which the connection is created.
        """
        return pulumi.get(self, "domain_id")

    @property
    @pulumi.getter(name="domainUnitId")
    def domain_unit_id(self) -> Optional[builtins.str]:
        """
        The ID of the domain unit in which the connection is created.
        """
        return pulumi.get(self, "domain_unit_id")

    @property
    @pulumi.getter(name="environmentId")
    def environment_id(self) -> Optional[builtins.str]:
        """
        The ID of the environment in which the connection is created.
        """
        return pulumi.get(self, "environment_id")

    @property
    @pulumi.getter(name="environmentUserRole")
    def environment_user_role(self) -> Optional[builtins.str]:
        """
        The role of the user in the environment.
        """
        return pulumi.get(self, "environment_user_role")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[builtins.str]:
        """
        The ID of the project in which the connection is created.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def type(self) -> Optional[builtins.str]:
        """
        The type of the connection.
        """
        return pulumi.get(self, "type")


class AwaitableGetConnectionResult(GetConnectionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetConnectionResult(
            connection_id=self.connection_id,
            description=self.description,
            domain_id=self.domain_id,
            domain_unit_id=self.domain_unit_id,
            environment_id=self.environment_id,
            environment_user_role=self.environment_user_role,
            project_id=self.project_id,
            type=self.type)


def get_connection(connection_id: Optional[builtins.str] = None,
                   domain_id: Optional[builtins.str] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetConnectionResult:
    """
    Connections enables users to connect their DataZone resources (domains, projects, and environments) to external resources/services (data, compute, etc)


    :param builtins.str connection_id: The ID of the connection.
    :param builtins.str domain_id: The ID of the domain in which the connection is created.
    """
    __args__ = dict()
    __args__['connectionId'] = connection_id
    __args__['domainId'] = domain_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:datazone:getConnection', __args__, opts=opts, typ=GetConnectionResult).value

    return AwaitableGetConnectionResult(
        connection_id=pulumi.get(__ret__, 'connection_id'),
        description=pulumi.get(__ret__, 'description'),
        domain_id=pulumi.get(__ret__, 'domain_id'),
        domain_unit_id=pulumi.get(__ret__, 'domain_unit_id'),
        environment_id=pulumi.get(__ret__, 'environment_id'),
        environment_user_role=pulumi.get(__ret__, 'environment_user_role'),
        project_id=pulumi.get(__ret__, 'project_id'),
        type=pulumi.get(__ret__, 'type'))
def get_connection_output(connection_id: Optional[pulumi.Input[builtins.str]] = None,
                          domain_id: Optional[pulumi.Input[builtins.str]] = None,
                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetConnectionResult]:
    """
    Connections enables users to connect their DataZone resources (domains, projects, and environments) to external resources/services (data, compute, etc)


    :param builtins.str connection_id: The ID of the connection.
    :param builtins.str domain_id: The ID of the domain in which the connection is created.
    """
    __args__ = dict()
    __args__['connectionId'] = connection_id
    __args__['domainId'] = domain_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:datazone:getConnection', __args__, opts=opts, typ=GetConnectionResult)
    return __ret__.apply(lambda __response__: GetConnectionResult(
        connection_id=pulumi.get(__response__, 'connection_id'),
        description=pulumi.get(__response__, 'description'),
        domain_id=pulumi.get(__response__, 'domain_id'),
        domain_unit_id=pulumi.get(__response__, 'domain_unit_id'),
        environment_id=pulumi.get(__response__, 'environment_id'),
        environment_user_role=pulumi.get(__response__, 'environment_user_role'),
        project_id=pulumi.get(__response__, 'project_id'),
        type=pulumi.get(__response__, 'type')))
