# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['EnvironmentActionsArgs', 'EnvironmentActions']

@pulumi.input_type
class EnvironmentActionsArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 domain_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 environment_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 identifier: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 parameters: Optional[pulumi.Input['EnvironmentActionsAwsConsoleLinkParametersArgs']] = None):
        """
        The set of arguments for constructing a EnvironmentActions resource.
        :param pulumi.Input[builtins.str] description: The description of the Amazon DataZone environment action.
        :param pulumi.Input[builtins.str] domain_identifier: The identifier of the Amazon DataZone domain in which the environment would be created.
        :param pulumi.Input[builtins.str] environment_identifier: The identifier of the Amazon DataZone environment in which the action is taking place
        :param pulumi.Input[builtins.str] identifier: The ID of the Amazon DataZone environment action.
        :param pulumi.Input[builtins.str] name: The name of the environment action.
        :param pulumi.Input['EnvironmentActionsAwsConsoleLinkParametersArgs'] parameters: The parameters of the environment action.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if domain_identifier is not None:
            pulumi.set(__self__, "domain_identifier", domain_identifier)
        if environment_identifier is not None:
            pulumi.set(__self__, "environment_identifier", environment_identifier)
        if identifier is not None:
            pulumi.set(__self__, "identifier", identifier)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description of the Amazon DataZone environment action.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="domainIdentifier")
    def domain_identifier(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The identifier of the Amazon DataZone domain in which the environment would be created.
        """
        return pulumi.get(self, "domain_identifier")

    @domain_identifier.setter
    def domain_identifier(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "domain_identifier", value)

    @property
    @pulumi.getter(name="environmentIdentifier")
    def environment_identifier(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The identifier of the Amazon DataZone environment in which the action is taking place
        """
        return pulumi.get(self, "environment_identifier")

    @environment_identifier.setter
    def environment_identifier(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "environment_identifier", value)

    @property
    @pulumi.getter
    def identifier(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the Amazon DataZone environment action.
        """
        return pulumi.get(self, "identifier")

    @identifier.setter
    def identifier(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "identifier", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the environment action.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input['EnvironmentActionsAwsConsoleLinkParametersArgs']]:
        """
        The parameters of the environment action.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input['EnvironmentActionsAwsConsoleLinkParametersArgs']]):
        pulumi.set(self, "parameters", value)


@pulumi.type_token("aws-native:datazone:EnvironmentActions")
class EnvironmentActions(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 domain_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 environment_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 identifier: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 parameters: Optional[pulumi.Input[Union['EnvironmentActionsAwsConsoleLinkParametersArgs', 'EnvironmentActionsAwsConsoleLinkParametersArgsDict']]] = None,
                 __props__=None):
        """
        Definition of AWS::DataZone::EnvironmentActions Resource Type

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] description: The description of the Amazon DataZone environment action.
        :param pulumi.Input[builtins.str] domain_identifier: The identifier of the Amazon DataZone domain in which the environment would be created.
        :param pulumi.Input[builtins.str] environment_identifier: The identifier of the Amazon DataZone environment in which the action is taking place
        :param pulumi.Input[builtins.str] identifier: The ID of the Amazon DataZone environment action.
        :param pulumi.Input[builtins.str] name: The name of the environment action.
        :param pulumi.Input[Union['EnvironmentActionsAwsConsoleLinkParametersArgs', 'EnvironmentActionsAwsConsoleLinkParametersArgsDict']] parameters: The parameters of the environment action.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[EnvironmentActionsArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Definition of AWS::DataZone::EnvironmentActions Resource Type

        :param str resource_name: The name of the resource.
        :param EnvironmentActionsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EnvironmentActionsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 domain_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 environment_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 identifier: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 parameters: Optional[pulumi.Input[Union['EnvironmentActionsAwsConsoleLinkParametersArgs', 'EnvironmentActionsAwsConsoleLinkParametersArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EnvironmentActionsArgs.__new__(EnvironmentActionsArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["domain_identifier"] = domain_identifier
            __props__.__dict__["environment_identifier"] = environment_identifier
            __props__.__dict__["identifier"] = identifier
            __props__.__dict__["name"] = name
            __props__.__dict__["parameters"] = parameters
            __props__.__dict__["aws_id"] = None
            __props__.__dict__["domain_id"] = None
            __props__.__dict__["environment_id"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["domainIdentifier", "environmentIdentifier"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(EnvironmentActions, __self__).__init__(
            'aws-native:datazone:EnvironmentActions',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'EnvironmentActions':
        """
        Get an existing EnvironmentActions resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = EnvironmentActionsArgs.__new__(EnvironmentActionsArgs)

        __props__.__dict__["aws_id"] = None
        __props__.__dict__["description"] = None
        __props__.__dict__["domain_id"] = None
        __props__.__dict__["domain_identifier"] = None
        __props__.__dict__["environment_id"] = None
        __props__.__dict__["environment_identifier"] = None
        __props__.__dict__["identifier"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["parameters"] = None
        return EnvironmentActions(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="awsId")
    def aws_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the Amazon DataZone environment action.
        """
        return pulumi.get(self, "aws_id")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The description of the Amazon DataZone environment action.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="domainId")
    def domain_id(self) -> pulumi.Output[builtins.str]:
        """
        The identifier of the Amazon DataZone domain in which the environment is created.
        """
        return pulumi.get(self, "domain_id")

    @property
    @pulumi.getter(name="domainIdentifier")
    def domain_identifier(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The identifier of the Amazon DataZone domain in which the environment would be created.
        """
        return pulumi.get(self, "domain_identifier")

    @property
    @pulumi.getter(name="environmentId")
    def environment_id(self) -> pulumi.Output[builtins.str]:
        """
        The identifier of the Amazon DataZone environment in which the action is taking place
        """
        return pulumi.get(self, "environment_id")

    @property
    @pulumi.getter(name="environmentIdentifier")
    def environment_identifier(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The identifier of the Amazon DataZone environment in which the action is taking place
        """
        return pulumi.get(self, "environment_identifier")

    @property
    @pulumi.getter
    def identifier(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The ID of the Amazon DataZone environment action.
        """
        return pulumi.get(self, "identifier")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the environment action.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def parameters(self) -> pulumi.Output[Optional['outputs.EnvironmentActionsAwsConsoleLinkParameters']]:
        """
        The parameters of the environment action.
        """
        return pulumi.get(self, "parameters")

