# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._enums import *
from ._inputs import *

__all__ = ['DomainArgs', 'Domain']

@pulumi.input_type
class DomainArgs:
    def __init__(__self__, *,
                 domain_execution_role: pulumi.Input[builtins.str],
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 domain_version: Optional[pulumi.Input['DomainVersion']] = None,
                 kms_key_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 service_role: Optional[pulumi.Input[builtins.str]] = None,
                 single_sign_on: Optional[pulumi.Input['DomainSingleSignOnArgs']] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None):
        """
        The set of arguments for constructing a Domain resource.
        :param pulumi.Input[builtins.str] domain_execution_role: The domain execution role that is created when an Amazon DataZone domain is created. The domain execution role is created in the AWS account that houses the Amazon DataZone domain.
        :param pulumi.Input[builtins.str] description: The description of the Amazon DataZone domain.
        :param pulumi.Input['DomainVersion'] domain_version: The version of the domain.
        :param pulumi.Input[builtins.str] kms_key_identifier: The identifier of the AWS Key Management Service (KMS) key that is used to encrypt the Amazon DataZone domain, metadata, and reporting data.
        :param pulumi.Input[builtins.str] name: The name of the Amazon DataZone domain.
        :param pulumi.Input[builtins.str] service_role: The service role of the domain that is created.
        :param pulumi.Input['DomainSingleSignOnArgs'] single_sign_on: The single-sign on configuration of the Amazon DataZone domain.
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: The tags specified for the Amazon DataZone domain.
        """
        pulumi.set(__self__, "domain_execution_role", domain_execution_role)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if domain_version is not None:
            pulumi.set(__self__, "domain_version", domain_version)
        if kms_key_identifier is not None:
            pulumi.set(__self__, "kms_key_identifier", kms_key_identifier)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if service_role is not None:
            pulumi.set(__self__, "service_role", service_role)
        if single_sign_on is not None:
            pulumi.set(__self__, "single_sign_on", single_sign_on)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="domainExecutionRole")
    def domain_execution_role(self) -> pulumi.Input[builtins.str]:
        """
        The domain execution role that is created when an Amazon DataZone domain is created. The domain execution role is created in the AWS account that houses the Amazon DataZone domain.
        """
        return pulumi.get(self, "domain_execution_role")

    @domain_execution_role.setter
    def domain_execution_role(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "domain_execution_role", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description of the Amazon DataZone domain.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="domainVersion")
    def domain_version(self) -> Optional[pulumi.Input['DomainVersion']]:
        """
        The version of the domain.
        """
        return pulumi.get(self, "domain_version")

    @domain_version.setter
    def domain_version(self, value: Optional[pulumi.Input['DomainVersion']]):
        pulumi.set(self, "domain_version", value)

    @property
    @pulumi.getter(name="kmsKeyIdentifier")
    def kms_key_identifier(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The identifier of the AWS Key Management Service (KMS) key that is used to encrypt the Amazon DataZone domain, metadata, and reporting data.
        """
        return pulumi.get(self, "kms_key_identifier")

    @kms_key_identifier.setter
    def kms_key_identifier(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kms_key_identifier", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Amazon DataZone domain.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="serviceRole")
    def service_role(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The service role of the domain that is created.
        """
        return pulumi.get(self, "service_role")

    @service_role.setter
    def service_role(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "service_role", value)

    @property
    @pulumi.getter(name="singleSignOn")
    def single_sign_on(self) -> Optional[pulumi.Input['DomainSingleSignOnArgs']]:
        """
        The single-sign on configuration of the Amazon DataZone domain.
        """
        return pulumi.get(self, "single_sign_on")

    @single_sign_on.setter
    def single_sign_on(self, value: Optional[pulumi.Input['DomainSingleSignOnArgs']]):
        pulumi.set(self, "single_sign_on", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        The tags specified for the Amazon DataZone domain.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("aws-native:datazone:Domain")
class Domain(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 domain_execution_role: Optional[pulumi.Input[builtins.str]] = None,
                 domain_version: Optional[pulumi.Input['DomainVersion']] = None,
                 kms_key_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 service_role: Optional[pulumi.Input[builtins.str]] = None,
                 single_sign_on: Optional[pulumi.Input[Union['DomainSingleSignOnArgs', 'DomainSingleSignOnArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        """
        A domain is an organizing entity for connecting together assets, users, and their projects

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] description: The description of the Amazon DataZone domain.
        :param pulumi.Input[builtins.str] domain_execution_role: The domain execution role that is created when an Amazon DataZone domain is created. The domain execution role is created in the AWS account that houses the Amazon DataZone domain.
        :param pulumi.Input['DomainVersion'] domain_version: The version of the domain.
        :param pulumi.Input[builtins.str] kms_key_identifier: The identifier of the AWS Key Management Service (KMS) key that is used to encrypt the Amazon DataZone domain, metadata, and reporting data.
        :param pulumi.Input[builtins.str] name: The name of the Amazon DataZone domain.
        :param pulumi.Input[builtins.str] service_role: The service role of the domain that is created.
        :param pulumi.Input[Union['DomainSingleSignOnArgs', 'DomainSingleSignOnArgsDict']] single_sign_on: The single-sign on configuration of the Amazon DataZone domain.
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: The tags specified for the Amazon DataZone domain.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DomainArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A domain is an organizing entity for connecting together assets, users, and their projects

        :param str resource_name: The name of the resource.
        :param DomainArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DomainArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 domain_execution_role: Optional[pulumi.Input[builtins.str]] = None,
                 domain_version: Optional[pulumi.Input['DomainVersion']] = None,
                 kms_key_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 service_role: Optional[pulumi.Input[builtins.str]] = None,
                 single_sign_on: Optional[pulumi.Input[Union['DomainSingleSignOnArgs', 'DomainSingleSignOnArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DomainArgs.__new__(DomainArgs)

            __props__.__dict__["description"] = description
            if domain_execution_role is None and not opts.urn:
                raise TypeError("Missing required property 'domain_execution_role'")
            __props__.__dict__["domain_execution_role"] = domain_execution_role
            __props__.__dict__["domain_version"] = domain_version
            __props__.__dict__["kms_key_identifier"] = kms_key_identifier
            __props__.__dict__["name"] = name
            __props__.__dict__["service_role"] = service_role
            __props__.__dict__["single_sign_on"] = single_sign_on
            __props__.__dict__["tags"] = tags
            __props__.__dict__["arn"] = None
            __props__.__dict__["aws_id"] = None
            __props__.__dict__["created_at"] = None
            __props__.__dict__["last_updated_at"] = None
            __props__.__dict__["managed_account_id"] = None
            __props__.__dict__["portal_url"] = None
            __props__.__dict__["root_domain_unit_id"] = None
            __props__.__dict__["status"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["domainVersion", "kmsKeyIdentifier"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(Domain, __self__).__init__(
            'aws-native:datazone:Domain',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Domain':
        """
        Get an existing Domain resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = DomainArgs.__new__(DomainArgs)

        __props__.__dict__["arn"] = None
        __props__.__dict__["aws_id"] = None
        __props__.__dict__["created_at"] = None
        __props__.__dict__["description"] = None
        __props__.__dict__["domain_execution_role"] = None
        __props__.__dict__["domain_version"] = None
        __props__.__dict__["kms_key_identifier"] = None
        __props__.__dict__["last_updated_at"] = None
        __props__.__dict__["managed_account_id"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["portal_url"] = None
        __props__.__dict__["root_domain_unit_id"] = None
        __props__.__dict__["service_role"] = None
        __props__.__dict__["single_sign_on"] = None
        __props__.__dict__["status"] = None
        __props__.__dict__["tags"] = None
        return Domain(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[builtins.str]:
        """
        The ARN of the Amazon DataZone domain.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="awsId")
    def aws_id(self) -> pulumi.Output[builtins.str]:
        """
        The id of the Amazon DataZone domain.
        """
        return pulumi.get(self, "aws_id")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[builtins.str]:
        """
        The timestamp of when the Amazon DataZone domain was last updated.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The description of the Amazon DataZone domain.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="domainExecutionRole")
    def domain_execution_role(self) -> pulumi.Output[builtins.str]:
        """
        The domain execution role that is created when an Amazon DataZone domain is created. The domain execution role is created in the AWS account that houses the Amazon DataZone domain.
        """
        return pulumi.get(self, "domain_execution_role")

    @property
    @pulumi.getter(name="domainVersion")
    def domain_version(self) -> pulumi.Output[Optional['DomainVersion']]:
        """
        The version of the domain.
        """
        return pulumi.get(self, "domain_version")

    @property
    @pulumi.getter(name="kmsKeyIdentifier")
    def kms_key_identifier(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The identifier of the AWS Key Management Service (KMS) key that is used to encrypt the Amazon DataZone domain, metadata, and reporting data.
        """
        return pulumi.get(self, "kms_key_identifier")

    @property
    @pulumi.getter(name="lastUpdatedAt")
    def last_updated_at(self) -> pulumi.Output[builtins.str]:
        """
        The timestamp of when the Amazon DataZone domain was last updated.
        """
        return pulumi.get(self, "last_updated_at")

    @property
    @pulumi.getter(name="managedAccountId")
    def managed_account_id(self) -> pulumi.Output[builtins.str]:
        """
        The identifier of the AWS account that manages the domain.
        """
        return pulumi.get(self, "managed_account_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the Amazon DataZone domain.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="portalUrl")
    def portal_url(self) -> pulumi.Output[builtins.str]:
        """
        The URL of the data portal for this Amazon DataZone domain.
        """
        return pulumi.get(self, "portal_url")

    @property
    @pulumi.getter(name="rootDomainUnitId")
    def root_domain_unit_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the root domain in Amazon Datazone.
        """
        return pulumi.get(self, "root_domain_unit_id")

    @property
    @pulumi.getter(name="serviceRole")
    def service_role(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The service role of the domain that is created.
        """
        return pulumi.get(self, "service_role")

    @property
    @pulumi.getter(name="singleSignOn")
    def single_sign_on(self) -> pulumi.Output[Optional['outputs.DomainSingleSignOn']]:
        """
        The single-sign on configuration of the Amazon DataZone domain.
        """
        return pulumi.get(self, "single_sign_on")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output['DomainStatus']:
        """
        The status of the Amazon DataZone domain.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        The tags specified for the Amazon DataZone domain.
        """
        return pulumi.get(self, "tags")

